/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class XDRInputStream
extends DataInputStream
implements XDRDataInput {
    private CountedInputStream cin;

    public XDRInputStream(InputStream in) {
        super(new CountedInputStream(in));
        this.cin = (CountedInputStream)this.in;
    }

    public long getBytesRead() {
        return this.cin.getBytesRead();
    }

    public void setReadLimit(int bytes) {
        this.cin.setReadLimit(bytes);
    }

    public void clearReadLimit() {
        this.cin.clearReadLimit();
    }

    public void pad() throws IOException {
        int offset = (int)(this.getBytesRead() % 4L);
        if (offset != 0) {
            this.skipBytes(4 - offset);
        }
    }

    public double[] readDoubleArray(double[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        double[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new double[l];
        }
        int i = 0;
        while (i < l) {
            result[i] = this.readDouble();
            ++i;
        }
        return result;
    }

    public float[] readFloatArray(float[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        float[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new float[l];
        }
        int i = 0;
        while (i < l) {
            result[i] = this.readFloat();
            ++i;
        }
        return result;
    }

    public int[] readIntArray(int[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        int[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new int[l];
        }
        int i = 0;
        while (i < l) {
            result[i] = this.readInt();
            ++i;
        }
        return result;
    }

    public String readString(int l) throws IOException {
        byte[] ascii = new byte[l];
        this.readFully(ascii);
        this.pad();
        return new String(ascii);
    }

    public String readString() throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        return this.readString(l);
    }

    private static final class CountedInputStream
    extends BufferedInputStream {
        private long count = 0L;
        private long limit = -1L;
        private long mark = 0L;

        CountedInputStream(InputStream in) {
            super(in);
        }

        public long getBytesRead() {
            return this.count;
        }

        public int available() throws IOException {
            return Math.min((int)(this.limit - this.count), super.available());
        }

        public synchronized void mark(int readlimit) {
            this.mark = this.count;
            super.mark(readlimit);
        }

        public int read() throws IOException {
            int available = this.checkLimit(1);
            int rc = super.read();
            if (rc >= 0) {
                ++this.count;
            }
            return rc;
        }

        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        public int read(byte[] data, int off, int len) throws IOException {
            int available = this.checkLimit(len);
            int rc = super.read(data, off, available);
            if (rc > 0) {
                this.count += (long)rc;
            }
            return rc;
        }

        public synchronized void reset() throws IOException {
            this.count = this.mark;
            super.reset();
        }

        public long skip(long bytes) throws IOException {
            long available = this.checkLimit(bytes);
            long rc = super.skip(available);
            if (rc > 0L) {
                this.count += rc;
            }
            return rc;
        }

        void setReadLimit(int bytes) {
            this.limit = this.count + (long)bytes;
        }

        void clearReadLimit() {
            this.limit = -1L;
        }

        private int checkLimit(int request) throws IOException {
            if (this.limit < 0L) {
                return request;
            }
            if (this.limit <= this.count) {
                throw new EOFException();
            }
            return Math.min(request, (int)(this.limit - this.count));
        }

        private long checkLimit(long request) throws IOException {
            if (this.limit < 0L) {
                return request;
            }
            if (this.limit <= this.count) {
                throw new EOFException();
            }
            return Math.min(request, this.limit - this.count);
        }
    }
}

