/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XDROutputStream
extends DataOutputStream
implements XDRDataOutput {
    private CountedOutputStream cout;
    private static final byte[] padding = new byte[4];

    public XDROutputStream(OutputStream out) {
        super(new CountedOutputStream(out));
        this.cout = (CountedOutputStream)this.out;
    }

    public void writeString(String s) throws IOException {
        this.writeInt(s.length());
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    public void writeStringChars(String s) throws IOException {
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    public void writeIntArray(int[] array) throws IOException {
        this.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            this.writeInt(array[i]);
            ++i;
        }
    }

    public void writeIntArray(int[] array, int start, int n) throws IOException {
        this.writeInt(n);
        int i = start;
        while (i < n) {
            this.writeInt(array[i]);
            ++i;
        }
    }

    public void writeDoubleArray(double[] array) throws IOException {
        this.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            this.writeDouble(array[i]);
            ++i;
        }
    }

    public void writeDoubleArray(double[] array, int start, int n) throws IOException {
        this.writeInt(n);
        int i = start;
        while (i < n) {
            this.writeDouble(array[i]);
            ++i;
        }
    }

    public void writeFloatArray(float[] array) throws IOException {
        this.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            this.writeFloat(array[i]);
            ++i;
        }
    }

    public void writeFloatArray(float[] array, int start, int n) throws IOException {
        this.writeInt(n);
        int i = start;
        while (i < n) {
            this.writeFloat(array[i]);
            ++i;
        }
    }

    public void pad() throws IOException {
        int offset = (int)(this.getBytesWritten() % 4L);
        if (offset != 0) {
            this.write(padding, 0, 4 - offset);
        }
    }

    public long getBytesWritten() {
        return this.cout.getBytesWritten();
    }

    private static final class CountedOutputStream
    extends FilterOutputStream {
        private long count = 0L;

        CountedOutputStream(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.count;
        }

        public void write(byte[] data) throws IOException {
            this.out.write(data);
            this.count += (long)data.length;
        }

        public void write(byte[] data, int off, int len) throws IOException {
            this.out.write(data, off, len);
            this.count += (long)len;
        }

        public long getBytesWritten() {
            return this.count;
        }
    }
}

