/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XDRRandomAccessFile
extends RandomAccessFile
implements XDRDataInput,
XDRDataOutput {
    public XDRRandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    public void pad() throws IOException {
        int offset = (int)(this.getFilePointer() % 4L);
        if (offset != 0) {
            this.skipBytes(4 - offset);
        }
    }

    public double[] readDoubleArray(double[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        double[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new double[l];
        }
        int i = 0;
        while (i < l) {
            result[i] = this.readDouble();
            ++i;
        }
        return result;
    }

    public float[] readFloatArray(float[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        float[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new float[l];
        }
        int i = 0;
        while (i < l) {
            result[i] = this.readFloat();
            ++i;
        }
        return result;
    }

    public int[] readIntArray(int[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        int[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new int[l];
        }
        int i = 0;
        while (i < l) {
            result[i] = this.readInt();
            ++i;
        }
        return result;
    }

    public String readString(int l) throws IOException {
        byte[] ascii = new byte[l];
        this.readFully(ascii);
        this.pad();
        return new String(ascii);
    }

    public String readString() throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        return this.readString(l);
    }

    public void writeDoubleArray(double[] array) throws IOException {
        this.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            this.writeDouble(array[i]);
            ++i;
        }
    }

    public void writeDoubleArray(double[] array, int start, int n) throws IOException {
        this.writeInt(n);
        int i = start;
        while (i < n) {
            this.writeDouble(array[i]);
            ++i;
        }
    }

    public void writeFloatArray(float[] array) throws IOException {
        this.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            this.writeFloat(array[i]);
            ++i;
        }
    }

    public void writeFloatArray(float[] array, int start, int n) throws IOException {
        this.writeInt(n);
        int i = start;
        while (i < n) {
            this.writeFloat(array[i]);
            ++i;
        }
    }

    public void writeIntArray(int[] array) throws IOException {
        this.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            this.writeInt(array[i]);
            ++i;
        }
    }

    public void writeIntArray(int[] array, int start, int n) throws IOException {
        this.writeInt(n);
        int i = start;
        while (i < n) {
            this.writeInt(array[i]);
            ++i;
        }
    }

    public void writeString(String s) throws IOException {
        this.writeInt(s.length());
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    public void writeStringChars(String s) throws IOException {
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }
}

