/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import org.glassfish.grizzly.connectionpool.Link;

final class Chain<E> {
    private int size;
    private Link<E> firstLink;
    private Link<E> lastLink;

    Chain() {
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public Link<E> getFirstLink() {
        return this.firstLink;
    }

    public Link<E> getLastLink() {
        return this.lastLink;
    }

    public void offerFirst(Link<E> link) {
        if (link.isAttached()) {
            throw new IllegalStateException("Already linked");
        }
        link.next = this.firstLink;
        if (this.firstLink != null) {
            this.firstLink.prev = link;
        }
        this.firstLink = link;
        if (this.lastLink == null) {
            this.lastLink = this.firstLink;
        }
        link.attach();
        ++this.size;
    }

    public void offerLast(Link<E> link) {
        if (link.isAttached()) {
            throw new IllegalStateException("Already linked");
        }
        link.prev = this.lastLink;
        if (this.lastLink != null) {
            this.lastLink.next = link;
        }
        this.lastLink = link;
        if (this.firstLink == null) {
            this.firstLink = this.lastLink;
        }
        link.attach();
        ++this.size;
    }

    public Link<E> pollLast() {
        if (this.lastLink == null) {
            return null;
        }
        Link<E> link = this.lastLink;
        this.lastLink = link.prev;
        if (this.lastLink == null) {
            this.firstLink = null;
        } else {
            this.lastLink.next = null;
        }
        link.detach();
        --this.size;
        return link;
    }

    public Link<E> pollFirst() {
        if (this.firstLink == null) {
            return null;
        }
        Link<E> link = this.firstLink;
        this.firstLink = link.next;
        if (this.firstLink == null) {
            this.lastLink = null;
        } else {
            this.firstLink.prev = null;
        }
        link.detach();
        --this.size;
        return link;
    }

    public boolean remove(Link<E> link) {
        if (!link.isAttached()) {
            return false;
        }
        Link prev = link.prev;
        Link next = link.next;
        if (prev != null) {
            prev.next = next;
        }
        if (next != null) {
            next.prev = prev;
        }
        link.detach();
        if (this.lastLink == link) {
            this.lastLink = prev;
            if (this.lastLink == null) {
                this.firstLink = null;
            }
        } else if (this.firstLink == link) {
            this.firstLink = next;
        }
        --this.size;
        return true;
    }

    public void moveTowardsHead(Link<E> link) {
        Link prev = link.prev;
        if (prev == null) {
            return;
        }
        Link next = link.next;
        Link prevPrev = prev.prev;
        if (prevPrev != null) {
            prevPrev.next = link;
        }
        link.prev = prevPrev;
        link.next = prev;
        prev.prev = link;
        prev.next = next;
        if (next != null) {
            next.prev = prev;
        }
    }
}

