/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.utils.ArraySet;

public class DefaultServlet
extends HttpServlet {
    private static final Logger LOGGER = Grizzly.logger(DefaultServlet.class);
    private final ArraySet<File> docRoots;
    private volatile int fileCacheFilterIdx = -1;

    protected DefaultServlet(ArraySet<File> docRoots) {
        this.docRoots = docRoots;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean found = false;
        String uri = this.getRelativeURI(req);
        File[] fileFolders = (File[])this.docRoots.getArray();
        if (fileFolders == null) {
            resp.setStatus(404);
            return;
        }
        File resource = null;
        for (File webDir : fileFolders) {
            File f;
            resource = new File(webDir, uri);
            boolean exists = resource.exists();
            boolean isDirectory = resource.isDirectory();
            if (exists && isDirectory && (f = new File(resource, "/index.html")).exists()) {
                resource = f;
                found = true;
                break;
            }
            if (!isDirectory && exists) {
                found = true;
                break;
            }
            found = false;
        }
        if (!found) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File not found  {0}", resource);
            }
            resp.reset();
            resp.sendError(404);
            return;
        }
        this.sendFile(req, resp, resource);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(405);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(HttpServletRequest request, HttpServletResponse response, File file) throws IOException {
        FileInputStream fis;
        String path = file.getPath();
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            response.setStatus(404);
            return;
        }
        try {
            int rd;
            String substr;
            response.setStatus(200);
            int dot = path.lastIndexOf(46);
            if (dot < 0) {
                substr = file.toString();
                dot = substr.lastIndexOf(46);
            } else {
                substr = path;
            }
            if (dot > 0) {
                String ext = substr.substring(dot + 1);
                String ct = MimeType.get((String)ext);
                if (ct != null) {
                    response.setContentType(ct);
                }
            } else {
                response.setContentType(MimeType.get((String)"html"));
            }
            long length = file.length();
            if (length <= Integer.MAX_VALUE) {
                response.setContentLength((int)length);
            }
            this.addToFileCache(request, file);
            ServletOutputStream out = response.getOutputStream();
            byte[] b = new byte[8192];
            while ((rd = fis.read(b)) > 0) {
                out.write(b, 0, rd);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ignore) {}
        }
    }

    private String getRelativeURI(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri.contains("..")) {
            return null;
        }
        String resourcesContextPath = request.getContextPath();
        if (resourcesContextPath.length() > 0) {
            if (!uri.startsWith(resourcesContextPath)) {
                return null;
            }
            uri = uri.substring(resourcesContextPath.length());
        }
        return uri;
    }

    private void addToFileCache(HttpServletRequest req, File resource) {
        Request request;
        FilterChainContext fcContext;
        FileCacheFilter fileCacheFilter;
        if (req instanceof HttpServletRequestImpl && (fileCacheFilter = this.lookupFileCache(fcContext = (request = ((HttpServletRequestImpl)req).getRequest()).getContext())) != null) {
            FileCache fileCache = fileCacheFilter.getFileCache();
            fileCache.add(request.getRequest(), resource);
        }
    }

    private FileCacheFilter lookupFileCache(FilterChainContext fcContext) {
        Filter filter;
        FilterChain fc = fcContext.getFilterChain();
        int lastFileCacheIdx = this.fileCacheFilterIdx;
        if (lastFileCacheIdx != -1 && (filter = (Filter)fc.get(lastFileCacheIdx)) instanceof FileCacheFilter) {
            return (FileCacheFilter)filter;
        }
        int size = fc.size();
        for (int i = 0; i < size; ++i) {
            Filter filter2 = (Filter)fc.get(i);
            if (!(filter2 instanceof FileCacheFilter)) continue;
            this.fileCacheFilterIdx = i;
            return (FileCacheFilter)filter2;
        }
        this.fileCacheFilterIdx = -1;
        return null;
    }
}

