/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.memory.MemoryManager;

public class HttpCodecUtils {
    public static Buffer getLongAsBuffer(MemoryManager memoryManager, long length) {
        Buffer b = memoryManager.allocate(20);
        b.allowBufferDispose(true);
        HttpUtils.longToBuffer(length, b);
        return b;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, DataChunk chunk) {
        if (chunk.isNull()) {
            return dstBuffer;
        }
        if (chunk.getType() == DataChunk.Type.Buffer) {
            BufferChunk bc = chunk.getBufferChunk();
            int length = bc.getLength();
            if (dstBuffer.remaining() < length) {
                dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, length);
            }
            dstBuffer.put(bc.getBuffer(), bc.getStart(), length);
            return dstBuffer;
        }
        return HttpCodecUtils.put(memoryManager, dstBuffer, chunk.toString());
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, String s) {
        int size = s.length();
        if (dstBuffer.remaining() < size) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, size);
        }
        for (int i = 0; i < size; ++i) {
            dstBuffer.put((byte)s.charAt(i));
        }
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer headerBuffer, byte[] array) {
        if (headerBuffer.remaining() < array.length) {
            headerBuffer = HttpCodecUtils.resizeBuffer(memoryManager, headerBuffer, array.length);
        }
        headerBuffer.put(array);
        return headerBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer headerBuffer, byte value) {
        if (!headerBuffer.hasRemaining()) {
            headerBuffer = HttpCodecUtils.resizeBuffer(memoryManager, headerBuffer, 1);
        }
        headerBuffer.put(value);
        return headerBuffer;
    }

    public static Buffer resizeBuffer(MemoryManager memoryManager, Buffer headerBuffer, int grow) {
        return memoryManager.reallocate(headerBuffer, Math.max(headerBuffer.capacity() + grow, headerBuffer.capacity() * 3 / 2 + 1));
    }
}

