/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.net.FileNameMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MimeMap
implements FileNameMap {
    public static final Map<String, String> DEFAULT_MAP = new HashMap<String, String>(103);
    private final Map<String, String> map = new HashMap<String, String>();

    public void addContentType(String ext, String type) {
        this.map.put(ext, type.toLowerCase());
    }

    public Iterator<String> getExtensions() {
        return this.map.keySet().iterator();
    }

    public String getContentType(String ext) {
        String type = this.map.get(ext.toLowerCase());
        if (type == null) {
            type = DEFAULT_MAP.get(ext);
        }
        return type;
    }

    public void removeContentType(String ext) {
        this.map.remove(ext.toLowerCase());
    }

    public static String getExtension(String fileName) {
        int i;
        int length = fileName.length();
        int newEnd = fileName.lastIndexOf(35);
        if (newEnd == -1) {
            newEnd = length;
        }
        return (i = fileName.lastIndexOf(46, newEnd)) != -1 ? fileName.substring(i + 1, newEnd) : null;
    }

    @Override
    public String getContentTypeFor(String fileName) {
        String ext = MimeMap.getExtension(fileName);
        return ext != null ? this.getContentType(ext) : null;
    }

    static {
        DEFAULT_MAP.put("txt", "text/plain");
        DEFAULT_MAP.put("html", "text/html");
        DEFAULT_MAP.put("htm", "text/html");
        DEFAULT_MAP.put("gif", "image/gif");
        DEFAULT_MAP.put("jpg", "image/jpeg");
        DEFAULT_MAP.put("jpe", "image/jpeg");
        DEFAULT_MAP.put("jpeg", "image/jpeg");
        DEFAULT_MAP.put("java", "text/plain");
        DEFAULT_MAP.put("js", "text/javascript");
        DEFAULT_MAP.put("css", "text/css");
        DEFAULT_MAP.put("body", "text/html");
        DEFAULT_MAP.put("rtx", "text/richtext");
        DEFAULT_MAP.put("tsv", "text/tab-separated-values");
        DEFAULT_MAP.put("etx", "text/x-setext");
        DEFAULT_MAP.put("ps", "application/x-postscript");
        DEFAULT_MAP.put("class", "application/java");
        DEFAULT_MAP.put("csh", "application/x-csh");
        DEFAULT_MAP.put("sh", "application/x-sh");
        DEFAULT_MAP.put("tcl", "application/x-tcl");
        DEFAULT_MAP.put("tex", "application/x-tex");
        DEFAULT_MAP.put("texinfo", "application/x-texinfo");
        DEFAULT_MAP.put("texi", "application/x-texinfo");
        DEFAULT_MAP.put("t", "application/x-troff");
        DEFAULT_MAP.put("tr", "application/x-troff");
        DEFAULT_MAP.put("roff", "application/x-troff");
        DEFAULT_MAP.put("man", "application/x-troff-man");
        DEFAULT_MAP.put("me", "application/x-troff-me");
        DEFAULT_MAP.put("ms", "application/x-wais-source");
        DEFAULT_MAP.put("src", "application/x-wais-source");
        DEFAULT_MAP.put("zip", "application/zip");
        DEFAULT_MAP.put("bcpio", "application/x-bcpio");
        DEFAULT_MAP.put("cpio", "application/x-cpio");
        DEFAULT_MAP.put("gtar", "application/x-gtar");
        DEFAULT_MAP.put("shar", "application/x-shar");
        DEFAULT_MAP.put("sv4cpio", "application/x-sv4cpio");
        DEFAULT_MAP.put("sv4crc", "application/x-sv4crc");
        DEFAULT_MAP.put("tar", "application/x-tar");
        DEFAULT_MAP.put("ustar", "application/x-ustar");
        DEFAULT_MAP.put("dvi", "application/x-dvi");
        DEFAULT_MAP.put("hdf", "application/x-hdf");
        DEFAULT_MAP.put("latex", "application/x-latex");
        DEFAULT_MAP.put("bin", "application/octet-stream");
        DEFAULT_MAP.put("oda", "application/oda");
        DEFAULT_MAP.put("pdf", "application/pdf");
        DEFAULT_MAP.put("ps", "application/postscript");
        DEFAULT_MAP.put("eps", "application/postscript");
        DEFAULT_MAP.put("ai", "application/postscript");
        DEFAULT_MAP.put("rtf", "application/rtf");
        DEFAULT_MAP.put("nc", "application/x-netcdf");
        DEFAULT_MAP.put("cdf", "application/x-netcdf");
        DEFAULT_MAP.put("cer", "application/x-x509-ca-cert");
        DEFAULT_MAP.put("exe", "application/octet-stream");
        DEFAULT_MAP.put("gz", "application/x-gzip");
        DEFAULT_MAP.put("Z", "application/x-compress");
        DEFAULT_MAP.put("z", "application/x-compress");
        DEFAULT_MAP.put("hqx", "application/mac-binhex40");
        DEFAULT_MAP.put("mif", "application/x-mif");
        DEFAULT_MAP.put("ief", "image/ief");
        DEFAULT_MAP.put("tiff", "image/tiff");
        DEFAULT_MAP.put("tif", "image/tiff");
        DEFAULT_MAP.put("ras", "image/x-cmu-raster");
        DEFAULT_MAP.put("pnm", "image/x-portable-anymap");
        DEFAULT_MAP.put("pbm", "image/x-portable-bitmap");
        DEFAULT_MAP.put("pgm", "image/x-portable-graymap");
        DEFAULT_MAP.put("ppm", "image/x-portable-pixmap");
        DEFAULT_MAP.put("rgb", "image/x-rgb");
        DEFAULT_MAP.put("xbm", "image/x-xbitmap");
        DEFAULT_MAP.put("xpm", "image/x-xpixmap");
        DEFAULT_MAP.put("xwd", "image/x-xwindowdump");
        DEFAULT_MAP.put("au", "audio/basic");
        DEFAULT_MAP.put("snd", "audio/basic");
        DEFAULT_MAP.put("aif", "audio/x-aiff");
        DEFAULT_MAP.put("aiff", "audio/x-aiff");
        DEFAULT_MAP.put("aifc", "audio/x-aiff");
        DEFAULT_MAP.put("wav", "audio/x-wav");
        DEFAULT_MAP.put("mpeg", "video/mpeg");
        DEFAULT_MAP.put("mpg", "video/mpeg");
        DEFAULT_MAP.put("mpe", "video/mpeg");
        DEFAULT_MAP.put("qt", "video/quicktime");
        DEFAULT_MAP.put("mov", "video/quicktime");
        DEFAULT_MAP.put("avi", "video/x-msvideo");
        DEFAULT_MAP.put("movie", "video/x-sgi-movie");
        DEFAULT_MAP.put("avx", "video/x-rad-screenplay");
        DEFAULT_MAP.put("wrl", "x-world/x-vrml");
        DEFAULT_MAP.put("mpv2", "video/mpeg2");
        DEFAULT_MAP.put("xml", "text/xml");
        DEFAULT_MAP.put("xsl", "text/xml");
        DEFAULT_MAP.put("svg", "image/svg+xml");
        DEFAULT_MAP.put("svgz", "image/svg+xml");
        DEFAULT_MAP.put("wbmp", "image/vnd.wap.wbmp");
        DEFAULT_MAP.put("wml", "text/vnd.wap.wml");
        DEFAULT_MAP.put("wmlc", "application/vnd.wap.wmlc");
        DEFAULT_MAP.put("wmls", "text/vnd.wap.wmlscript");
        DEFAULT_MAP.put("wmlscriptc", "application/vnd.wap.wmlscriptc");
    }
}

