/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.MimeHeadersPacket;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;

public abstract class HttpHeader
extends HttpPacket
implements MimeHeadersPacket,
AttributeStorage {
    protected boolean isCommitted;
    protected final MimeHeaders headers = new MimeHeaders();
    protected final DataChunk protocolC = DataChunk.newInstance();
    protected Protocol parsedProtocol;
    protected boolean isChunked;
    protected long contentLength = -1L;
    protected String characterEncoding;
    protected String quotedCharsetValue;
    protected boolean charsetSet = false;
    private boolean charEncodingParsed = false;
    private byte[] defaultContentType;
    protected boolean contentTypeParsed;
    protected String contentType;
    protected boolean isExpectContent = true;
    protected boolean isSkipRemainder;
    protected boolean secure;
    protected final DataChunk upgrade = DataChunk.newInstance();
    private TransferEncoding transferEncoding;
    private final List<ContentEncoding> contentEncodings = new ArrayList<ContentEncoding>();
    private final AttributeHolder attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);

    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public abstract boolean isRequest();

    @Override
    public final boolean isHeader() {
        return true;
    }

    public abstract ProcessingState getProcessingState();

    protected void addContentEncoding(ContentEncoding contentEncoding) {
        this.contentEncodings.add(contentEncoding);
    }

    protected List<ContentEncoding> getContentEncodings(boolean isModifiable) {
        if (isModifiable) {
            return this.contentEncodings;
        }
        return Collections.unmodifiableList(this.contentEncodings);
    }

    public List<ContentEncoding> getContentEncodings() {
        return this.getContentEncodings(false);
    }

    public TransferEncoding getTransferEncoding() {
        return this.transferEncoding;
    }

    protected void setTransferEncoding(TransferEncoding transferEncoding) {
        this.transferEncoding = transferEncoding;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean isChunked) {
        this.isChunked = isChunked;
    }

    public boolean isExpectContent() {
        return this.isExpectContent;
    }

    protected void setExpectContent(boolean isExpectContent) {
        this.isExpectContent = isExpectContent;
    }

    public boolean isSkipRemainder() {
        return this.isSkipRemainder;
    }

    public void setSkipRemainder(boolean isSkipRemainder) {
        this.isSkipRemainder = isSkipRemainder;
    }

    public String getUpgrade() {
        if (!this.upgrade.isNull()) {
            return this.upgrade.toString();
        }
        String upgradeStr = this.headers.getHeader("upgrade");
        if (upgradeStr != null) {
            this.upgrade.setString(upgradeStr);
        }
        return upgradeStr;
    }

    public DataChunk getUpgradeDC() {
        return this.upgrade;
    }

    public void setUpgrade(String upgrade) {
        this.upgrade.setString(upgrade);
    }

    protected void makeUpgradeHeader() {
        if (!this.upgrade.isNull()) {
            this.headers.setValue("upgrade").set(this.upgrade);
        }
    }

    protected void makeContentLengthHeader(Connection c, long defaultLength) {
        if (this.contentLength != -1L) {
            Buffer b = HttpCodecUtils.getLongAsBuffer(c.getTransport().getMemoryManager(), this.contentLength);
            this.headers.setValue("content-length").setBuffer(b, b.position(), b.limit());
        } else if (defaultLength != -1L) {
            Buffer b = HttpCodecUtils.getLongAsBuffer(c.getTransport().getMemoryManager(), defaultLength);
            int idx = this.headers.indexOf("content-length", 0);
            if (idx == -1) {
                this.headers.addValue("content-length").setBuffer(b, b.position(), b.limit());
            } else if (this.headers.getValue(idx).isNull()) {
                this.headers.getValue(idx).setBuffer(b, b.position(), b.limit());
            }
        }
    }

    public long getContentLength() {
        DataChunk contentLengthChunk;
        if (this.contentLength == -1L && (contentLengthChunk = this.headers.getValue("content-length")) != null) {
            this.contentLength = Ascii.parseLong(contentLengthChunk);
        }
        return this.contentLength;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public void setContentLengthLong(long contentLength) {
        this.contentLength = contentLength;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    protected void makeTransferEncodingHeader(String defaultValue) {
        int idx = this.headers.indexOf("transfer-encoding", 0);
        if (idx == -1) {
            this.headers.addValue("transfer-encoding").setString("chunked");
        }
    }

    protected void extractContentEncoding(DataChunk value) {
        int idx = this.headers.indexOf("content-encoding", 0);
        if (idx != -1) {
            this.headers.getAndSetSerialized(idx, true);
            value.set(this.headers.getValue(idx));
        }
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null || this.charEncodingParsed) {
            return this.characterEncoding;
        }
        if (this.isContentTypeSet()) {
            this.characterEncoding = ContentType.getCharsetFromContentType(this.getContentType());
            this.charEncodingParsed = true;
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    protected void extractContentType(DataChunk dc) {
        if (!this.contentTypeParsed) {
            DataChunk value;
            int idx;
            this.contentTypeParsed = true;
            if (this.contentType == null && (idx = this.headers.indexOf("content-type", 0)) != -1 && !(value = this.headers.getValue(idx)).isNull()) {
                this.contentType = value.toString();
                this.headers.getAndSetSerialized(idx, true);
            }
        }
        dc.setString(this.getContentType());
    }

    public boolean isContentTypeSet() {
        return this.contentType != null || this.characterEncoding != null || this.headers.getValue("content-type") != null;
    }

    public String getContentType() {
        String ret;
        if (!this.contentTypeParsed) {
            DataChunk dc;
            this.contentTypeParsed = true;
            if (this.contentType == null && (dc = this.headers.getValue("content-type")) != null && !dc.isNull()) {
                this.setContentType(dc.toString());
            }
        }
        if ((ret = this.contentType) != null && this.quotedCharsetValue != null && this.charsetSet) {
            ret = ret + ";charset=" + this.quotedCharsetValue;
        }
        return ret;
    }

    public void setContentType(String type) {
        String charsetValue;
        int semicolonIndex = -1;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && type.charAt(index) == ' ') {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.setValue(name).setString(value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.addValue(name).setString(value);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public DataChunk getProtocolDC() {
        this.parsedProtocol = null;
        return this.protocolC;
    }

    public String getProtocolString() {
        if (this.parsedProtocol == null) {
            return this.getProtocolDC().toString();
        }
        return this.parsedProtocol.getProtocolString();
    }

    public Protocol getProtocol() {
        if (this.parsedProtocol != null) {
            return this.parsedProtocol;
        }
        this.parsedProtocol = Protocol.parseDataChunk(this.protocolC);
        return this.parsedProtocol;
    }

    public void setProtocol(Protocol protocol) {
        this.parsedProtocol = protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    public final HttpContent.Builder httpContentBuilder() {
        return HttpContent.builder(this);
    }

    public HttpTrailer.Builder httpTrailerBuilder() {
        return HttpTrailer.builder(this);
    }

    protected void reset() {
        this.secure = false;
        this.attributes.recycle();
        this.protocolC.recycle();
        this.parsedProtocol = null;
        this.contentEncodings.clear();
        this.headers.clear();
        this.isCommitted = false;
        this.isChunked = false;
        this.contentLength = -1L;
        this.characterEncoding = null;
        this.defaultContentType = null;
        this.quotedCharsetValue = null;
        this.charsetSet = false;
        this.charEncodingParsed = false;
        this.contentType = null;
        this.contentTypeParsed = false;
        this.transferEncoding = null;
        this.isExpectContent = true;
        this.upgrade.recycle();
    }

    public void recycle() {
        this.reset();
    }

    protected byte[] getDefaultContentType() {
        return this.defaultContentType;
    }

    protected void setDefaultContentType(byte[] defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public static abstract class Builder<T extends Builder> {
        protected HttpHeader packet;

        public final T protocol(Protocol protocol) {
            this.packet.setProtocol(protocol);
            return (T)this;
        }

        public final T protocol(String protocol) {
            this.packet.getProtocolDC().setString(protocol);
            return (T)this;
        }

        public final T chunked(boolean isChunked) {
            this.packet.setChunked(isChunked);
            return (T)this;
        }

        public final T contentLength(long contentLength) {
            this.packet.setContentLengthLong(contentLength);
            return (T)this;
        }

        public final T contentType(String contentType) {
            this.packet.setContentType(contentType);
            return (T)this;
        }

        public final T upgrade(String upgrade) {
            this.packet.setUpgrade(upgrade);
            return (T)this;
        }

        public final T header(String name, String value) {
            this.packet.addHeader(name, value);
            return (T)this;
        }
    }
}

