/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.memory.Buffers;

public class HttpUtils {
    public static void longToBuffer(long value, Buffer buffer) {
        boolean negative;
        if (value == 0L) {
            buffer.put(0, (byte)48);
            buffer.limit(1);
            return;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        int position = buffer.limit();
        do {
            int ch = 48 + (int)(value % 10L);
            buffer.put(--position, (byte)ch);
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer.put(--position, (byte)45);
        }
        buffer.position(position);
    }

    private static DataChunk newChunk(byte[] bytes) {
        DataChunk dc = DataChunk.newInstance();
        Buffer b = Buffers.wrap(null, (byte[])bytes);
        dc.setBuffer(b, 0, bytes.length);
        return dc;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (char aContent : content) {
            switch (aContent) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(aContent);
                }
            }
        }
        return result.toString();
    }
}

