/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationClassValue;
import com.sun.codemodel.JAnnotationStringValue;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JAnnotationWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JType;
import com.sun.codemodel.TypedAnnotationWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class JAnnotationArrayMember
extends JAnnotationValue
implements JAnnotatable {
    private final List<JAnnotationValue> values = new ArrayList<JAnnotationValue>();
    private final JCodeModel owner;

    JAnnotationArrayMember(JCodeModel owner) {
        this.owner = owner;
    }

    public JAnnotationArrayMember param(String value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(boolean value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(byte value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(char value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(double value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(long value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(short value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(int value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(float value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(JExpr.lit(value));
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(Enum<?> value) {
        JClass ref = this.owner.ref(value.getClass());
        return this.param(new JEnumConstant(ref, value.name()));
    }

    public JAnnotationArrayMember param(JEnumConstant value) {
        JAnnotationClassValue annotationValue = new JAnnotationClassValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(JExpression value) {
        JAnnotationStringValue annotationValue = new JAnnotationStringValue(value);
        this.values.add(annotationValue);
        return this;
    }

    public JAnnotationArrayMember param(Class<?> value) {
        JClass ref = this.owner.ref(value);
        this.values.add(new JAnnotationClassValue(ref));
        return this;
    }

    public JAnnotationArrayMember param(JType type) {
        JClass clazz = type.boxify();
        JAnnotationClassValue annotationValue = new JAnnotationClassValue(clazz);
        this.values.add(annotationValue);
        return this;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner.ref(clazz));
    }

    @Override
    public JAnnotationUse annotate(JClass clazz) {
        JAnnotationUse a = new JAnnotationUse(clazz);
        this.values.add(a);
        return a;
    }

    @Override
    public boolean removeAnnotation(JAnnotationUse annotation) {
        return this.values.remove(annotation);
    }

    @Override
    public <W extends JAnnotationWriter<? extends Annotation>> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public Collection<JAnnotationUse> annotations() {
        return Collections.unmodifiableList(this.values);
    }

    public Collection<JAnnotationValue> annotations2() {
        return Collections.unmodifiableList(this.values);
    }

    @Deprecated(since="2.3", forRemoval=true)
    public JAnnotationArrayMember param(JAnnotationUse value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void generate(JFormatter f) {
        f.p('{').nl().i();
        boolean first = true;
        for (JAnnotationValue aValue : this.values) {
            if (!first) {
                f.p(',').nl();
            }
            f.g(aValue);
            first = false;
        }
        f.nl().o().p('}');
    }
}

