/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.linking.Binding;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkDescriptor;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.ProvideLink;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.glassfish.jersey.server.model.ResourceMethod;

public class ProvideLinkDescriptor
implements InjectLinkDescriptor {
    private final ProvideLink provideLink;
    private final ResourceMethod resource;
    private final Annotation parentAnnotation;
    private final Map<String, String> bindings;

    public ProvideLinkDescriptor(ResourceMethod resource, ProvideLink provideLink, Annotation parentAnnotation) {
        this.provideLink = provideLink;
        this.resource = resource;
        this.parentAnnotation = parentAnnotation;
        this.bindings = new HashMap<String, String>();
        for (Binding binding : provideLink.bindings()) {
            this.bindings.put(binding.name(), binding.value());
        }
    }

    public ProvideLink getProvideLink() {
        return this.provideLink;
    }

    public ResourceMethod getResource() {
        return this.resource;
    }

    @Override
    public InjectLink.Style getLinkStyle() {
        return this.provideLink.style();
    }

    @Override
    public String getLinkTemplate(ResourceMappingContext rmc) {
        StringBuilder querySubString;
        Path path;
        String template = null;
        ResourceMappingContext.Mapping map = rmc.getMapping(this.resource.getInvocable().getHandler().getHandlerClass());
        template = map != null ? map.getTemplate().getTemplate() : ((path = this.resource.getInvocable().getHandler().getHandlerClass().getAnnotation(Path.class)) == null ? "" : path.value());
        StringBuilder builder = new StringBuilder(template);
        Path methodPath = this.resource.getInvocable().getDefinitionMethod().getAnnotation(Path.class);
        if (methodPath != null) {
            String methodTemplate = methodPath.value();
            if (!template.endsWith("/") && !methodTemplate.startsWith("/")) {
                builder.append("/");
            }
            builder.append(methodTemplate);
        }
        if ((querySubString = InjectLinkFieldDescriptor.extractQueryParams(new AnnotatedMethod(this.resource.getInvocable().getDefinitionMethod()))).length() > 0) {
            builder.append("{?");
            builder.append((CharSequence)querySubString);
            builder.append("}");
        }
        template = builder.toString();
        return template;
    }

    @Override
    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    @Override
    public String getCondition() {
        return this.provideLink.condition();
    }

    public Link getLink(URI uri) {
        return ProvideLink.Util.buildLinkFromUri(uri, this.provideLink);
    }

    public Annotation getParentAnnotation() {
        return this.parentAnnotation;
    }
}

