/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.xml.ws.security.impl.policy;
import static com.sun.xml.ws.security.impl.policy.Constants.*;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import java.util.Collection;
import javax.xml.namespace.QName;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class TransportToken extends Token implements com.sun.xml.ws.security.policy.TransportToken, SecurityAssertionValidator  {
    private String id;
    private HttpsToken token = null;
    private boolean populated;
    private AssertionFitness fitness = AssertionFitness.IS_VALID;
    private QName itQname;
    private String includeToken;
    /**
     * Creates a new instance of TransportToken
     */
    public TransportToken() {
         id= PolicyUtil.randomUUID();
         itQname = new QName(getSecurityPolicyVersion().namespaceUri, Constants.IncludeToken);
         includeToken = "";
    }
    
    public TransportToken(AssertionData name,Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name,nestedAssertions,nestedAlternative);
        id= PolicyUtil.randomUUID();
        itQname = new QName(getSecurityPolicyVersion().namespaceUri, Constants.IncludeToken);
    }
    
    @Override
    public String getTokenId() {
        return id;
    }
    @Override
    public String getIncludeToken() {
        throw new UnsupportedOperationException("This method is not supported for TransportToken");
    }
    @Override
    public void setIncludeToken(String type) {
        throw new UnsupportedOperationException("This method is not supported for TransportToken");
    }
    
    public com.sun.xml.ws.security.policy.HttpsToken getHttpsToken() {
        populate();
        return token;
    }
    public void setHttpsToken(com.sun.xml.ws.security.policy.HttpsToken token){
        //TODO::
    }
    
    @Override
    public AssertionFitness validate(boolean isServer) {
        return populate(isServer);
    }
    private void populate(){
        populate(false);
    }
    
    private synchronized AssertionFitness populate(boolean isServer) {
        if(!populated){
            this.includeToken = this.getAttributeValue(itQname);
            NestedPolicy policy = this.getNestedPolicy();
            AssertionSet assertionSet = policy.getAssertionSet();
            for(PolicyAssertion assertion: assertionSet){
                if(PolicyUtil.isHttpsToken(assertion, getSecurityPolicyVersion())){
                    token = (HttpsToken) assertion;
                }else{
                    if(!assertion.isOptional()){
                        log_invalid_assertion(assertion, isServer,"TransportToken");
                        fitness = AssertionFitness.HAS_UNKNOWN_ASSERTION;
                    }
                }
            }
            this.populated  = true;
        }
        return fitness;
    }
}
