/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.UDDIMapperCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ProtoCallbackHandler
implements CallbackHandler {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    UDDIMapper mapper;

    public ProtoCallbackHandler(UDDIMapper uDDIMapper) {
        this.mapper = uDDIMapper;
    }

    public UDDIMapper getUDDIMapper() {
        return this.mapper;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbackArray.length; ++i) {
            Callback callback;
            if (callbackArray[i] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[i];
                switch (((TextOutputCallback)callback).getMessageType()) {
                    case 0: {
                        this.logger.finest(((TextOutputCallback)callback).getMessage());
                        break;
                    }
                    case 2: {
                        this.logger.log(Level.SEVERE, ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:ERROR:_") + ((TextOutputCallback)callback).getMessage());
                        break;
                    }
                    case 1: {
                        this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:WARNING:_") + ((TextOutputCallback)callback).getMessage());
                        break;
                    }
                    default: {
                        throw new IOException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:Unsupported_message_type:_") + ((TextOutputCallback)callback).getMessageType());
                    }
                }
                continue;
            }
            if (callbackArray[i] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[i];
                System.err.print(((NameCallback)callback).getPrompt());
                System.err.flush();
                ((NameCallback)callback).setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callbackArray[i] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[i];
                System.err.print(((PasswordCallback)callback).getPrompt());
                System.err.flush();
                ((PasswordCallback)callback).setPassword(this.readPassword(System.in));
                continue;
            }
            if (callbackArray[i] instanceof UDDIMapperCallback) {
                callback = (UDDIMapperCallback)callbackArray[i];
                ((UDDIMapperCallback)callback).setUDDIMapper(this.mapper);
                continue;
            }
            throw new UnsupportedCallbackException(callbackArray[i], ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:Unrecognized_Callback"));
        }
    }

    private char[] readPassword(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n = cArray2.length;
        int n2 = 0;
        block4: while (true) {
            int n3 = inputStream.read();
            switch (n3) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                }
                default: {
                    if (--n < 0) {
                        cArray2 = new char[n2 + 128];
                        n = cArray2.length - n2 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n2++] = (char)n3;
                    continue block4;
                }
            }
            break;
        }
        if (n2 == 0) {
            return null;
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray2, 0, cArray3, 0, n2);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }
}

