/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.jcp.xml.dsig.internal.dom.DOMKeyName;
import org.jcp.xml.dsig.internal.dom.DOMKeyValue;
import org.jcp.xml.dsig.internal.dom.DOMPGPData;
import org.jcp.xml.dsig.internal.dom.DOMRetrievalMethod;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.jcp.xml.dsig.internal.dom.DOMX509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMKeyInfo
extends DOMStructure
implements KeyInfo {
    private final String id;
    private final List keyInfoTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DOMKeyInfo(List list, String string2) {
        if (list == null) {
            throw new NullPointerException("content cannot be null");
        }
        ArrayList arrayList = new ArrayList(list);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid KeyInfo type");
        }
        this.keyInfoTypes = Collections.unmodifiableList(arrayList);
        this.id = string2;
    }

    public DOMKeyInfo(Element element, XMLCryptoContext xMLCryptoContext, Provider provider) throws MarshalException {
        this.id = DOMUtils.getAttributeValue(element, "Id");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n < 1) {
            throw new MarshalException("KeyInfo must contain at least one type");
        }
        ArrayList<XMLStructure> arrayList = new ArrayList<XMLStructure>(n);
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string2 = element2.getLocalName();
            if (string2.equals("X509Data")) {
                arrayList.add(new DOMX509Data(element2));
                continue;
            }
            if (string2.equals("KeyName")) {
                arrayList.add(new DOMKeyName(element2));
                continue;
            }
            if (string2.equals("KeyValue")) {
                arrayList.add(new DOMKeyValue(element2));
                continue;
            }
            if (string2.equals("RetrievalMethod")) {
                arrayList.add(new DOMRetrievalMethod(element2, xMLCryptoContext, provider));
                continue;
            }
            if (string2.equals("PGPData")) {
                arrayList.add(new DOMPGPData(element2));
                continue;
            }
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(element2));
        }
        this.keyInfoTypes = Collections.unmodifiableList(arrayList);
    }

    public String getId() {
        return this.id;
    }

    public List getContent() {
        return this.keyInfoTypes;
    }

    public void marshal(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        if (xMLStructure == null) {
            throw new NullPointerException("parent is null");
        }
        Node node = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
        String string2 = DOMUtils.getSignaturePrefix(xMLCryptoContext);
        Element element = DOMUtils.createElement(DOMUtils.getOwnerDocument(node), "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", string2);
        if (string2 == null || string2.length() == 0) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        }
        this.marshal(node, element, null, string2, (DOMCryptoContext)xMLCryptoContext);
    }

    public void marshal(Node node, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.marshal(node, null, string2, dOMCryptoContext);
    }

    public void marshal(Node node, Node node2, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#", string2);
        this.marshal(node, element, node2, string2, dOMCryptoContext);
    }

    private void marshal(Node node, Element element, Node node2, String string2, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        int n = this.keyInfoTypes.size();
        for (int i = 0; i < n; ++i) {
            XMLStructure xMLStructure = (XMLStructure)this.keyInfoTypes.get(i);
            if (xMLStructure instanceof DOMStructure) {
                ((DOMStructure)xMLStructure).marshal(element, string2, dOMCryptoContext);
                continue;
            }
            DOMUtils.appendChild(element, ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode());
        }
        DOMUtils.setAttributeID(element, "Id", this.id);
        node.insertBefore(element, node2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KeyInfo)) {
            return false;
        }
        KeyInfo keyInfo = (KeyInfo)object;
        boolean bl = this.id == null ? keyInfo.getId() == null : this.id.equals(keyInfo.getId());
        return ((Object)this.keyInfoTypes).equals(keyInfo.getContent()) && bl;
    }

    public int hashCode() {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"hashCode not designed");
        }
        return 43;
    }

    static {
        $assertionsDisabled = !DOMKeyInfo.class.desiredAssertionStatus();
    }
}

