/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jms.IllegalStateException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;

public class ConnectionRecover
implements Runnable {
    protected ConnectionImpl connection = null;
    protected static final String iMQConnectionRecover = "iMQConnectionRecover-";
    private boolean debug = Debug.debug;
    protected static final int RECOVER_INACTIVE = 0;
    protected static final int RECOVER_STOPPED = 1;
    protected static final int RECOVER_STARTED = 2;
    protected static final int RECOVER_IN_PROCESS = 3;
    protected static final int TRANSPORT_CONNECTED = 4;
    protected static final int RECOVER_SUCCEEDED = 5;
    protected static final int RECOVER_FAILED = 6;
    protected static final int RECOVER_ABORTED = 7;
    private static final String[] STATES = new String[]{"RECOVER_INACTIVE", "RECOVER_STOPPED", "RECOVER_STARTED", "RECOVER_IN_PROCESS", "RECOVER_TRANSPORT_CONNECTED", "RECOVER_SUCCEEDED", "RECOVER_FAILED", "RECOVER_ABORTED"};
    private int recoverState = 0;
    private int maxRetries = 100;
    private int failedCount = 0;
    protected Thread recoverThread = null;
    private static final int WAIT_TIME = 3000;
    private static final int MAX_WAIT_COUNT = 200;
    public int recoverDelay = 3000;
    private Logger connLogger = ConnectionImpl.connectionLogger;
    private boolean enableCCReconnect = true;

    public ConnectionRecover(ConnectionImpl connection) {
        boolean flag;
        this.connection = connection;
        String prop = connection.getTrimmedProperty("imq.recover.maxRetries");
        if (prop != null) {
            this.maxRetries = Integer.parseInt(prop);
        }
        if ((prop = connection.getTrimmedProperty("imq.recover.delay")) != null) {
            this.recoverDelay = Integer.parseInt(prop);
            if (connection.isConnectedToHABroker && this.recoverDelay < 3000) {
                this.recoverDelay = 3000;
            }
        }
        if ((prop = connection.getTrimmedProperty("imq.recover.connectionConsumer")) != null && !(flag = Boolean.getBoolean(prop))) {
            this.enableCCReconnect = false;
        }
        this.logRecoverState(0);
    }

    protected void init() throws JMSException {
        Debug.println("*** in ConnectionRecover.init() ...");
        if (this.connection.isConnectedToHABroker) {
            if (this.recoverDelay < 3000) {
                this.recoverDelay = 3000;
            }
            this.sleep(this.recoverDelay);
        }
        this.closeProtocolHandler();
        this.connection.protocolHandler.init(true);
        this.logRecoverState(4);
    }

    public void start() {
        this.recoverThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.recoverThread.setDaemon(true);
        }
        this.recoverThread.setName("iMQConnectionRecover--" + this.connection.getLocalID() + "-" + this.connection.getConnectionID());
        this.setRecoverState(2);
        this.recoverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.connection.protocolHandler.recoverThread = Thread.currentThread();
        try {
            this.setRecoverState(3);
            this.recover();
            this.setRecoverState(5);
            this.failedCount = 0;
        }
        catch (JMSException jmse) {
            this.setRecoverState(6);
            this.connLogger.log(Level.WARNING, jmse.toString(), jmse);
            this.connection.triggerConnectionReconnectFailedEvent(jmse);
            this.checkForMaxRetries();
            this.closeProtocolHandler();
        }
        finally {
            if (this.recoverState == 5) {
                this.connection.triggerConnectionReconnectedEvent();
            }
            this.connection.protocolHandler.recoverThread = null;
            this.setRecoverState(0);
        }
    }

    protected void recover() throws JMSException {
        try {
            if (this.debug) {
                Debug.println("BEGIN ConnectionRecover.recover()...");
            }
            if (this.connection.isCloseCalled) {
                this.connection.setReconnecting(false);
                return;
            }
            this.checkConnectionConsumers();
            this.resetConnectionConsumers();
            this.resetSessions();
            this.connection.hello(true);
            this.connection.protocolHandler.resetClientID();
            this.addSessions();
            this.addConsumers();
            this.releaseConnectionConsumers();
            this.addProducers();
            if (!this.connection.isStopped && this.connection.eventListener == null) {
                this.connection.protocolHandler.start();
            }
            if (this.connection.getEventHandler() != null) {
                this.connection.getEventHandler().resendConsumerInfoRequests(this.connection.protocolHandler);
            }
            if (this.debug) {
                Debug.info("ConnectionRecover.recover() SUCCESS!!!");
            }
        }
        catch (JMSException e) {
            if (this.debug) {
                Debug.println("ConnectionRecover failed.");
                Debug.printStackTrace(e);
            }
            throw e;
        }
        finally {
            this.releaseConnectionConsumers();
            if (this.debug) {
                Debug.println("END ConnectionRecover.recover()!!!");
            }
        }
    }

    private void resetConnectionConsumers() {
        try {
            int size = this.connection.connectionConsumerTable.size();
            for (int i = 0; i < size; ++i) {
                ConnectionConsumerImpl ccImpl = (ConnectionConsumerImpl)this.connection.connectionConsumerTable.get(i);
                ccImpl.setFailoverInprogress(true);
                ccImpl.getReadQueue().clear();
            }
        }
        catch (Exception e) {
            this.connLogger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void releaseConnectionConsumers() {
        try {
            int size = this.connection.connectionConsumerTable.size();
            for (int i = 0; i < size; ++i) {
                try {
                    ConnectionConsumerImpl ccImpl = (ConnectionConsumerImpl)this.connection.connectionConsumerTable.get(i);
                    ccImpl.setFailoverInprogress(false);
                    continue;
                }
                catch (Exception e) {
                    this.connLogger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            this.connLogger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected void checkConnectionConsumers() throws JMSException {
        if (this.enableCCReconnect) {
            return;
        }
        if (this.connection.connectionConsumerTable.size() > 0) {
            String errorString = AdministeredObject.cr.getKString("C4061");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4061");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    protected void resetSessions() throws JMSException {
        Enumeration enum2 = this.connection.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            if (!this.enableCCReconnect && session.getMessageListener() != null) {
                String errorString = AdministeredObject.cr.getKString("C4061");
                IllegalStateException jmse = new IllegalStateException(errorString, "C4061");
                ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
            }
            session.reset();
        }
    }

    protected void addSessions() throws JMSException {
        Enumeration enum2 = this.connection.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            session.recreateSession();
        }
    }

    protected void addConsumers() throws JMSException {
        Object[] tmp = this.connection.interestTable.toArray();
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < tmp.length; ++i) {
            if (!((Consumer)tmp[i]).isClosed) {
                this.connection.protocolHandler.addInterest((Consumer)tmp[i]);
                continue;
            }
            v.add(tmp[i]);
        }
        while (!v.isEmpty()) {
            Object o = v.firstElement();
            this.connection.interestTable.remove((Consumer)o);
            v.remove(o);
        }
    }

    protected void addProducers() throws JMSException {
        Enumeration enum2 = this.connection.sessionTable.elements();
        while (enum2.hasMoreElements()) {
            SessionImpl session = (SessionImpl)enum2.nextElement();
            this.addSessionProducers(session);
        }
    }

    protected void addSessionProducers(SessionImpl session) throws JMSException {
        Enumeration enum2 = session.producers.elements();
        while (enum2.hasMoreElements()) {
            MessageProducerImpl producer = (MessageProducerImpl)enum2.nextElement();
            producer.recreateProducer();
        }
    }

    protected synchronized void setRecoverState(int state) {
        if (this.recoverState != 7) {
            this.recoverState = state;
            this.logRecoverState(state);
        } else {
            this.logRecoverState(7);
        }
        this.notifyAll();
    }

    protected synchronized int getRecoverState() {
        return this.recoverState;
    }

    private void closeProtocolHandler() {
        block2: {
            try {
                this.connection.protocolHandler.close();
            }
            catch (Exception e) {
                if (!this.debug) break block2;
                Debug.printStackTrace(e);
            }
        }
    }

    private void checkForMaxRetries() {
        ++this.failedCount;
        if (this.maxRetries == -1) {
            return;
        }
        if (this.failedCount > this.maxRetries) {
            this.setRecoverState(7);
            if (this.debug) {
                Debug.println("*** reached max internal retry count: " + this.maxRetries);
            }
            String msg = AdministeredObject.cr.getKString("I113", this.connection.getBrokerAddressList(), this.maxRetries);
            this.connLogger.log(Level.SEVERE, msg);
        }
    }

    public synchronized void waitUntilInactive() throws JMSException {
        JMSException jmse;
        int wcounter = 0;
        int lctr = 0;
        if (this.recoverState == 7) {
            jmse = new JMSException("ConnectionRecover aborted!");
            ExceptionHandler.throwJMSException(jmse);
        }
        while (this.recoverState != 0 && this.recoverState != 7) {
            try {
                this.wait(3000L);
                if (++lctr == 5) {
                    String msg = AdministeredObject.cr.getKString("I107", STATES[this.getRecoverState()], this.connection.getLastContactedBrokerAddress());
                    this.connLogger.log(Level.INFO, msg);
                    lctr = 0;
                }
            }
            catch (Exception e) {
                this.connLogger.log(Level.WARNING, e.toString(), e);
            }
            if (this.connection.isCloseCalled) {
                this.setRecoverState(7);
                return;
            }
            this.connection.readChannel.closeIOAndNotify();
            if (++wcounter <= 200) continue;
            this.setRecoverState(7);
            jmse = new JMSException("Timeout on ConnectionRecover object.  Broker: " + this.connection.getLastContactedBrokerAddress());
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void sleep(int sleepTime) {
        try {
            int count = sleepTime / 3000;
            for (int i = 0; i < count; ++i) {
                if (this.debug) {
                    Debug.println("*** ConnectionRecover, sleeping " + 3000 * (i + 1) + " milli secs");
                }
                Thread.sleep(3000L);
                if (!this.connection.isCloseCalled) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logRecoverState(int state) {
        if (this.connLogger.isLoggable(Level.INFO)) {
            String addr = this.connection.getLastContactedBrokerAddress();
            String msg = AdministeredObject.cr.getKString("I107", STATES[state], addr);
            this.connLogger.log(Level.INFO, msg);
        }
    }
}

