/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.ContextableConnection;
import com.sun.messaging.jmq.jmsclient.ContextableSession;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.JMSConsumerImpl;
import com.sun.messaging.jmq.jmsclient.JMSProducerImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jms.MQIllegalStateRuntimeException;
import com.sun.messaging.jms.MQInvalidDestinationRuntimeException;
import com.sun.messaging.jms.MQInvalidSelectorRuntimeException;
import com.sun.messaging.jms.MQRuntimeException;
import com.sun.messaging.jms.MQSecurityRuntimeException;
import com.sun.messaging.jms.MQTransactionInProgressRuntimeException;
import com.sun.messaging.jms.MQTransactionRolledBackRuntimeException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionRolledBackException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

public class JMSContextImpl
implements JMSContext,
Traceable {
    private static final String ROOT_LOGGER_NAME = "javax.jms";
    protected static final String JMSCONTEXT_LOGGER_NAME = "javax.jms.jmscontext";
    protected static final Logger contextLogger = Logger.getLogger("javax.jms.jmscontext", "com.sun.messaging.jmq.jmsclient.resources.ClientResources");
    Connection connection;
    Session session;
    MessageProducer messageProducer;
    boolean autoStart = true;
    boolean closed = false;
    Set<JMSContext> contextSet;
    Set<JMSConsumer> consumers = new HashSet<JMSConsumer>();
    ContainerType containerType;
    private boolean allowToSetClientID = true;

    protected ContainerType getContainerType() {
        return this.containerType;
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType, String userName, String password) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(cf@" + connectionFactory.hashCode() + ", " + (Object)((Object)containerType) + ", " + userName + ",)");
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection(userName, password);
        }
        catch (SecurityException e) {
            MQSecurityRuntimeException jsre = new MQSecurityRuntimeException(e.getMessage(), null, e);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jsre);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.session = this.connection.createSession();
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(cf@" + connectionFactory.hashCode() + ", " + (Object)((Object)containerType) + ")");
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection();
        }
        catch (SecurityException e) {
            MQSecurityRuntimeException jsre = new MQSecurityRuntimeException(e.getMessage(), null, e);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jsre);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.session = this.connection.createSession();
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType, String userName, String password, int sessionMode) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(cf@" + connectionFactory.hashCode() + ", " + (Object)((Object)containerType) + ", " + userName + ",, " + sessionMode + ")");
        this.validateSessionMode(sessionMode);
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection(userName, password);
        }
        catch (SecurityException e) {
            JMSSecurityRuntimeException jmssre = new JMSSecurityRuntimeException(e.getMessage(), null, (Throwable)e);
            throw jmssre;
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.session = this.connection.createSession(sessionMode);
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ConnectionFactory connectionFactory, ContainerType containerType, int sessionMode) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(cf@" + connectionFactory.hashCode() + ", " + (Object)((Object)containerType) + ", " + sessionMode + ")");
        this.validateSessionMode(sessionMode);
        this.containerType = containerType;
        try {
            this.connection = connectionFactory.createConnection();
        }
        catch (SecurityException e) {
            throw new JMSSecurityRuntimeException(e.getMessage(), null, (Throwable)e);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.session = this.connection.createSession(sessionMode);
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContextImpl(ContainerType containerType, Set<JMSContext> contextSet, Connection connection, int sessionMode) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(" + (Object)((Object)containerType) + ", contextSet@" + contextSet.hashCode() + ", connection@" + connection.hashCode() + ", " + sessionMode + ")");
        this.validateSessionMode(sessionMode);
        this.containerType = containerType;
        this.connection = connection;
        try {
            this.session = connection.createSession(sessionMode);
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForExistingConnection(contextSet);
    }

    public JMSContextImpl(XAConnectionFactory xaConnectionFactory, ContainerType containerType, String userName, String password) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(xacf@" + xaConnectionFactory.hashCode() + ", " + (Object)((Object)containerType) + ", " + userName + ",)");
        this.containerType = containerType;
        try {
            this.connection = xaConnectionFactory.createXAConnection(userName, password);
        }
        catch (SecurityException e) {
            MQSecurityRuntimeException jsre = new MQSecurityRuntimeException(e.getMessage(), null, e);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jsre);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.session = ((XAConnection)this.connection).createXASession();
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContextImpl(XAConnectionFactory xaConnectionFactory, ContainerType containerType) {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + "(xacf@" + xaConnectionFactory.hashCode() + ", " + (Object)((Object)containerType) + ")");
        this.containerType = containerType;
        try {
            this.connection = xaConnectionFactory.createXAConnection();
        }
        catch (SecurityException e) {
            MQSecurityRuntimeException jsre = new MQSecurityRuntimeException(e.getMessage(), null, e);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jsre);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.session = ((XAConnection)this.connection).createXASession();
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContextImpl() {
        contextLogger.fine("JMSContext@" + this.hashCode() + "()");
    }

    private void validateSessionMode(int sessionMode) {
        if (sessionMode != 1 && sessionMode != 2 && sessionMode != 3 && sessionMode != 0) {
            String errorString = AdministeredObject.cr.getKString("C4309", sessionMode);
            MQRuntimeException jmsre = new MQRuntimeException(errorString, "C4309");
            ExceptionHandler.throwJMSRuntimeException(jmsre);
        }
    }

    protected void initializeForNewConnection() {
        this.contextSet = new HashSet<JMSContext>();
        this.contextSet.add(this);
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + ".initializeForNewConnection(): connection@" + this.connection.hashCode() + ", session@" + this.session.hashCode() + ", contextSet@" + this.contextSet.hashCode() + "(" + this.contextSet.size() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForExistingConnection(Set<JMSContext> existingContextSet) {
        int size = 0;
        int hashcode = 0;
        Set<JMSContext> set = existingContextSet;
        synchronized (set) {
            size = existingContextSet.size();
            hashcode = existingContextSet.hashCode();
            this.contextSet = existingContextSet;
            this.contextSet.add(this);
        }
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + ".initializeForExistingConnection(): connection@" + this.connection.hashCode() + ", session@" + this.session.hashCode() + ", contextSet@" + hashcode + "(" + size + ")");
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ JMSContextImpl dump start ------");
        ps.println("autoStart=" + this.autoStart);
        ps.println("closed=" + this.closed);
        ps.println("containerType=" + (Object)((Object)this.containerType));
        ps.println("contextSet contains " + this.contextSet.size() + " JMSContexts");
        ps.println("Here is the Connection:");
        if (this.connection instanceof Traceable) {
            ((Traceable)this.connection).dump(ps);
        }
        ps.println("Here is the Session:");
        if (this.session instanceof Traceable) {
            ((Traceable)this.session).dump(ps);
        }
        ps.println("Here is the MessageProducer:");
        if (this.messageProducer instanceof Traceable) {
            ((Traceable)this.messageProducer).dump(ps);
        }
        ps.println("------ JMSContextImpl dump end ------");
    }

    public JMSContext createContext(int sessionMode) {
        if (this.containerType == ContainerType.JavaEE_Web_or_EJB) {
            String errorString = AdministeredObject.cr.getKString("C4306");
            throw new MQRuntimeException(errorString);
        }
        this.checkNotClosed();
        this.disallowSetClientID();
        return new JMSContextImpl(this.containerType, this.contextSet, this.connection, sessionMode);
    }

    public JMSProducer createProducer() {
        this.checkNotClosed();
        this.disallowSetClientID();
        return new JMSProducerImpl(this);
    }

    public String getClientID() {
        this.checkNotClosed();
        try {
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void setClientID(String clientID) {
        if (this.containerType == ContainerType.JavaEE_Web_or_EJB) {
            String errorString = AdministeredObject.cr.getKString("C4306");
            MQRuntimeException jmsre = new MQRuntimeException(errorString, "C4306");
            ExceptionHandler.throwJMSRuntimeException(jmsre);
        }
        this.checkNotClosed();
        this.checkSetClientIDAllowed();
        this.checkClientID(clientID);
        if (!(this.connection instanceof ContextableConnection)) {
            throw new RuntimeException("Not yet implemented for " + this.connection.getClass());
        }
        ((ContextableConnection)this.connection)._setClientIDForContext(clientID);
        this.disallowSetClientID();
    }

    public ConnectionMetaData getMetaData() {
        this.checkNotClosed();
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public ExceptionListener getExceptionListener() {
        this.checkNotClosed();
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        this.checkNotClosed();
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        this.disallowSetClientID();
    }

    public void start() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void stop() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.connection.stop();
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.checkNotClosed();
        this.disallowSetClientID();
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        this.checkNotClosed();
        return this.autoStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        contextLogger.log(Level.FINE, "JMSContext@" + this.hashCode() + ".close(): connection@" + (this.connection == null ? "null" : Integer.valueOf(this.connection.hashCode())));
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (JMSConsumer consumer : this.consumers) {
            consumer.close();
        }
        if (!this.consumers.isEmpty()) {
            throw new RuntimeException("Debug: consumers not empty");
        }
        if (this.messageProducer != null) {
            try {
                this.messageProducer.close();
                this.messageProducer = null;
            }
            catch (IllegalStateException e) {
                throw new MQIllegalStateRuntimeException(e);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        try {
            this.session.close();
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        Set<JMSContext> set = this.contextSet;
        synchronized (set) {
            if (!this.contextSet.contains(this)) {
                throw new RuntimeException("I am not in the context set");
            }
            this.contextSet.remove(this);
            if (this.contextSet.contains(this)) {
                throw new RuntimeException("I am not in the context set");
            }
            if (this.contextSet.isEmpty()) {
                try {
                    this.connection.close();
                }
                catch (IllegalStateException e) {
                    throw new MQIllegalStateRuntimeException(e);
                }
                catch (JMSException e) {
                    throw new MQRuntimeException(e);
                }
            }
        }
        this.closed = true;
    }

    public BytesMessage createBytesMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createBytesMessage();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public MapMessage createMapMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createMapMessage();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public Message createMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createMessage();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createObjectMessage();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createObjectMessage(object);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public StreamMessage createStreamMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createStreamMessage();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public TextMessage createTextMessage() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createTextMessage();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public TextMessage createTextMessage(String text) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createTextMessage(text);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public boolean getTransacted() {
        this.checkNotClosed();
        try {
            return this.session.getTransacted();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public int getSessionMode() {
        this.checkNotClosed();
        try {
            return this.session.getAcknowledgeMode();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void commit() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.session.commit();
        }
        catch (TransactionRolledBackException e) {
            throw new MQTransactionRolledBackRuntimeException(e);
        }
        catch (TransactionInProgressException e) {
            throw new MQTransactionInProgressRuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void rollback() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.session.rollback();
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void recover() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            this.session.recover();
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseConsumer(this, destination);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseConsumer(this, destination, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseConsumer(this, destination, messageSelector, noLocal);
        this.addConsumer(consumer);
        return consumer;
    }

    public Queue createQueue(String queueName) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createQueue(queueName);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public Topic createTopic(String topicName) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createTopic(topicName);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseDurableConsumer(this, topic, name);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseDurableConsumer(this, topic, name, messageSelector, noLocal);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedDurableConsumer(this, topic, name);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedDurableConsumer(this, topic, name, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedConsumer(this, topic, sharedSubscriptionName);
        this.addConsumer(consumer);
        return consumer;
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        JMSConsumerImpl consumer = new JMSConsumerImpl();
        consumer.initialiseSharedConsumer(this, topic, sharedSubscriptionName, messageSelector);
        this.addConsumer(consumer);
        return consumer;
    }

    public QueueBrowser createBrowser(Queue queue) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createBrowser(queue);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createBrowser(queue, messageSelector);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (InvalidSelectorException e) {
            throw new MQInvalidSelectorRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        this.checkNotClosed();
        this.disallowSetClientID();
        try {
            return this.session.createTemporaryQueue();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.session.createTemporaryTopic();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void unsubscribe(String name) {
        this.checkNotClosed();
        try {
            this.session.unsubscribe(name);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    public void acknowledge() {
        if (this.closed) {
            String errorString = AdministeredObject.cr.getKString("C4307");
            throw new IllegalStateRuntimeException(errorString, "C4307");
        }
        try {
            if (this.session.getAcknowledgeMode() != 2) {
                return;
            }
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        this.disallowSetClientID();
        if (this.session instanceof ContextableSession) {
            try {
                ((ContextableSession)this.session).clientAcknowledge();
            }
            catch (IllegalStateException e) {
                throw new MQIllegalStateRuntimeException(e);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        } else {
            throw new IllegalStateRuntimeException("Session implementation " + this.session.getClass() + " not yet supported");
        }
    }

    private void addConsumer(JMSConsumer consumer) {
        this.consumers.add(consumer);
    }

    protected void removeConsumer(JMSConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private void checkSetClientIDAllowed() {
        boolean throwex = false;
        JMSException ex = null;
        try {
            if (!this.allowToSetClientID || this.connection.getClientID() != null) {
                throwex = true;
            }
        }
        catch (JMSException e) {
            ex = e;
        }
        if (throwex || ex != null) {
            String errorString = AdministeredObject.cr.getKString("C4054");
            IllegalStateRuntimeException isre = new IllegalStateRuntimeException(errorString, "C4054", (Throwable)ex);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)isre);
        }
    }

    protected void checkClientID(String clientID) {
        if (clientID == null || clientID.trim().length() == 0) {
            String errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
            InvalidClientIDRuntimeException jmse = new InvalidClientIDRuntimeException(errorString, "C4053");
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jmse);
        }
    }

    protected void disallowSetClientID() {
        this.allowToSetClientID = false;
    }

    protected MessageProducer getMessageProducer() {
        if (this.messageProducer == null) {
            try {
                this.messageProducer = this.session.createProducer(null);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        return this.messageProducer;
    }

    protected void checkNotClosed() {
        if (this.closed) {
            String errorString = AdministeredObject.cr.getKString("C4307");
            throw new MQRuntimeException(errorString, "C4307");
        }
    }

    protected Session _getSession() {
        return this.session;
    }

    public Connection _getConnection() {
        return this.connection;
    }
}

