/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;

public abstract class TemporaryDestination
extends Destination {
    protected ConnectionImpl connection = null;
    private boolean isDeleted = false;

    protected TemporaryDestination(ConnectionImpl connection, String destination_type) throws JMSException {
        super("temporary_destination://" + destination_type + connection.getClientIDOrIPAddress() + "/" + connection.getProtocolHandler().getConnID() + "/" + connection.getTempDestSequence());
        this.connection = connection;
        connection.protocolHandler.createDestination(this);
        connection.addTempDest(this);
    }

    protected TemporaryDestination(String name) throws JMSException {
        super(name);
    }

    protected TemporaryDestination() throws JMSException {
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    public void delete() throws JMSException {
        if (this.isDeleted) {
            return;
        }
        if (this.connection == null) {
            String errorString = AdministeredObject.cr.getKString("C4039");
            throw new JMSException(errorString, "C4039");
        }
        this.checkConsumer();
        this.connection.decreaseTempDestCounter();
        this.connection.removeTempDest(this);
        this.isDeleted = true;
        this.connection.getProtocolHandler().deleteDestination(this);
    }

    public static void checkTemporaryDestinationConsumerAllowed(ConnectionImpl connection, javax.jms.Destination dest) throws JMSException {
        String name = null;
        String prefix = null;
        String conn_id = null;
        if (dest instanceof TemporaryQueue) {
            name = ((Queue)dest).getQueueName();
            prefix = "temporary_destination://queue/";
        } else if (dest instanceof TemporaryTopic) {
            name = ((Topic)dest).getTopicName();
            prefix = "temporary_destination://topic/";
        }
        if (name != null) {
            conn_id = connection.getClientIDOrIPAddress() + "/" + connection.getProtocolHandler().getConnID() + "/";
            if (!name.startsWith(prefix + conn_id)) {
                String errorString = AdministeredObject.cr.getKString("C4020", name);
                throw new JMSException(errorString, "C4020");
            }
        }
    }

    protected void checkConsumer() throws JMSException {
        boolean foundConsumer = false;
        String myName = this.getName();
        Object[] consumers = this.connection.interestTable.toArray();
        Consumer consumer = null;
        String destName = null;
        Destination dest = null;
        for (int index = 0; index < consumers.length; ++index) {
            consumer = (Consumer)consumers[index];
            dest = (Destination)consumer.getDestination();
            destName = dest.getName();
            if (!myName.equals(destName)) continue;
            foundConsumer = true;
            break;
        }
        if (foundConsumer) {
            String errorString = AdministeredObject.cr.getKString("C4039");
            throw new JMSException(errorString, "C4039");
        }
    }

    public boolean checkSendCreateDest(javax.jms.Destination dest, ConnectionImpl con) {
        try {
            TemporaryDestination.checkTemporaryDestinationConsumerAllowed(con, dest);
        }
        catch (JMSException jmsEx) {
            return false;
        }
        return true;
    }

    protected boolean isDeleted() {
        return this.isDeleted;
    }
}

