/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.JMSContextImpl;
import com.sun.messaging.jms.MQRuntimeException;
import com.sun.messaging.jms.MQSecurityRuntimeException;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAJMSContext;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class XAJMSContextImpl
extends JMSContextImpl
implements XAJMSContext {
    XAConnection xaConnection;
    XASession xaSession;

    public XAJMSContextImpl(XAConnectionFactory connectionFactory, ContainerType containerType, String userName, String password) {
        this.containerType = containerType;
        try {
            this.xaConnection = connectionFactory.createXAConnection(userName, password);
            this.connection = this.xaConnection;
        }
        catch (SecurityException e) {
            MQSecurityRuntimeException jsre = new MQSecurityRuntimeException(e.getMessage(), null, e);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jsre);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.xaSession = this.xaConnection.createXASession();
            this.session = this.xaSession;
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public XAJMSContextImpl(XAConnectionFactory connectionFactory, ContainerType containerType) {
        this.containerType = containerType;
        try {
            this.xaConnection = connectionFactory.createXAConnection();
            this.connection = this.xaConnection;
        }
        catch (SecurityException e) {
            MQSecurityRuntimeException jsre = new MQSecurityRuntimeException(e.getMessage(), null, e);
            ExceptionHandler.throwJMSRuntimeException((JMSRuntimeException)jsre);
        }
        catch (JMSSecurityException e) {
            throw new MQSecurityRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            this.xaSession = this.xaConnection.createXASession();
            this.session = this.xaSession;
        }
        catch (JMSException e) {
            try {
                this.connection.close();
            }
            catch (JMSException e1) {
                // empty catch block
            }
            throw new MQRuntimeException(e);
        }
        this.initializeForNewConnection();
    }

    public JMSContext getContext() {
        return this;
    }

    public XAResource getXAResource() {
        return this.xaSession.getXAResource();
    }

    @Override
    public boolean getTransacted() {
        return super.getTransacted();
    }

    @Override
    public void commit() {
        super.commit();
    }

    @Override
    public void rollback() {
        super.rollback();
    }
}

