/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import java.io.PrintStream;

class ReceiveQueue
extends SessionQueue {
    private boolean receiveInProcess = false;

    public ReceiveQueue() {
    }

    public ReceiveQueue(boolean useSequential, int size) {
        super(useSequential, size);
    }

    @Override
    protected synchronized Object dequeueWait() {
        return this.dequeueWait(0L);
    }

    @Override
    protected synchronized Object dequeueWait(long timeout) {
        long waitTime = timeout;
        boolean expired = false;
        while (this.isEmpty() || this.isLocked) {
            if (this.isClosed || expired) {
                return null;
            }
            try {
                long elapsed;
                if (timeout == 0L) {
                    this.wait(0L);
                    continue;
                }
                long st = System.currentTimeMillis();
                this.wait(waitTime);
                if (!this.isEmpty() && !this.isLocked || (waitTime -= (elapsed = System.currentTimeMillis() - st)) > 0L) continue;
                expired = true;
            }
            catch (InterruptedException e) {}
        }
        if (this.isClosed) {
            return null;
        }
        this.receiveInProcess = true;
        return this.dequeue();
    }

    protected synchronized void setReceiveInProcess(boolean state) {
        this.receiveInProcess = state;
        this.notifyAll();
    }

    protected synchronized void stop() {
        this.isLocked = true;
        this.waitUntilReceiveIsDone();
        if (this.debug) {
            Debug.println("receive queue 'stop' called ...");
        }
    }

    protected synchronized void stopNoWait() {
        this.isLocked = true;
    }

    @Override
    protected synchronized void start() {
        if (!this.isEmpty()) {
            this.setIsLocked(false);
        } else {
            this.isLocked = false;
        }
        if (this.debug) {
            Debug.println("receive queue 'start' called ...");
        }
    }

    protected synchronized void waitUntilReceiveIsDone() {
        try {
            while (this.isLocked && this.receiveInProcess) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ ReceiveQueue dump ------");
        ps.println("isLocked: " + this.isLocked);
        ps.println("receiveInProcess: " + this.receiveInProcess);
        ps.println("isClosed: " + this.isClosed);
        if (this.size() > 0) {
            ps.println("^^^^^^ receive queue super class dump ^^^^^^");
            super.dump(ps);
            ps.println("^^^^^^ end receive queue super class dump ^^^^^^");
        }
    }
}

