/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.memory.MemoryGlobals;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerDownException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.Ordered;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.Sized;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class PacketReference
implements Sized,
Ordered {
    private static FaultInjection FI = FaultInjection.getInjection();
    private static ConsumerUID queueUID = null;
    private static boolean PREPEND_ID = Globals.getConfig().getBooleanProperty("imq.fix.JMSMessageID", false);
    private boolean commit2pwait = Globals.getConfig().getBooleanProperty("imq.cluster.2pcommitAckWaitReply", false);
    private static boolean DEBUG;
    private static boolean DEBUG_CLUSTER_TXN;
    private boolean isStored = false;
    private boolean neverStore = false;
    private boolean isStoredWithInterest = false;
    private HashMap attachedData = null;
    private boolean destroyed = false;
    private SysMessageID msgid;
    transient ConnectionUID con_uid;
    private long creationtime;
    private long lastaccesstime;
    private int sequence;
    private boolean persist;
    private Set lbit_set = null;
    private boolean sendMessageDeliveredAck = false;
    private long size;
    private Hashtable props;
    private HashMap headers;
    private Object pktPtr;
    private int priority = 4;
    boolean isQueue = false;
    boolean invalid = false;
    boolean overrided = false;
    Object lockObject = new Object();
    boolean canLock = false;
    boolean locked = false;
    boolean overriding = false;
    Thread lockOwner = null;
    private Object destroyRemoteLock = new Object();
    private List<Thread> destroyRemoteReadLocks = new ArrayList<Thread>();
    private Thread destroyRemoteWriteLockThread = null;
    DestinationUID destination = null;
    private ExpirationInfo expireInfo = null;
    private boolean expired = false;
    MessageDeliveryTimeInfo deliveryTimeInfo = null;
    long timestamp = 0L;
    TransactionUID transactionid;
    transient boolean overrideRedeliver = false;
    transient BrokerAddress addr = null;
    transient Destination d = null;
    transient String clientID = null;
    int interestCnt;
    int deliveredCnt;
    int ackCnt;
    int deadCnt;
    Map ackInfo = null;
    private static final int INITIAL = 0;
    private static final int ROUTED = 1;
    private static final int DELIVERED = 2;
    private static final int CONSUMED = 3;
    private static final int ACKED = 4;
    private static final int DEAD = 5;
    Map inDelivery = new ConcurrentHashMap();
    boolean inRemoval = false;
    boolean inReplacing = false;
    ConsumerUID lastDead = null;
    private PartitionedStore pstore = null;
    Object order = null;
    Set deliveredMsgAcks = new HashSet();
    LinkedHashMap<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> remoteConsumerUIDs = new LinkedHashMap();

    public PartitionedStore getPartitionedStore() {
        return this.pstore;
    }

    @Override
    public Object getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Object o) {
        this.order = o;
    }

    public static ConsumerUID getQueueUID() {
        return queueUID;
    }

    public static PacketReference createReferenceWithDestination(PartitionedStore ps, Packet p, Destination dest, Connection con) throws BrokerException {
        PacketReference ref = PacketReference.createReference(ps, p, dest.getDestinationUID(), con);
        if (dest.isDMQ()) {
            ref.clearDeliveryTimeInfo();
        }
        return ref;
    }

    public static PacketReference createReference(PartitionedStore ps, Packet p, DestinationUID duid, Connection con) throws BrokerException {
        PacketReference pr = new PacketReference(ps, p, duid, con);
        if (con != null && (pr.getExpireInfo() != null || pr.getDeliveryTimeInfo() != null)) {
            con.checkClockSkew(pr.getTime(), pr.getTimestamp(), pr.getExpireTime(), pr.getDeliveryTime());
        }
        return pr;
    }

    public static PacketReference createReference(PartitionedStore ps, Packet p, Connection con) throws BrokerException {
        return PacketReference.createReference(ps, p, null, con);
    }

    public static void moveMessage(PartitionedStore storep, PacketReference oldLoc, PacketReference newLoc, Set targets) throws BrokerException, IOException {
        if (targets == null) {
            throw new RuntimeException("Internal error: moving message to null targets not supported");
        }
        if (!oldLoc.isStored && oldLoc.persist) {
            newLoc.store(targets);
            return;
        }
        Object uids = null;
        Object states = null;
        ReturnInfo info = PacketReference.calculateConsumerInfo(targets, oldLoc.persist);
        newLoc.ackInfo = info.ackInfo;
        newLoc.ackCnt = info.ackInfo.size();
        if (info.uids == null || info.uids.length == 0) {
            newLoc.neverStore = true;
            newLoc.isStored = false;
            newLoc.isStoredWithInterest = false;
            return;
        }
        if (oldLoc.isStored && oldLoc.persist && !oldLoc.neverStore) {
            storep.moveMessage(newLoc.getPacket(), oldLoc.getDestinationUID(), newLoc.getDestinationUID(), info.uids, info.states, Destination.PERSIST_SYNC);
            newLoc.isStored = true;
            newLoc.isStoredWithInterest = true;
            oldLoc.isStored = false;
            oldLoc.isStoredWithInterest = false;
        } else if (oldLoc.persist) {
            storep.storeMessage(newLoc.getDestinationUID(), newLoc.getPacket(), info.uids, info.states, Destination.PERSIST_SYNC);
            newLoc.isStored = true;
            newLoc.isStoredWithInterest = true;
            newLoc.neverStore = false;
        } else {
            newLoc.isStored = false;
            newLoc.isStoredWithInterest = false;
            newLoc.neverStore = true;
        }
    }

    private static ReturnInfo calculateConsumerInfo(Collection consumers, boolean checkStored) {
        if (consumers.isEmpty()) {
            return null;
        }
        ReturnInfo ri = new ReturnInfo();
        ri.ackInfo = Collections.synchronizedMap(new HashMap());
        ArrayList<ConsumerUID> storedConsumers = checkStored ? new ArrayList<ConsumerUID>() : null;
        Iterator itr = consumers.iterator();
        boolean count = false;
        while (itr.hasNext()) {
            Object o = itr.next();
            ConsumerUID cuid = null;
            cuid = o instanceof Consumer ? ((Consumer)o).getStoredConsumerUID() : (ConsumerUID)o;
            ++ri.interestCnt;
            boolean store = false;
            if (storedConsumers != null && cuid.shouldStore()) {
                storedConsumers.add(cuid);
                store = true;
            }
            ConsumerMessagePair cmp = new ConsumerMessagePair(cuid, store);
            ri.ackInfo.put(cuid, cmp);
        }
        if (storedConsumers != null) {
            ConsumerUID[] type = new ConsumerUID[]{};
            ri.uids = storedConsumers.toArray(type);
            ri.states = new int[ri.uids.length];
            for (int i = 0; i < ri.states.length; ++i) {
                ri.states[i] = 0;
            }
        }
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PacketReference(PartitionedStore ps, Packet pkt, DestinationUID duid, Connection con) throws BrokerException {
        this.pstore = ps;
        this.lastaccesstime = this.creationtime = System.currentTimeMillis();
        this.msgid = (SysMessageID)pkt.getSysMessageID().clone();
        this.isQueue = pkt.getIsQueue();
        this.persist = pkt.getPersistent();
        this.priority = pkt.getPriority();
        this.sequence = pkt.getSequence();
        this.timestamp = pkt.getTimestamp();
        if (pkt.getRedelivered()) {
            this.overrideRedeliver = true;
        }
        if (con != null) {
            this.clientID = (String)con.getClientData("client id");
        }
        this.setExpireTime(pkt.getExpiration());
        this.size = pkt.getPacketSize();
        String d = pkt.getDestination();
        this.con_uid = con == null ? null : con.getConnectionUID();
        this.destination = duid != null ? duid : DestinationUID.getUID(d, this.isQueue);
        long tid = pkt.getTransactionID();
        PacketReference packetReference = this;
        synchronized (packetReference) {
            this.setPacketObject(false, pkt);
        }
        this.transactionid = tid != 0L ? new TransactionUID(tid) : null;
        this.setDeliveryTime(pkt.getDeliveryTime());
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    public String getClientID() {
        return this.clientID;
    }

    private ConsumerMessagePair getAck(Object obj) {
        ConsumerUID cuid = null;
        if (obj instanceof ConsumerUID) {
            cuid = (ConsumerUID)obj;
        } else if (obj instanceof Consumer) {
            cuid = ((Consumer)obj).getConsumerUID();
        } else {
            throw new RuntimeException("Bogus ID");
        }
        if (this.ackInfo == null) {
            throw new RuntimeException("No AckInfo for message " + this.getSysMessageID());
        }
        return (ConsumerMessagePair)this.ackInfo.get(cuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeConsumerForDeliveryDelayed(Consumer c) {
        if (this.ackInfo == null) {
            return false;
        }
        ConsumerUID suid = c.getStoredConsumerUID();
        ConsumerMessagePair cmp = (ConsumerMessagePair)this.ackInfo.get(suid);
        if (cmp == null) {
            return false;
        }
        this.ackInfo.remove(suid);
        boolean rm = false;
        PacketReference packetReference = this;
        synchronized (packetReference) {
            --this.interestCnt;
            rm = this.interestCnt == 0;
        }
        if (!this.isLocal() && rm) {
            this.acquireDestroyRemoteReadLock();
            packetReference = this;
            synchronized (packetReference) {
                rm = this.interestCnt == 0;
            }
            if (!rm) {
                this.clearDestroyRemoteReadLock();
            }
        }
        return rm;
    }

    protected Collection getAllConsumerUIDForDeliveryDelayed() {
        return this.ackInfo.keySet();
    }

    public void setDestination(Destination d) {
        this.d = d;
    }

    public Destination getDestination() {
        if (this.d == null) {
            Globals.getDestinationList();
            Destination[] ds = DestinationList.getDestination(this.pstore, this.destination);
            this.d = ds[0];
            if (this.d != null && this.d.isDMQ()) {
                this.clearDeliveryTimeInfo();
            }
        }
        return this.d;
    }

    public boolean isStored() {
        return this.isStored;
    }

    public void setBrokerAddress(BrokerAddress a) {
        this.addr = a;
        if (!this.isLocal()) {
            this.clearDeliveryTimeInfo();
        }
    }

    public BrokerAddress getBrokerAddress() {
        return this.addr;
    }

    public boolean isLocal() {
        return this.addr == null || this.addr == Globals.getMyAddress();
    }

    public String toString() {
        return "PacketReference[" + this.msgid + "]";
    }

    public synchronized boolean getMessageDeliveredAck(ConsumerUID uid) {
        return !this.deliveredMsgAcks.isEmpty() && this.deliveredMsgAcks.contains(uid);
    }

    public synchronized ConsumerUID[] getConsumersForMsgDelivered() {
        return this.deliveredMsgAcks.toArray(new ConsumerUID[this.deliveredMsgAcks.size()]);
    }

    public synchronized void removeMessageDeliveredAck(ConsumerUID uid) {
        this.deliveredMsgAcks.remove(uid);
    }

    public synchronized void addMessageDeliveredAck(ConsumerUID uid) {
        this.deliveredMsgAcks.add(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteConsumerUID(ConsumerUID suid, ConsumerUID cuid, ConnectionUID connuid) {
        LinkedHashMap<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> linkedHashMap = this.remoteConsumerUIDs;
        synchronized (linkedHashMap) {
            LinkedHashMap<ConsumerUID, ConnectionUID> m = this.remoteConsumerUIDs.get(suid);
            if (m == null) {
                m = new LinkedHashMap();
                this.remoteConsumerUIDs.put(suid, m);
            }
            m.put(cuid, connuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteConsumerUID(ConsumerUID suid, ConsumerUID cuid) {
        this.acquireDestroyRemoteReadLock();
        try {
            LinkedHashMap<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> linkedHashMap = this.remoteConsumerUIDs;
            synchronized (linkedHashMap) {
                LinkedHashMap<ConsumerUID, ConnectionUID> m = this.remoteConsumerUIDs.get(suid);
                if (m != null) {
                    m.remove(cuid);
                    if (m.isEmpty()) {
                        this.remoteConsumerUIDs.remove(suid);
                    }
                }
            }
        }
        finally {
            this.clearDestroyRemoteReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNoAckRemoteConsumers() {
        this.acquireDestroyRemoteReadLock();
        try {
            Iterator<Map.Entry<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>>> itr = null;
            Map.Entry<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> pair2 = null;
            LinkedHashMap<ConsumerUID, ConnectionUID> m = null;
            Iterator<ConsumerUID> itr1 = null;
            ConsumerUID cuid2 = null;
            ConsumerUID suid = null;
            LinkedHashMap<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> linkedHashMap = this.remoteConsumerUIDs;
            synchronized (linkedHashMap) {
                for (Map.Entry<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> pair2 : this.remoteConsumerUIDs.entrySet()) {
                    suid = pair2.getKey();
                    m = pair2.getValue();
                    if (m == null || m.isEmpty()) continue;
                    try {
                        if (this.isAcknowledged(suid)) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                    for (ConsumerUID cuid2 : m.keySet()) {
                        if (cuid2.isNoAck()) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.clearDestroyRemoteReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastRemoteConsumerUID(ConsumerUID suid, ConsumerUID cuid) {
        ConsumerUID lastuid2 = null;
        LinkedHashMap<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> linkedHashMap = this.remoteConsumerUIDs;
        synchronized (linkedHashMap) {
            LinkedHashMap<ConsumerUID, ConnectionUID> m = this.remoteConsumerUIDs.get(suid);
            if (DEBUG) {
                Globals.getLogger().log(8, "PacketReference.isLastRemoteConsumerUID(" + suid + ", " + cuid + "): " + m + ", ref@" + this.hashCode() + "=" + this);
            }
            if (m == null) {
                return true;
            }
            for (ConsumerUID lastuid2 : m.keySet()) {
                if (!DEBUG) continue;
                Globals.getLogger().log(8, "PacketReference.isLastRemoteConsumerUID(" + suid + ", " + cuid + "): lastuid=" + lastuid2 + ", ref@" + this.hashCode() + "=" + this);
            }
            return lastuid2 == null || lastuid2.equals(cuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ConsumerUID, ConnectionUID> getRemoteConsumerUIDs() {
        LinkedHashMap<ConsumerUID, ConnectionUID> allm = new LinkedHashMap<ConsumerUID, ConnectionUID>();
        LinkedHashMap<ConsumerUID, LinkedHashMap<ConsumerUID, ConnectionUID>> linkedHashMap = this.remoteConsumerUIDs;
        synchronized (linkedHashMap) {
            Iterator<LinkedHashMap<ConsumerUID, ConnectionUID>> itr = this.remoteConsumerUIDs.values().iterator();
            LinkedHashMap<ConsumerUID, ConnectionUID> m = null;
            while (itr.hasNext()) {
                m = itr.next();
                if (m == null || m.isEmpty()) continue;
                allm.putAll(m);
            }
        }
        return allm;
    }

    private void setExpireTime(long time) {
        this.expireInfo = time == 0L ? null : new ExpirationInfo(this.msgid, time);
    }

    public long getExpireTime() {
        if (this.expireInfo == null) {
            return 0L;
        }
        return this.expireInfo.getExpireTime();
    }

    public ExpirationInfo getExpireInfo() {
        return this.expireInfo;
    }

    private void setDeliveryTime(long time) {
        this.deliveryTimeInfo = time == 0L ? null : new MessageDeliveryTimeInfo(this.msgid, time);
    }

    public long getDeliveryTime() {
        if (this.deliveryTimeInfo == null) {
            return 0L;
        }
        return this.deliveryTimeInfo.getDeliveryTime();
    }

    public boolean isDeliveryDue() {
        if (this.deliveryTimeInfo == null) {
            return true;
        }
        return this.deliveryTimeInfo.isDeliveryDue();
    }

    public MessageDeliveryTimeInfo getDeliveryTimeInfo() {
        this.getDestination();
        return this.deliveryTimeInfo;
    }

    public void overrided() {
        this.overrided = true;
    }

    public boolean isOverrided() {
        return this.overrided;
    }

    public void overriding() {
        this.overriding = true;
    }

    public boolean isOverriding() {
        return this.overriding;
    }

    public void lock() {
        this.canLock = true;
        this.locked = true;
        this.lockOwner = Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lockObject;
        synchronized (object) {
            this.locked = false;
            this.lockOwner = null;
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReference checkLock(boolean wait) {
        if (!this.canLock) {
            return this;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.locked && this.lockOwner != null && Thread.currentThread() == this.lockOwner) {
                return this;
            }
            while (wait && this.locked) {
                Globals.getLogger().log(8, "Wait for reference : " + this);
                try {
                    this.lockObject.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.locked) {
                return null;
            }
        }
        return this;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    private Packet getPacketObject() {
        assert (this.pktPtr == null || this.pktPtr instanceof SoftReference || this.pktPtr instanceof Packet) : this.pktPtr;
        Object ptr = this.pktPtr;
        if (ptr == null) {
            return null;
        }
        if (ptr instanceof SoftReference) {
            return (Packet)((SoftReference)this.pktPtr).get();
        }
        return (Packet)this.pktPtr;
    }

    private void setPacketObject(boolean soft, Packet p) {
        assert (Thread.holdsLock(this));
        this.pktPtr = soft ? new SoftReference<Packet>(p) : p;
    }

    private void makePacketSoftRef() {
        assert (Thread.holdsLock(this));
        Object ptr = this.pktPtr;
        if (ptr != null && ptr instanceof Packet) {
            this.pktPtr = new SoftReference<Object>(ptr);
        }
    }

    public void setNeverStore(boolean s) {
        this.neverStore = s;
    }

    public boolean getNeverStore() {
        return this.neverStore;
    }

    @Override
    public long byteSize() {
        return this.size;
    }

    public void setStoredWithInterest(boolean withInterest) {
        this.isStoredWithInterest = withInterest;
    }

    public synchronized void setLoaded() {
        this.isStored = true;
        this.makePacketSoftRef();
    }

    public ConnectionUID getProducingConnectionUID() {
        return this.con_uid;
    }

    public int getPriority() {
        return this.priority;
    }

    public TransactionUID getTransactionID() {
        return this.transactionid;
    }

    public boolean getIsQueue() {
        return this.isQueue;
    }

    public long getTime() {
        return this.creationtime;
    }

    public long getSequence() {
        return this.sequence;
    }

    public synchronized void setLastBit(ConsumerUID id) throws IllegalStateException {
        if (this.isInvalid() && this.isDestroyed()) {
            throw new IllegalStateException(Globals.getBrokerResources().getString("B4117", "reference has been destroyed"));
        }
        if (this.lbit_set == null) {
            this.lbit_set = new HashSet();
        }
        this.lbit_set.add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("AckCount", String.valueOf(this.ackCnt));
        ht.put("DeadCount", String.valueOf(this.deadCnt));
        ht.put("ackInfo[#]", String.valueOf(this.ackInfo.size()));
        ht.put("interestCount", String.valueOf(this.interestCnt));
        ht.put("inRemoval", this.inRemoval);
        ht.put("inReplacing", this.inReplacing);
        Vector vt = new Vector();
        ArrayList l = null;
        PacketReference packetReference = this;
        synchronized (packetReference) {
            ht.put("inDeliverySize", String.valueOf(this.inDelivery.size()));
            l = new ArrayList(this.inDelivery.keySet());
        }
        Iterator<Object> itr = l.iterator();
        while (itr.hasNext()) {
            vt.add(itr.next());
        }
        ht.put("InDelivery", vt);
        vt = new Vector();
        ConsumerMessagePair cmp = null;
        Map map = this.ackInfo;
        synchronized (map) {
            for (Object key : this.ackInfo.keySet()) {
                try {
                    cmp = this.getAck(key);
                }
                catch (Exception e) {
                    vt.add(key + ":" + e.toString());
                    continue;
                }
                vt.add(cmp == null ? key + ":null" : cmp.toString());
            }
        }
        if (!vt.isEmpty()) {
            ht.put("Acks", vt);
        }
        return ht;
    }

    public synchronized boolean isLast(ConsumerUID id) {
        if (this.lbit_set == null) {
            return false;
        }
        return this.lbit_set.contains(id);
    }

    public synchronized void removeIsLast(ConsumerUID id) {
        if (this.lbit_set == null) {
            return;
        }
        this.lbit_set.remove(id);
        if (this.lbit_set.isEmpty() && this.invalid) {
            this.destroy();
        }
    }

    public synchronized boolean getLBitSet() {
        return this.lbit_set != null && !this.lbit_set.isEmpty();
    }

    public DestinationUID getDestinationUID() {
        return this.destination;
    }

    public String getDestinationName() {
        return this.destination.getName();
    }

    public synchronized Packet getPacket() {
        Packet pkt = this.getPacketObject();
        if (pkt != null || this.destroyed) {
            return pkt;
        }
        if (!this.persist) {
            return null;
        }
        pkt = this.recoverPacket();
        assert (pkt != null);
        this.setPacketObject(true, pkt);
        return pkt;
    }

    private Packet recoverPacket() {
        assert (Thread.holdsLock(this));
        assert (this.pktPtr == null || this.pktPtr instanceof SoftReference && ((Reference)this.pktPtr).get() == null);
        try {
            Packet p = this.pstore.getMessage(this.destination, this.msgid);
            assert (p != null);
            return p;
        }
        catch (BrokerException ex) {
            assert (false) : ex;
            Globals.getLogger().logStack(32, "B3144", this.msgid.toString(), (Throwable)ex);
            return null;
        }
    }

    public synchronized Hashtable getProperties() throws ClassNotFoundException {
        if (this.destroyed || this.invalid) {
            return new Hashtable();
        }
        this.lastaccesstime = System.currentTimeMillis();
        Packet pkt = this.getPacketObject();
        if (this.props == null && !this.destroyed) {
            if (pkt == null) {
                pkt = this.getPacket();
            }
            try {
                this.props = pkt.getProperties();
            }
            catch (IOException ex) {
                Globals.getLogger().log(8, "Internal Exception: ", ex);
                this.props = new Hashtable();
            }
            catch (ClassNotFoundException ex) {
                assert (false);
                throw ex;
            }
        }
        return this.props;
    }

    public synchronized HashMap getHeaders() {
        if (this.headers == null) {
            if (this.destroyed || this.invalid) {
                return new HashMap();
            }
            Packet pkt = this.getPacketObject();
            this.headers = new HashMap();
            if (pkt == null) {
                pkt = this.getPacket();
                if (DEBUG) {
                    Globals.getLogger().log(4, "reloaded packet for non-destroyed message " + this.msgid);
                }
                if (pkt == null) {
                    Globals.getLogger().log(32, "could not reload packet for non-destroyed message " + this.msgid);
                    return this.headers;
                }
            }
            this.headers.put("JMSPriority", this.priority);
            this.headers.put("JMSMessageID", (PREPEND_ID ? "ID:" : "") + this.msgid.toString());
            this.headers.put("JMSTimestamp", this.timestamp);
            this.headers.put("JMSDeliveryMode", pkt.getPersistent() ? "PERSISTENT" : "NON_PERSISTENT");
            this.headers.put("JMSCorrelationID", pkt.getCorrelationID());
            this.headers.put("JMSType", pkt.getMessageType());
        }
        return this.headers;
    }

    public SysMessageID getSysMessageID() {
        return this.msgid;
    }

    public String getSysMessageIDString() {
        HashMap headers = this.getHeaders();
        return (String)headers.get("JMSMessageID");
    }

    public long getCreateTime() {
        return this.creationtime;
    }

    public long getLastAccessTime() {
        return this.lastaccesstime;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long time) {
        this.timestamp = time;
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void overridePersistence(boolean persist) {
        this.persist = persist;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized boolean isInvalid() {
        return this.invalid;
    }

    public synchronized boolean checkDeliveryAndSetInRemoval() {
        if (this.destroyed || this.invalid || this.ackInfo == null) {
            this.inRemoval = true;
            return true;
        }
        if (this.ackCnt + this.deadCnt >= this.interestCnt) {
            this.inRemoval = true;
            return true;
        }
        if (this.inReplacing) {
            return false;
        }
        if (this.inDelivery.size() > 0) {
            return false;
        }
        this.inRemoval = true;
        return true;
    }

    protected synchronized boolean checkDeliveryAndSetInReplacing() {
        if (this.destroyed || this.invalid || this.inRemoval || this.isExpired() || this.inReplacing) {
            return false;
        }
        if (this.ackCnt + this.deadCnt >= this.interestCnt) {
            return false;
        }
        if (this.inDelivery.size() > 0) {
            return false;
        }
        this.inReplacing = true;
        return true;
    }

    protected synchronized void clearInReplacing() {
        this.inReplacing = false;
    }

    public synchronized boolean checkRemovalAndSetInDelivery(ConsumerUID sid) {
        if (this.destroyed || this.invalid || this.inRemoval || this.isExpired() || this.inReplacing) {
            return false;
        }
        this.inDelivery.put(sid, sid);
        return true;
    }

    public synchronized void removeInDelivery(ConsumerUID sid) {
        this.inDelivery.remove(sid);
    }

    public void overrideExpireTime(long expire) {
        this.setExpireTime(expire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        if (this.expireInfo == null) {
            return false;
        }
        if (this.expired) {
            return true;
        }
        boolean expiring = this.expireInfo.isExpired();
        if (expiring) {
            PacketReference packetReference = this;
            synchronized (packetReference) {
                this.makePacketSoftRef();
            }
        }
        return expiring;
    }

    protected void clearExpireInfo() {
        this.expired = true;
        this.expireInfo = null;
    }

    protected void clearDeliveryTimeInfo() {
        this.deliveryTimeInfo = null;
    }

    public boolean equals(Object obj) {
        if (this.msgid == null) {
            return this.msgid == obj;
        }
        if (obj instanceof PacketReference) {
            return this.msgid.equals(((PacketReference)obj).msgid);
        }
        return false;
    }

    public int hashCode() {
        return this.msgid == null ? 0 : this.msgid.hashCode();
    }

    public boolean matches(DestinationUID uid) {
        return true;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "INITIAL";
            }
            case 1: {
                return "ROUTED";
            }
            case 2: {
                return "DELIVERED";
            }
            case 3: {
                return "CONSUMED";
            }
            case 4: {
                return "ACKED";
            }
            case 5: {
                return "DEAD";
            }
        }
        return "UNKNOWN";
    }

    public synchronized void store() throws BrokerException {
        if (!this.destroyed && this.persist && !this.neverStore && !this.isStored) {
            assert (this.pktPtr instanceof Packet);
            try {
                this.pstore.storeMessage(this.destination, this.getPacket(), Destination.PERSIST_SYNC);
                this.makePacketSoftRef();
            }
            catch (IOException ex) {
                throw new BrokerException(ex.toString(), ex);
            }
            catch (Exception ex) {
                Globals.getLogger().logStack(32, "B2011", this.msgid.toString(), (Throwable)ex);
                throw new BrokerException(ex.toString(), ex);
            }
            this.isStored = true;
        }
    }

    public synchronized void setIsStored() {
        this.isStored = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Collection consumers) throws BrokerException {
        block14: {
            if (this.destroyed || this.pktPtr == null) {
                return;
            }
            if (this.isStoredWithInterest) {
                return;
            }
            boolean botherToStore = !this.neverStore && this.persist;
            ReturnInfo info = PacketReference.calculateConsumerInfo(consumers, botherToStore);
            if (this.ackInfo != null) {
                this.ackInfo.putAll(info.ackInfo);
            } else {
                this.ackInfo = info.ackInfo;
            }
            this.interestCnt = info.ackInfo.size();
            if (!botherToStore) {
                return;
            }
            if (info.uids == null || info.uids.length == 0) {
                this.neverStore = true;
                return;
            }
            try {
                if (this.isStored && !this.neverStore && this.persist) {
                    this.pstore.storeInterestStates(this.destination, this.msgid, info.uids, info.states, Destination.PERSIST_SYNC, this.getPacket());
                    break block14;
                }
                this.pstore.storeMessage(this.destination, (Packet)this.pktPtr, info.uids, info.states, Destination.PERSIST_SYNC);
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    this.makePacketSoftRef();
                }
            }
            catch (IOException ex) {
                throw new BrokerException(ex.toString(), ex);
            }
            catch (Exception ex) {
                Globals.getLogger().logStack(32, "B2011", this.msgid.toString(), (Throwable)ex);
                throw new BrokerException(ex.toString(), ex);
            }
        }
        this.isStored = true;
        this.isStoredWithInterest = true;
        assert (this.interestCnt != 0);
    }

    public ConsumerUID[] getRoutingForStore(Collection consumers) throws BrokerException {
        boolean botherToStore;
        if (this.destroyed || this.pktPtr == null) {
            return null;
        }
        boolean bl = botherToStore = !this.neverStore && this.persist;
        if (!botherToStore) {
            return null;
        }
        if (consumers.isEmpty()) {
            return null;
        }
        ArrayList<ConsumerUID> storedConsumers = null;
        for (Object o : consumers) {
            ConsumerUID cuid = null;
            cuid = o instanceof Consumer ? ((Consumer)o).getStoredConsumerUID() : (ConsumerUID)o;
            if (!cuid.shouldStore()) continue;
            if (storedConsumers == null) {
                storedConsumers = new ArrayList<ConsumerUID>();
            }
            storedConsumers.add(cuid);
        }
        if (storedConsumers == null) {
            return null;
        }
        return storedConsumers.toArray(new ConsumerUID[storedConsumers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRemoteInterests(Collection<Consumer> interests, Map<ConsumerUID, Integer> deliveryCnts) throws BrokerException {
        if (DEBUG) {
            Globals.getLogger().log(8, "storeRemoteInterests(" + interests + ", " + deliveryCnts + ") for ref@" + this.hashCode() + "=" + this + "[" + this.getDestination() + "]");
        }
        try {
            this.store(interests);
        }
        finally {
            Consumer interest2 = null;
            ConsumerUID suid = null;
            ConsumerUID uid = null;
            for (Consumer interest2 : interests) {
                suid = interest2.getStoredConsumerUID();
                uid = interest2.getConsumerUID();
                this.addRemoteConsumerUID(suid, uid, uid.getConnectionUID());
                Integer dct = deliveryCnts.get(uid);
                if (dct == null || dct <= 0) continue;
                this.updateForJMSXDeliveryCount(suid, dct, true);
            }
        }
    }

    public synchronized void addRemoteInterests(Collection<Consumer> interests) {
        Consumer interest2 = null;
        ConsumerUID suid = null;
        ConsumerUID uid = null;
        for (Consumer interest2 : interests) {
            ConsumerMessagePair oldcmp;
            suid = interest2.getStoredConsumerUID();
            uid = interest2.getConsumerUID();
            if (this.ackInfo == null) {
                this.ackInfo = Collections.synchronizedMap(new HashMap());
            }
            if ((oldcmp = (ConsumerMessagePair)this.ackInfo.get(suid)) == null || oldcmp.getState() >= 4) {
                ++this.interestCnt;
            } else {
                this.overriding();
            }
            ConsumerMessagePair newcmp = new ConsumerMessagePair(suid, false);
            newcmp.setState(1);
            this.ackInfo.put(suid, newcmp);
            this.addRemoteConsumerUID(suid, uid, uid.getConnectionUID());
        }
    }

    public void update(ConsumerUID[] uids, int[] states) {
        this.update(uids, states, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ConsumerUID[] uids, int[] states, boolean store) {
        assert (this.isStored);
        assert (uids != null);
        assert (states != null);
        assert (uids.length == states.length);
        assert (this.ackInfo == null);
        assert (uids.length != 0);
        PacketReference packetReference = this;
        synchronized (packetReference) {
            this.interestCnt += uids.length;
        }
        for (int i = 0; i < uids.length; ++i) {
            ConsumerUID cuid = uids[i];
            assert (uids[i] != null);
            assert (states[i] >= 0 && states[i] <= 2);
            if (states[i] == 2) continue;
            if (this.ackInfo == null) {
                this.ackInfo = Collections.synchronizedMap(new HashMap());
            }
            ConsumerMessagePair cmp = new ConsumerMessagePair(cuid, true);
            this.ackInfo.put(cuid, cmp);
            cmp.setState(states[i] == 0 ? 1 : 3);
            if (!store) continue;
            try {
                this.pstore.storeInterestStates(this.destination, this.msgid, uids, states, Destination.PERSIST_SYNC, (Packet)this.pktPtr);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        assert (this.interestCnt != 0);
    }

    public void debug(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Globals.getLogger().log(8, prefix + "Message " + this.msgid);
        Globals.getLogger().log(8, prefix + "size " + this.ackInfo.size());
        for (ConsumerMessagePair ae : this.ackInfo.values()) {
            Globals.getLogger().log(8, prefix + "\t " + ae);
        }
    }

    public void routed(ConsumerUID intid) throws BrokerException, IOException {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "route on destroyed ref " + this.msgid + ":" + intid);
            return;
        }
    }

    public int getCompleteCnt() {
        return this.ackCnt + this.deadCnt;
    }

    public synchronized boolean isAcknowledged() {
        return this.ackCnt + this.deadCnt >= this.interestCnt;
    }

    public int getDeliverCnt() {
        return this.deliveredCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysMessageID replacePacket(Hashtable props, byte[] bytes) throws BrokerException, IOException {
        if (this.deliveredCnt > 0) {
            throw new BrokerException("Unable to replace already delivered message");
        }
        if (this.ackCnt > 0) {
            throw new BrokerException("Unable to replace partially acknowledged message");
        }
        Packet oldp = this.getPacket();
        Packet newp = new Packet();
        newp.fill(oldp);
        newp.updateSequenceNumber();
        newp.updateTimestamp();
        newp.setMessageBody(bytes);
        this.headers = null;
        Hashtable<String, String> oldprops = null;
        try {
            oldprops = this.getProperties();
            if (oldprops == null) {
                oldprops = new Hashtable<String, String>();
            }
            if (props != null) {
                Globals.getLogger().log(4, "Warning although properties have been changed on the message it will not be rerouted");
                oldprops.putAll(props);
            }
            oldprops.put("JMSOrigMessageID", (PREPEND_ID ? "ID:" : "") + this.msgid.toString());
            HashMap headers = this.getHeaders();
            if (headers != null) {
                Hashtable ht = new Hashtable();
                Iterator itr = headers.entrySet().iterator();
                Map.Entry me = null;
                while (itr.hasNext()) {
                    me = itr.next();
                    String key = (String)me.getKey();
                    Object value = me.getValue();
                    if (value == null) continue;
                    ht.put(key, value);
                }
            }
            newp.setProperties(oldprops);
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B4442", this, ex.getMessage()), ex);
        }
        this.setPacketObject(true, newp);
        if (this.isStoredWithInterest) {
            int cnt = 0;
            ConsumerUID[] uids = null;
            int[] states = null;
            if (this.ackInfo != null) {
                Map map = this.ackInfo;
                synchronized (map) {
                    for (ConsumerMessagePair ae : this.ackInfo.values()) {
                        if (!ae.stored) continue;
                        ++cnt;
                    }
                    uids = new ConsumerUID[cnt];
                    states = new int[cnt];
                    int i = 0;
                    for (ConsumerMessagePair ae : this.ackInfo.values()) {
                        if (ae.stored) {
                            uids[i] = ae.uid;
                            states[i] = ae.state;
                        }
                        ++i;
                    }
                }
                this.pstore.storeMessage(this.destination, newp, uids, states, Destination.PERSIST_SYNC);
            } else {
                this.pstore.storeMessage(this.destination, newp, Destination.PERSIST_SYNC);
            }
        } else if (this.isStored) {
            this.pstore.storeMessage(this.destination, newp, Destination.PERSIST_SYNC);
        }
        this.setPacketObject(this.persist, newp);
        this.headers = null;
        props = null;
        SysMessageID id = this.msgid;
        this.msgid = (SysMessageID)newp.getSysMessageID().clone();
        if (this.isStored || this.isStoredWithInterest) {
            Globals.getLogger().log(4, "Cleaning up the old replaced message");
            this.pstore.removeMessage(this.destination, id, Destination.PERSIST_SYNC);
        }
        return this.msgid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delivered(ConsumerUID intid, ConsumerUID storedid, boolean sync, boolean store) throws BrokerException, IOException {
        PacketReference packetReference;
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "delivered on destroyed ref " + this.msgid + ":" + storedid);
            return true;
        }
        if (intid.isNoAck()) {
            return this.acknowledged(intid, storedid, sync, store);
        }
        ConsumerMessagePair cmp = this.getAck(storedid);
        if (cmp == null) {
            Globals.getLogger().log(4, "Received Unknown delivered:\n\tStoreUID: " + storedid + "\n\tConsumerUID: " + intid + "\n\tConsumer: " + Consumer.getConsumer(intid));
            this.debug("\t- ");
            return false;
        }
        if (cmp.compareStateLT(2)) {
            packetReference = this;
            synchronized (packetReference) {
                ++this.deliveredCnt;
            }
        }
        cmp.setStateIfLess(2, 2);
        if (cmp.isStored() && store) {
            this.pstore.updateInterestState(this.destination, this.msgid, storedid, 1, Destination.PERSIST_SYNC && sync, null, false);
        }
        packetReference = this;
        synchronized (packetReference) {
            if (this.deliveredCnt >= this.interestCnt && this.isStored && (MemoryGlobals.getMEM_FREE_P_ACKED() && this.persist || MemoryGlobals.getMEM_FREE_NP_ACKED() && !this.persist)) {
                this.unload();
            }
        }
        return false;
    }

    public int getRedeliverCount(ConsumerUID intid) {
        try {
            ConsumerMessagePair cmp = this.getAck(intid);
            return cmp == null ? 0 : cmp.getRedeliverCount();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void consumed(ConsumerUID intid, boolean sync, boolean delivered) throws BrokerException, IOException {
        if (DEBUG) {
            Globals.getLogger().log(8, "PacketReference.consumed(" + intid + ", " + sync + ", " + delivered + ") for ref@" + this.hashCode() + "=" + this + "[" + this.getDestination() + "]");
        }
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "consumed on destroyed ref " + this.msgid + ":" + intid);
            return;
        }
        if (delivered && this.delivered(intid, intid, sync, true)) {
            this.clearDestroyRemoteReadLock();
        }
        assert (this.ackInfo != null);
        ConsumerMessagePair cmp = this.getAck(intid);
        if (cmp == null) {
            Globals.getLogger().log(32, "Internal Error: unknown interest for  consumed on " + this.msgid + intid + ", " + this.getDestination() + ", ackInfo=" + this.ackInfo);
            return;
        }
        cmp.incrementRedeliver();
        cmp.setStateIfLess(3, 3);
    }

    public void updateForJMSXDeliveryCount(ConsumerUID suid, int n, boolean set) {
        if (DEBUG) {
            Globals.getLogger().log(8, "PacketReference.updateForJMSXDeliveryCount(" + suid + ", " + n + ", " + set + ") for ref@" + this.hashCode() + "=" + this + "[" + this.getDestination() + "]");
        }
        if (this.destroyed || this.invalid) {
            if (DEBUG) {
                Globals.getLogger().log(8, "updateForJMSXDeliveryCount(" + suid + ", " + n + ", " + set + ") on destroyed ref@" + this.hashCode() + "=" + this + "[" + this.destination + "]");
            }
            return;
        }
        ConsumerMessagePair cmp = this.getAck(suid);
        if (cmp == null) {
            if (DEBUG) {
                Globals.getLogger().log(8, "updateForJMSXDeliveryCount(" + suid + ", " + n + "," + set + "): unknown interest for ref@" + this.hashCode() + "=" + this + "[" + this.destination + "]ackInfo=" + this.ackInfo);
            }
            return;
        }
        if (cmp.setStateIfLess(2, 2) && cmp.isStored() && this.destination != null) {
            if (DEBUG) {
                Globals.getLogger().log(8, "updateForJMSXDeliveryCount(" + suid + ", " + n + ", " + set + ") for ref@" + this.hashCode() + "=" + this + "[" + this.destination + "]: update delivered in store");
            }
            try {
                if (Destination.PERSIST_SYNC) {
                    // empty if block
                }
                this.pstore.updateInterestState(this.destination, this.msgid, suid, 1, false, null, false);
            }
            catch (Exception e) {
                Object[] args = new Object[]{String.valueOf(n), suid, this.msgid + "[" + this.destination + "]"};
                Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B4433", args), e);
            }
        }
        if (set) {
            cmp.setRedeliver(n);
        } else {
            cmp.incrementRedeliver(n);
        }
        cmp.setStateIfLess(3, 3);
    }

    public boolean matches(ConsumerUID id) {
        return this.getAck(id) != null;
    }

    public boolean isAcknowledged(ConsumerUID id) {
        ConsumerMessagePair cmp = this.getAck(id);
        if (cmp == null) {
            return true;
        }
        return cmp.compareState(4);
    }

    public boolean isDelivered(ConsumerUID id) {
        ConsumerMessagePair cmp = this.getAck(id);
        if (cmp == null) {
            return true;
        }
        return cmp.compareState(2) || cmp.compareState(3);
    }

    public boolean removeDelivered(ConsumerUID storedid, boolean decrementCounter) {
        if (this.destroyed || this.invalid) {
            return true;
        }
        ConsumerMessagePair cmp = this.getAck(storedid);
        if (cmp == null) {
            Globals.getLogger().log(32, "Internal Error: unknown interest for  remove consumed on " + this.msgid + storedid);
            return false;
        }
        if (decrementCounter) {
            cmp.decrementRedeliver();
        }
        cmp.compareAndSetState(1, 2);
        return cmp.getRedeliverCount() >= 20;
    }

    public boolean hasConsumerAcked(ConsumerUID storedid) {
        try {
            if (this.destroyed || this.invalid) {
                return true;
            }
            ConsumerMessagePair cmp = this.getAck(storedid);
            if (cmp != null && cmp.getState() != 4) {
                return false;
            }
        }
        catch (Throwable ex) {
            Globals.getLogger().logStack(32, "Internal Error checking ack on " + this.msgid + " for " + storedid, ex);
            return false;
        }
        return true;
    }

    public boolean acknowledged(ConsumerUID intid, ConsumerUID storedid, boolean sync, boolean notIgnored) throws BrokerException, IOException {
        return this.acknowledged(intid, storedid, sync, notIgnored, null, null, null, true);
    }

    public boolean acknowledged(ConsumerUID intid, ConsumerUID storedid, boolean sync, boolean notIgnored, boolean ackack) throws BrokerException, IOException {
        return this.acknowledged(intid, storedid, sync, notIgnored, null, null, null, ackack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledged(ConsumerUID intid, ConsumerUID storedid, boolean sync, boolean notIgnored, TransactionUID tuid, TransactionList translist, HashMap<TransactionBroker, Object> remoteNotified, boolean ackack) throws BrokerException, IOException {
        Long txn = tuid == null ? null : Long.valueOf(tuid.longValue());
        try {
            block66: {
                if (this.destroyed || this.invalid) {
                    return true;
                }
                this.removeInDelivery(storedid);
                ConsumerMessagePair cmp = this.getAck(storedid);
                if (cmp == null) {
                    Globals.getLogger().log(32, "Internal Error: Received Unknown ack " + intid + " for message " + this.getSysMessageID());
                    Globals.getLogger().log(32, "AckInfo" + this.ackInfo.toString());
                    boolean rm = false;
                    PacketReference packetReference = this;
                    synchronized (packetReference) {
                        rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                    }
                    if (!this.isLocal() && rm) {
                        this.acquireDestroyRemoteReadLock();
                        packetReference = this;
                        synchronized (packetReference) {
                            rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                        }
                        if (!rm) {
                            this.clearDestroyRemoteReadLock();
                        }
                    }
                    return rm;
                }
                if (cmp.setState(4)) {
                    if (cmp.isStored()) {
                        boolean acked = false;
                        if (Globals.getStore().isJDBCStore()) {
                            acked = this.pstore.hasMessageBeenAcked(this.destination, this.msgid);
                        }
                        if (!acked) {
                            try {
                                boolean isLastAck = false;
                                PacketReference packetReference = this;
                                synchronized (packetReference) {
                                    isLastAck = this.ackCnt + 1 + this.deadCnt >= this.interestCnt;
                                }
                                this.pstore.updateInterestState(this.destination, this.msgid, storedid, 2, Destination.PERSIST_SYNC && sync, tuid, isLastAck);
                            }
                            catch (Exception ex) {
                                if (ex instanceof BrokerException && ((BrokerException)ex).getStatusCode() != 405 && ((BrokerException)ex).getStatusCode() != 404) {
                                    Globals.getLogger().log(16, "Update consumer " + storedid + " state failed for message " + this.msgid + ": " + ex.getMessage());
                                    throw ex;
                                }
                                Globals.getLogger().log(1, "Update consumer " + storedid + " state failed for message " + this.msgid + ": " + ex.getMessage());
                            }
                        }
                    }
                    if (!this.isLocal()) {
                        if (notIgnored) {
                            if (Globals.getClusterBroadcast().getClusterVersion() < 410) {
                                Globals.getClusterBroadcast().acknowledgeMessage(this.getBrokerAddress(), this.getSysMessageID(), intid, 1, null, false);
                            } else if (txn == null) {
                                Globals.getClusterBroadcast().acknowledgeMessage(this.getBrokerAddress(), this.getSysMessageID(), intid, 1, null, sync && ackack);
                            } else {
                                BrokerAddress raddr = this.getBrokerAddress();
                                TransactionBroker traddr = new TransactionBroker(raddr);
                                if (remoteNotified.get(traddr) == null) {
                                    SysMessageID[] mysysids = new SysMessageID[]{this.getSysMessageID()};
                                    ConsumerUID[] myintids = new ConsumerUID[]{intid};
                                    try {
                                        UID txnss = translist.getPartitionedStore().getPartitionID();
                                        Globals.getClusterBroadcast().acknowledgeMessage2P(raddr, mysysids, myintids, 1, null, txn, txnss, true, !this.commit2pwait);
                                        remoteNotified.put(traddr, String.valueOf(""));
                                        if (this.commit2pwait) {
                                            translist.completeClusterTransactionBrokerState(tuid, 6, raddr, true);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (e instanceof BrokerDownException) {
                                            remoteNotified.put(traddr, String.valueOf(""));
                                        }
                                        if (DEBUG_CLUSTER_TXN) {
                                            Globals.getLogger().logStack(16, "Notify commit transaction [" + this.getSysMessageID() + ", " + intid + "]TUID=" + txn + " got response: " + e.toString(), e);
                                            break block66;
                                        }
                                        Globals.getLogger().log(16, "Notify commit transaction [" + this.getSysMessageID() + ", " + intid + "]TUID=" + txn + " got response: " + e.toString(), e);
                                    }
                                }
                            }
                        } else {
                            try {
                                Globals.getClusterBroadcast().acknowledgeMessage(this.getBrokerAddress(), this.getSysMessageID(), intid, 5, null, false);
                            }
                            catch (BrokerException e) {
                                Globals.getLogger().log(4, e.getMessage());
                            }
                        }
                    }
                } else {
                    Consumer c = Consumer.getConsumer(intid);
                    if (c == null || !c.isValid() || !this.isLocal()) {
                        boolean rm = false;
                        PacketReference mysysids = this;
                        synchronized (mysysids) {
                            rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                        }
                        if (!this.isLocal() && rm) {
                            this.acquireDestroyRemoteReadLock();
                            mysysids = this;
                            synchronized (mysysids) {
                                rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                            }
                            if (!rm) {
                                this.clearDestroyRemoteReadLock();
                            }
                        }
                        return rm;
                    }
                    Exception e = new Exception("double ack " + cmp);
                    e.fillInStackTrace();
                    Globals.getLogger().logStack(32, "Received ack twice  on " + this.msgid + " for " + intid + " state is = " + cmp, e);
                    boolean rm = false;
                    PacketReference packetReference = this;
                    synchronized (packetReference) {
                        rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                    }
                    if (!this.isLocal() && rm) {
                        this.acquireDestroyRemoteReadLock();
                        packetReference = this;
                        synchronized (packetReference) {
                            rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                        }
                        if (!rm) {
                            this.clearDestroyRemoteReadLock();
                        }
                    }
                    return rm;
                }
            }
            boolean rm = false;
            PacketReference packetReference = this;
            synchronized (packetReference) {
                ++this.ackCnt;
                rm = this.ackCnt + this.deadCnt >= this.interestCnt;
            }
            if (!this.isLocal() && rm) {
                this.acquireDestroyRemoteReadLock();
                packetReference = this;
                synchronized (packetReference) {
                    rm = this.ackCnt + this.deadCnt >= this.interestCnt;
                }
                if (!rm) {
                    this.clearDestroyRemoteReadLock();
                }
            }
            return rm;
        }
        catch (Throwable thr) {
            if (thr instanceof BrokerDownException) {
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2224", "[" + this.msgid + "]" + intid + ":" + storedid, thr.getMessage()));
            } else {
                Globals.getLogger().logStack(32, "Error in processing ack on " + this.msgid + " for " + intid, thr);
            }
            if (thr instanceof BrokerException) {
                throw (BrokerException)thr;
            }
            throw new BrokerException("Unable to process ack", thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acknowledgedOnReplay(ConsumerUID intid, ConsumerUID storedid) throws BrokerException, IOException {
        try {
            if (this.destroyed || this.invalid) {
                return true;
            }
            ConsumerMessagePair cmp = this.getAck(storedid);
            if (cmp == null) {
                Globals.getLogger().log(32, "Internal Error: Received Unknown ack " + intid + " for message " + this.getSysMessageID());
                Globals.getLogger().log(32, "AckInfo" + this.ackInfo.toString());
                PacketReference packetReference = this;
                synchronized (packetReference) {
                    return this.ackCnt + this.deadCnt >= this.interestCnt;
                }
            }
            cmp.setState(4);
            ++this.ackCnt;
            return this.ackCnt + this.deadCnt >= this.interestCnt;
        }
        catch (Throwable thr) {
            Globals.getLogger().logStack(32, "Error in processing ack on " + this.msgid + " for " + intid, thr);
            if (thr instanceof BrokerException) {
                throw (BrokerException)thr;
            }
            throw new BrokerException("Unable to process ack", thr);
        }
    }

    public void overrideRedeliver() {
        if (!this.overrideRedeliver) {
            this.overrideRedeliver = true;
        }
    }

    public boolean getRedeliverFlag(ConsumerUID intid) {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "redeliver for destroyed " + this.msgid + ":" + intid);
            return true;
        }
        ConsumerMessagePair cmp = this.getAck(intid);
        if (cmp == null) {
            return false;
        }
        if (this.overrideRedeliver) {
            return true;
        }
        return !cmp.compareStateLT(2);
    }

    public boolean getConsumed(ConsumerUID intid) {
        if (this.destroyed || this.invalid) {
            Globals.getLogger().log(4, "getConsumed for destroyed " + this.msgid + ":" + intid);
            return true;
        }
        ConsumerMessagePair cmp = this.getAck(intid);
        if (cmp == null) {
            Globals.getLogger().log(32, "Internal Error: unknown interest for  getConsumed on " + this.msgid + intid);
            return true;
        }
        return cmp.compareState(3);
    }

    public synchronized void clear() {
        this.props = null;
        if (this.pktPtr instanceof Reference) {
            ((Reference)this.pktPtr).clear();
            ((Reference)this.pktPtr).enqueue();
        }
        this.pktPtr = null;
        this.msgid = null;
    }

    public boolean remove(boolean onRollback) {
        boolean ret = true;
        if (this.isStored && !this.neverStore && this.persist) {
            try {
                if (PacketReference.FI.FAULT_INJECTION) {
                    if (FI.checkFault("msg.destroy.1_5.exception", null)) {
                        FI.unsetFault("msg.destroy.1_5.exception");
                        throw new BrokerException("FAULT_INJECTION: msg.destroy.1_5.exception");
                    }
                    FI.checkFaultAndExit("msg.destroy.1_5.kill", null, 1, false);
                }
                this.pstore.removeMessage(this.destination, this.msgid, false, onRollback);
                this.isStored = false;
            }
            catch (Exception ex) {
                ret = false;
                Object[] args = new Object[]{this.msgid.toString(), this.getDestinationUID(), "" + this.pstore};
                Globals.getLogger().logStack(32, Globals.getBrokerResources().getKString("B3145", args), ex);
            }
            this.isStored = false;
        }
        return ret;
    }

    public final void postAcknowledgedRemoval() {
        if (this.isLocal()) {
            return;
        }
        this.clearDestroyRemoteReadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDestroyRemoteReadLock() {
        Thread myth = Thread.currentThread();
        long totalwaited = 0L;
        long pretime = 0L;
        long curtime = 0L;
        long waitime = 15000L;
        Object object = this.destroyRemoteLock;
        synchronized (object) {
            while (this.destroyRemoteWriteLockThread != null && myth != this.destroyRemoteWriteLockThread) {
                curtime = System.currentTimeMillis();
                totalwaited += pretime == 0L ? 0L : curtime - pretime;
                if (pretime != 0L) {
                    waitime = 30000L;
                    Object[] args = new String[]{this.toString(), "" + this.getDestinationUID(), "[" + this.destroyRemoteWriteLockThread + "](" + String.valueOf(totalwaited) + ")"};
                    Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1468", args));
                }
                pretime = System.currentTimeMillis();
                try {
                    this.destroyRemoteLock.wait(waitime);
                }
                catch (Exception e) {}
            }
            this.destroyRemoteReadLocks.add(myth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDestroyRemoteReadLock() {
        Thread myth = Thread.currentThread();
        Object object = this.destroyRemoteLock;
        synchronized (object) {
            this.destroyRemoteReadLocks.remove(myth);
            this.destroyRemoteLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireDestroyRemoteWriteLock() {
        long totalwaited = 0L;
        long pretime = 0L;
        long curtime = 0L;
        long waitime = 15000L;
        Object object = this.destroyRemoteLock;
        synchronized (object) {
            while (!this.destroyRemoteReadLocks.isEmpty() || this.destroyRemoteWriteLockThread != null) {
                curtime = System.currentTimeMillis();
                totalwaited += pretime == 0L ? 0L : curtime - pretime;
                if (pretime != 0L) {
                    waitime = 30000L;
                    Object[] args = new String[]{this.toString(), "" + this.getDestinationUID(), "[" + this.destroyRemoteReadLocks + ", [" + this.destroyRemoteWriteLockThread + "]](" + String.valueOf(totalwaited) + ")"};
                    Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1467", args));
                }
                pretime = System.currentTimeMillis();
                try {
                    this.destroyRemoteLock.wait(waitime);
                }
                catch (Exception e) {}
            }
            this.destroyRemoteWriteLockThread = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDestroyRemoteWriteLock() {
        Thread th = Thread.currentThread();
        Object object = this.destroyRemoteLock;
        synchronized (object) {
            if (this.destroyRemoteWriteLockThread == th) {
                this.destroyRemoteWriteLockThread = null;
            }
            if (this.destroyRemoteWriteLockThread == null) {
                this.destroyRemoteLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        assert (!this.getLBitSet());
        boolean alreadydestroyed = false;
        Object object = this;
        synchronized (object) {
            if (this.destroyed) {
                alreadydestroyed = true;
            }
            this.destroyed = true;
        }
        object = this.destroyRemoteLock;
        synchronized (object) {
            this.destroyRemoteReadLocks.clear();
            this.destroyRemoteWriteLockThread = null;
            this.destroyRemoteLock.notifyAll();
        }
        if (alreadydestroyed) {
            return;
        }
        if (this.deliveryTimeInfo != null) {
            this.deliveryTimeInfo.cancelTimer();
        }
        if (this.isStored) {
            try {
                if (Globals.isNewTxnLogEnabled()) {
                    if (!this.neverStore) {
                        this.pstore.removeMessage(this.destination, this.msgid, false);
                    } else if (Store.getDEBUG()) {
                        Globals.getLogger().log(4, "NOT removing msg marked as neverstore");
                    }
                } else {
                    this.pstore.removeMessage(this.destination, this.msgid, false);
                }
                this.isStored = false;
            }
            catch (Exception ex) {
                Object[] args = new Object[]{this.msgid.toString(), this.getDestinationUID(), "" + this.pstore};
                Globals.getLogger().logStack(32, Globals.getBrokerResources().getKString("B3145", args), ex);
            }
        }
        this.props = null;
        if (this.pktPtr instanceof Reference) {
            ((Reference)this.pktPtr).clear();
            ((Reference)this.pktPtr).enqueue();
        }
        this.pktPtr = null;
    }

    void unload() {
        if (this.pktPtr instanceof SoftReference) {
            ((SoftReference)this.pktPtr).clear();
        }
    }

    public String getDeadComment() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair cmp = this.getAck(this.lastDead);
        return cmp == null ? null : cmp.getDeadComment();
    }

    public int getDeadDeliverCnt() {
        if (this.lastDead == null) {
            return this.getDeliverCnt();
        }
        ConsumerMessagePair cmp = this.getAck(this.lastDead);
        return cmp == null ? this.getDeliverCnt() : cmp.getRedeliverCount();
    }

    public Reason getDeadReason() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair cmp = this.getAck(this.lastDead);
        return cmp == null ? null : cmp.getDeadReason();
    }

    public String getDeadBroker() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair cmp = this.getAck(this.lastDead);
        return cmp == null ? null : cmp.getDeadBroker();
    }

    public Throwable getDeadException() {
        if (this.lastDead == null) {
            return null;
        }
        ConsumerMessagePair cmp = this.getAck(this.lastDead);
        return cmp == null ? null : cmp.getDeadException();
    }

    public boolean markDead(ConsumerUID intid, ConsumerUID storedid, String comment, Throwable ex, Reason reason, int redeliverCnt, String broker) throws BrokerException {
        return this.markDead(intid, storedid, comment, ex, reason, redeliverCnt, broker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markDead(ConsumerUID intid, ConsumerUID storedid, String comment, Throwable ex, Reason reason, int redeliverCnt, String broker, boolean remoteDeliveredAck) throws BrokerException {
        this.removeInDelivery(storedid);
        ConsumerMessagePair cmp = this.getAck(storedid);
        if (cmp == null) {
            Globals.getLogger().log(4, "Received unknown dead message " + storedid);
            return false;
        }
        if (!this.isLocal()) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            if (comment != null) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", comment);
            }
            if (redeliverCnt != -1) {
                props.put("JMQ_SUN_JMSQ_TempRedeliverCnt", redeliverCnt);
            }
            if (ex != null) {
                props.put("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION", ex);
            }
            if (reason != null) {
                props.put("REASON", reason.intValue());
            }
            if (broker != null) {
                props.put("JMS_SUN_DMQ_DEAD_BROKER", broker);
            }
            if (remoteDeliveredAck) {
                props.put("MSG_DELIVERED_ACK", Boolean.TRUE);
            }
            Globals.getClusterBroadcast().acknowledgeMessage(this.getBrokerAddress(), this.getSysMessageID(), intid, 7, props, !intid.isDupsOK() && !intid.isNoAck());
            cmp.setState(4);
        } else {
            this.lastDead = storedid;
            cmp.setState(5);
            cmp.setDeadComment(comment);
            cmp.setDeadReason(reason);
            cmp.setDeadException(ex);
            cmp.setDeadBroker(broker);
            if (redeliverCnt > -1) {
                cmp.setRedeliverCount(redeliverCnt);
            }
        }
        boolean rm = false;
        PacketReference packetReference = this;
        synchronized (packetReference) {
            ++this.deadCnt;
            rm = this.ackCnt + this.deadCnt >= this.interestCnt;
        }
        if (!this.isLocal() && rm) {
            this.acquireDestroyRemoteReadLock();
            packetReference = this;
            synchronized (packetReference) {
                rm = this.ackCnt + this.deadCnt >= this.interestCnt;
            }
            if (!rm) {
                this.clearDestroyRemoteReadLock();
            }
        }
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDead() {
        boolean rm = false;
        PacketReference packetReference = this;
        synchronized (packetReference) {
            rm = this.deadCnt > 0 && this.ackCnt + this.deadCnt >= this.interestCnt;
        }
        if (!this.isLocal() && rm) {
            this.acquireDestroyRemoteReadLock();
            packetReference = this;
            synchronized (packetReference) {
                rm = this.deadCnt > 0 && this.ackCnt + this.deadCnt >= this.interestCnt;
            }
            if (!rm) {
                this.clearDestroyRemoteReadLock();
            }
        }
        return rm;
    }

    public static void replaceTest() {
        try {
            Globals.getDestinationList();
            PartitionedStore ps = DestinationList.assignStorePartition(0, new ConnectionUID(), null);
            DestinationUID duid = new DestinationUID("test", true);
            DestinationUID duid_t = new DestinationUID("test", false);
            ConsumerUID uid1 = new ConsumerUID(1);
            ConsumerUID uid2 = new ConsumerUID(2);
            Consumer consumer1 = new Consumer(duid, null, false, queueUID);
            ArrayList<Consumer> queues = new ArrayList<Consumer>();
            queues.add(consumer1);
            Consumer tconsumer1 = new Consumer(duid_t, null, false, uid1);
            Consumer tconsumer2 = new Consumer(duid_t, null, false, uid2);
            ArrayList<Consumer> topics = new ArrayList<Consumer>();
            topics.add(tconsumer1);
            topics.add(tconsumer2);
            try {
                Globals.getDestinationList();
                DestinationList.createDestination(ps, "test", 1);
                Globals.getDestinationList();
                DestinationList.createDestination(ps, "test", 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Packet p1 = new Packet();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("MyName", "MyValue");
            byte[] body1 = new byte[]{1};
            p1.setProperties(props);
            p1.setMessageBody(body1);
            p1.updateTimestamp();
            p1.updateSequenceNumber();
            System.out.println("----------------------------------");
            System.out.println("Test1: non-persist No Properties");
            System.out.println("----------------------------------");
            System.out.print("Initial Packet " + p1.getSysMessageID());
            PacketReference ref = PacketReference.createReference(ps, p1, duid, null);
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            ref.store(queues);
            byte[] body2 = new byte[]{2};
            try {
                SysMessageID newid = ref.replacePacket(null, body2);
                System.out.print("New ID " + newid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println("----------------------------------");
            System.out.println("Test2: persist No Properties");
            System.out.println("----------------------------------");
            p1 = new Packet();
            props = new Hashtable();
            props.put("MyName", "MyValue");
            byte[] body3 = new byte[]{3};
            byte[] body4 = new byte[]{4};
            p1.setMessageBody(body3);
            p1.setPersistent(true);
            p1.setProperties(props);
            p1.updateTimestamp();
            p1.updateSequenceNumber();
            System.out.print("Initial Packet " + p1.getSysMessageID());
            ref = PacketReference.createReference(ps, p1, duid, null);
            ref.store(queues);
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                SysMessageID newid = ref.replacePacket(null, body4);
                System.out.print("New ID " + newid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println("----------------------------------");
            System.out.println("Test3: Topic and 2 consumerUID");
            System.out.println("----------------------------------");
            p1 = new Packet();
            props = new Hashtable();
            props.put("MyName", "MyValue");
            byte[] body5 = new byte[]{5};
            byte[] body6 = new byte[]{6};
            p1.setMessageBody(body5);
            p1.setPersistent(true);
            p1.setIsQueue(false);
            p1.setProperties(props);
            p1.updateTimestamp();
            p1.updateSequenceNumber();
            System.out.print("Initial Packet " + p1.getSysMessageID());
            ref = PacketReference.createReference(ps, p1, duid, null);
            ref.store(topics);
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                SysMessageID newid = ref.replacePacket(null, body6);
                System.out.print("New ID " + newid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println("----------------------------------");
            System.out.println("Test4: Updating Properties");
            System.out.println("----------------------------------");
            p1 = new Packet();
            props = new Hashtable();
            props.put("MyName", "MyValue");
            byte[] body7 = new byte[]{7};
            byte[] body8 = new byte[]{8};
            p1.setMessageBody(body7);
            p1.setPersistent(true);
            p1.setIsQueue(false);
            p1.setProperties(props);
            p1.updateTimestamp();
            p1.updateSequenceNumber();
            Hashtable<String, String> newProps = new Hashtable<String, String>();
            newProps.put("MyNewName", "MyNewValue");
            newProps.put("MyName", "***REPLACE***");
            System.out.print("Initial Packet " + p1.getSysMessageID());
            ref = PacketReference.createReference(ps, p1, duid, null);
            System.out.println(ref.getProperties());
            ref.store(topics);
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                SysMessageID newid = ref.replacePacket(newProps, body8);
                System.out.print("New ID " + newid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println(ref.getProperties());
            System.out.println("----------------------------------");
            System.out.println("Test5: Message Delivered");
            System.out.println("----------------------------------");
            p1 = new Packet();
            props = new Hashtable();
            props.put("MyName", "MyValue");
            byte[] body9 = new byte[]{9};
            byte[] body10 = new byte[]{10};
            p1.setMessageBody(body9);
            p1.setPersistent(true);
            p1.setIsQueue(false);
            p1.setProperties(props);
            p1.updateTimestamp();
            p1.updateSequenceNumber();
            newProps = new Hashtable();
            newProps.put("MyNewName", "MyNewValue");
            newProps.put("MyName", "***REPLACE***");
            ref = PacketReference.createReference(ps, p1, duid, null);
            ref.store(topics);
            ref.delivered(uid2, uid2, false, false);
            System.out.print("Initial Packet " + p1.getSysMessageID());
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            try {
                SysMessageID newid = ref.replacePacket(newProps, body10);
                System.out.print("New ID " + newid);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println("\t[Body=" + ref.getPacket().getMessageBodyByteBuffer().get() + "]");
            System.out.println(ref.getProperties());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("RUNNING TEST");
        PacketReference.replaceTest();
    }

    static {
        queueUID = new ConsumerUID(true);
        queueUID.setShouldStore(true);
        DEBUG = false;
        boolean bl = DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }

    static class ReturnInfo {
        ConsumerUID[] uids;
        int[] states;
        int interestCnt;
        Map ackInfo;

        ReturnInfo() {
        }
    }

    static class ConsumerMessagePair {
        private ConsumerUID uid;
        private int state = 0;
        private int redeliverCnt = 0;
        private boolean stored;
        private String deadComment = null;
        private Reason deadReason = null;
        private Throwable deadException = null;
        private long timestamp = 0L;
        private String deadBroker = null;

        public ConsumerMessagePair(ConsumerUID uid, boolean stored) {
            this.uid = uid;
            this.stored = stored;
        }

        public synchronized int setRedeliver(int n) {
            this.redeliverCnt = n;
            return this.redeliverCnt;
        }

        public synchronized int incrementRedeliver() {
            ++this.redeliverCnt;
            return this.redeliverCnt;
        }

        public synchronized int incrementRedeliver(int n) {
            this.redeliverCnt += n;
            return this.redeliverCnt;
        }

        public synchronized int decrementRedeliver() {
            --this.redeliverCnt;
            return this.redeliverCnt;
        }

        public synchronized boolean setState(int state) {
            if (this.state == state) {
                return false;
            }
            this.state = state;
            this.timestamp = System.currentTimeMillis();
            return true;
        }

        public synchronized int getState() {
            return this.state;
        }

        public synchronized boolean compareAndSetState(int state, int expected) {
            if (this.state != expected) {
                return false;
            }
            this.timestamp = System.currentTimeMillis();
            this.state = state;
            return true;
        }

        public synchronized boolean compareState(int expected) {
            return this.state == expected;
        }

        public synchronized boolean compareStateGT(int expected) {
            return this.state > expected;
        }

        public synchronized boolean compareStateLT(int expected) {
            return this.state < expected;
        }

        public synchronized boolean setStateIfLess(int state, int max) {
            if (this.compareStateLT(max)) {
                return this.setState(state);
            }
            return false;
        }

        public boolean isStored() {
            return this.stored;
        }

        public int getRedeliverCount() {
            return this.redeliverCnt;
        }

        public void setRedeliverCount(int cnt) {
            this.redeliverCnt = cnt;
        }

        public void setDeadComment(String str) {
            this.deadComment = str;
        }

        public void setDeadReason(Reason r) {
            this.deadReason = r;
        }

        public String getDeadComment() {
            return this.deadComment;
        }

        public Reason getDeadReason() {
            return this.deadReason;
        }

        public Throwable getDeadException() {
            return this.deadException;
        }

        public void setDeadException(Throwable thr) {
            this.deadException = thr;
        }

        public void setDeadBroker(String bkr) {
            this.deadBroker = bkr;
        }

        public String getDeadBroker() {
            return this.deadBroker;
        }

        public String toString() {
            return ": CMPair[" + this.uid.longValue() + ":" + PacketReference.stateToString(this.state) + ":" + this.stored + "] - " + this.timestamp;
        }
    }
}

