/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;

public class AdminCmdHandler {
    AdminDataHandler parent = null;
    private static boolean DEBUG = false;
    protected DestinationList DL = Globals.getDestinationList();
    protected Logger logger = Globals.getLogger();
    protected BrokerResources rb = Globals.getBrokerResources();

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public AdminCmdHandler() {
    }

    public AdminCmdHandler(AdminDataHandler parent) {
        this.parent = parent;
    }

    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        Integer n = (Integer)cmd_props.get("JMQMessageType");
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        AdminCmdHandler.setProperties(reply, n + 1, 500, "Not Implemented");
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static void setProperties(Packet pkt, int message_type, int status, String error_string) {
        AdminCmdHandler.setProperties(pkt, message_type, status, error_string, null);
    }

    public static void setProperties(Packet pkt, int message_type, int status, String error_string, Hashtable addprops) {
        Hashtable<String, Object> props = null;
        props = addprops != null ? new Hashtable(addprops) : new Hashtable<String, Object>();
        props.put("JMQMessageType", message_type);
        props.put("JMQStatus", status);
        if (error_string != null) {
            props.put("JMQErrorString", error_string);
        }
        pkt.setProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getBodyObject(Packet pkt) {
        FilteringObjectInputStream ois = null;
        Object o = null;
        try {
            ois = new FilteringObjectInputStream(pkt.getMessageBodyStream());
            o = ois.readObject();
        }
        catch (Exception e) {
            this.logger.logStack(32, "B3100", this.getClass().getName() + " : Got exception reading body of administration message:\n" + e + "\n" + pkt.dumpPacketString(), (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            }
        }
        return o;
    }

    protected void setBodyObject(Packet pkt, Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.close();
            pkt.setMessageBody(bos.toByteArray());
        }
        catch (Exception e) {
            this.logger.logStack(32, "B3100", this.getClass().getName() + " : Got exception writing Vector to admin reply message:\n" + e + "\n" + o.toString(), (Throwable)e);
        }
    }

    public static String getMessageFromException(Exception e) {
        String m = e.getMessage();
        if (e instanceof BrokerException) {
            Throwable root_ex = ((BrokerException)e).getCause();
            if (root_ex == null) {
                return m;
            }
            String lm = root_ex.getMessage();
            if (lm != null) {
                m = m + "\n" + lm;
            }
        }
        return m;
    }

    public void waitForHandlersToComplete(int secs) {
        this.parent.waitForHandlersToComplete(secs);
    }

    public String getDestinationType(int mask) {
        if (DestType.isTopic(mask)) {
            return this.rb.getString("B0044");
        }
        if (DestType.isQueue(mask)) {
            return this.rb.getString("B0043");
        }
        return "?????";
    }
}

