/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import java.io.IOException;
import java.util.Iterator;

public class RemDurableHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public RemDurableHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "RemDurableHandler");
        }
        if (pkt.getType() == 7) {
            this.handleRemDurableInterest(cb, sender, pkt);
        } else if (pkt.getType() == 8) {
            this.handleRemDurableInterestAck(sender, pkt);
        } else {
            this.logger.log(16, "RemDurableHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleRemDurableInterest(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterSubscriptionInfo csi = ClusterSubscriptionInfo.newInstance(pkt);
        if (!this.p.getConfigSyncComplete() && !csi.isConfigSyncResponse()) {
            if (DEBUG) {
                this.logger.log(4, "MessageBus: Dropping the G_REM_DURABLE_INTEREST packet from {0}. Not ready yet.", sender);
            }
            return;
        }
        Iterator itr = csi.getSubscriptions();
        try {
            int i = 0;
            ChangeRecordInfo lastcri = null;
            while (itr.hasNext()) {
                ChangeRecordInfo cri;
                ++i;
                Subscription intr = (Subscription)itr.next();
                if (intr != null) {
                    cb.unsubscribe(intr);
                }
                if ((cri = csi.getShareccInfo(i)) == null) continue;
                if (lastcri == null) {
                    lastcri = cri;
                    continue;
                }
                if (cri.getSeq() <= lastcri.getSeq()) continue;
                lastcri = cri;
            }
            if (lastcri != null) {
                cb.setLastReceivedChangeRecord(sender, lastcri);
            }
        }
        catch (Exception e) {
            this.logger.logStack(4, "Exception processing packet ", e);
        }
        if (csi.needReply()) {
            GPacket gp = ClusterSubscriptionInfo.getReplyGPacket((short)8, 200);
            try {
                this.c.unicast(sender, gp);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void handleRemDurableInterestAck(BrokerAddress sender, GPacket pkt) {
        this.logger.log(4, "MessageBus: Received G_REM_DURABLE_INTEREST_REPLY from {0} : STATUS = {1}", (Object)sender, (Integer)pkt.getProp("S"));
    }
}

