/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc.comm;

import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.ConnectionInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SupportUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DBConnectionPool {
    private static boolean DEBUG = false;
    private static final String REAP_INTERVAL_PROP_SUFFIX = ".connection.reaptime";
    private static final int DEFAULT_REAP_INTERVAL = 300;
    private static final int DEFAULT_POLL_TIMEOUT = 180;
    private static final String POLL_TIMEOUT_PROP_SUFFIX = ".connection.pollTimeout";
    private static final String TIMEOUT_IDLE_PROP_SUFFIX = ".connection.timeoutIdle";
    public static final String NUM_CONN_PROP_SUFFIX = ".connection.limit";
    private static final String MIN_CONN_PROP_SUFFIX = ".min_connections";
    private static final String MAX_CONN_PROP_SUFFIX = ".max_connections";
    private static final int DEFAULT_NUM_CONN = 5;
    private static final String VALIDATION_QUERY_PROP_SUFFIX = ".connection.validationQuery";
    public static final String VALIDATE_ON_GET_PROP_SUFFIX = ".connection.validateOnGet";
    public static final String INVALIDATE_ALL_PROP_SUFFIX = ".connection.invalidateAll";
    private int minConnections;
    private int maxConnections;
    private int pollTimeout = 180;
    private boolean initialized = false;
    private ReentrantLock lock = new ReentrantLock();
    private LinkedBlockingQueue<ConnectionInfo> idleConnections = new LinkedBlockingQueue();
    private ConcurrentHashMap<ConnectionInfo, Thread> activeConnections = new ConcurrentHashMap();
    private Map<Object, ConnectionInfo> connMap = Collections.synchronizedMap(new HashMap());
    private ConnectionReaperTask connectionReaper = null;
    private ConnectionEventListener connectionListener = null;
    private long reapInterval = 300000L;
    private CommDBManager dbmgr = null;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private String validationQuery = null;
    private boolean validateOnGet = false;
    private boolean invalidateAll = false;
    private boolean timeoutIdle = true;
    private boolean isPoolDataSource = false;
    private String name = null;
    private boolean dedicated = false;
    private Object invalidateAllTimestampLock = new Object();
    private Long invalidateAllTimestamp = null;
    private ConfigListener cfgListener = new ConfigListener(){

        @Override
        public void validate(String name, String value) throws PropertyUpdateException {
            if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MIN_CONN_PROP_SUFFIX)) {
                int min = 0;
                try {
                    min = Integer.parseInt(value);
                }
                catch (Exception e) {
                    throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", name + "=" + value), e);
                }
                if (min < 1) {
                    throw new PropertyUpdateException(2, "A minimum value of 1 connection is required");
                }
                if (min > DBConnectionPool.this.maxConnections) {
                    throw new PropertyUpdateException(2, "Minimum connections " + min + " is greater than maximum connections " + DBConnectionPool.this.maxConnections);
                }
            } else if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MAX_CONN_PROP_SUFFIX)) {
                int max = 0;
                try {
                    max = Integer.parseInt(value);
                }
                catch (Exception e) {
                    throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", name + "=" + value), e);
                }
                if (max < DBConnectionPool.this.minConnections) {
                    throw new PropertyUpdateException(2, "Maximum connections " + max + " is less than minimum connections " + DBConnectionPool.this.minConnections);
                }
            } else {
                if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.POLL_TIMEOUT_PROP_SUFFIX)) {
                    try {
                        Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", name + "=" + value), e);
                    }
                }
                if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX)) {
                    int reaptime = 0;
                    try {
                        reaptime = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        throw new PropertyUpdateException(2, DBConnectionPool.this.br.getString("B4027", name + "=" + value), e);
                    }
                    if (reaptime < 60) {
                        throw new PropertyUpdateException(2, "A minimum value of 60 seconds is required for reap time interval");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean update(String name, String value) {
            BrokerConfig cfg = Globals.getConfig();
            long newReapInterval = DBConnectionPool.this.reapInterval;
            DBConnectionPool.this.lock.lock();
            try {
                if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MAX_CONN_PROP_SUFFIX)) {
                    DBConnectionPool.this.maxConnections = cfg.getIntProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MAX_CONN_PROP_SUFFIX);
                } else if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MIN_CONN_PROP_SUFFIX)) {
                    DBConnectionPool.this.minConnections = cfg.getIntProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.MIN_CONN_PROP_SUFFIX);
                } else if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.POLL_TIMEOUT_PROP_SUFFIX)) {
                    DBConnectionPool.this.pollTimeout = cfg.getIntProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.POLL_TIMEOUT_PROP_SUFFIX);
                } else if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX)) {
                    newReapInterval = cfg.getLongProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX) * 1000L;
                } else if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.INVALIDATE_ALL_PROP_SUFFIX)) {
                    DBConnectionPool.this.invalidateAll = cfg.getBooleanProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.INVALIDATE_ALL_PROP_SUFFIX);
                    Logger logger = DBConnectionPool.this.logger;
                    DBConnectionPool.this.logger;
                    logger.log(8, DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.INVALIDATE_ALL_PROP_SUFFIX + "=" + DBConnectionPool.this.invalidateAll);
                } else if (name.equals(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.VALIDATE_ON_GET_PROP_SUFFIX)) {
                    DBConnectionPool.this.validateOnGet = cfg.getBooleanProperty(DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.VALIDATE_ON_GET_PROP_SUFFIX);
                    Logger logger = DBConnectionPool.this.logger;
                    DBConnectionPool.this.logger;
                    logger.log(8, DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.VALIDATE_ON_GET_PROP_SUFFIX + "=" + DBConnectionPool.this.validateOnGet);
                }
            }
            finally {
                DBConnectionPool.this.lock.unlock();
            }
            if (newReapInterval != DBConnectionPool.this.reapInterval) {
                DBConnectionPool.this.reapInterval = newReapInterval;
                Logger logger = DBConnectionPool.this.logger;
                DBConnectionPool.this.logger;
                logger.log(8, DBConnectionPool.this.dbmgr.getJDBCPropPrefix() + DBConnectionPool.REAP_INTERVAL_PROP_SUFFIX + "=" + DBConnectionPool.this.reapInterval / 1000L);
                ConnectionReaperTask task = DBConnectionPool.this.connectionReaper;
                if (task != null) {
                    task.cancel();
                }
                DBConnectionPool.this.connectionReaper = new ConnectionReaperTask();
                Globals.getTimer().schedule((TimerTask)DBConnectionPool.this.connectionReaper, DBConnectionPool.this.reapInterval, DBConnectionPool.this.reapInterval);
            }
            return true;
        }
    };

    public DBConnectionPool(CommDBManager mgr, String name) throws BrokerException {
        this(mgr, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConnectionPool(CommDBManager mgr, String name, boolean dedicated) throws BrokerException {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (this.initialized) {
                    return;
                }
                this.dbmgr = mgr;
                this.name = name;
                this.dedicated = dedicated;
                this.isPoolDataSource = this.dbmgr.isPoolDataSource();
                String key = this.dbmgr.getJDBCPropPrefix() + VALIDATION_QUERY_PROP_SUFFIX;
                this.validationQuery = Globals.getConfig().getProperty(key);
                if (this.validationQuery != null && this.validationQuery.trim().length() == 0) {
                    this.validationQuery = null;
                }
                this.initValidationQuery();
                if (this.validationQuery != null) {
                    this.logger.log(8, key + "=" + this.validationQuery);
                }
                key = this.dbmgr.getJDBCPropPrefix() + VALIDATE_ON_GET_PROP_SUFFIX;
                this.validateOnGet = Globals.getConfig().getBooleanProperty(key, Globals.getHAEnabled());
                this.logger.log(8, key + "=" + this.validateOnGet);
                key = this.dbmgr.getJDBCPropPrefix() + INVALIDATE_ALL_PROP_SUFFIX;
                this.invalidateAll = Globals.getConfig().getBooleanProperty(key, Globals.getHAEnabled());
                this.logger.log(8, key + "=" + this.invalidateAll);
                key = this.dbmgr.getJDBCPropPrefix() + TIMEOUT_IDLE_PROP_SUFFIX;
                this.timeoutIdle = Globals.getConfig().getBooleanProperty(key, true);
                this.logger.log(8, key + "=" + this.timeoutIdle);
                if (!dedicated) {
                    key = this.dbmgr.getJDBCPropPrefix() + NUM_CONN_PROP_SUFFIX;
                    int numConnections = Globals.getConfig().getIntProperty(key, 5);
                    if (numConnections < 1) {
                        numConnections = 5;
                        this.logger.log(16, "Invalid number of connections specified, set to default of " + numConnections + this.toString());
                    }
                    key = this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX;
                    this.minConnections = Globals.getConfig().getIntProperty(key, numConnections);
                    if (this.minConnections < 1) {
                        this.minConnections = numConnections;
                        this.logger.log(16, "Invalid number of minimum connections specified, set to default of " + this.minConnections + this.toString());
                    }
                    key = this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX;
                    this.maxConnections = Globals.getConfig().getIntProperty(key, numConnections);
                    if (this.maxConnections < this.minConnections) {
                        this.maxConnections = this.minConnections;
                        this.logger.log(16, "Invalid number of maximum connections specified, set to default of " + this.maxConnections + this.toString());
                    }
                } else {
                    this.minConnections = 1;
                    this.maxConnections = 2;
                }
                key = this.dbmgr.getJDBCPropPrefix() + POLL_TIMEOUT_PROP_SUFFIX;
                this.pollTimeout = Globals.getConfig().getIntProperty(key, 180);
                key = this.dbmgr.getJDBCPropPrefix() + REAP_INTERVAL_PROP_SUFFIX;
                long reapTime = Globals.getConfig().getLongProperty(key, 300L);
                if (reapTime < 60L) {
                    reapTime = 300L;
                    this.logger.log(16, "Invalid reap time interval for pool maintenance thread specified, set to default of " + reapTime + this.toString());
                }
                this.logger.log(8, key + "=" + reapTime);
                this.reapInterval = reapTime * 1000L;
                if (this.dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty(this.dbmgr.getCreateStoreProp(), this.dbmgr.getCreateStorePropDefault())) {
                    try {
                        Connection conn = this.dbmgr.connectToCreate();
                        conn.close();
                    }
                    catch (Exception e) {
                        String url = this.dbmgr.getCreateDBURL();
                        String emsg = this.br.getKString("B3073", url);
                        this.logger.log(32, emsg + this.toString(), e);
                        throw new BrokerException(emsg, e);
                    }
                }
                this.connectionListener = new DBConnectionListener();
                if (!dedicated) {
                    this.logger.log(8, this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX + "=" + this.minConnections);
                    this.logger.log(8, this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX + "=" + this.maxConnections);
                }
                for (int i = 0; i < this.minConnections; ++i) {
                    ConnectionInfo cinfo = this.createConnection();
                    this.idleConnections.offer(cinfo);
                }
                if (!dedicated) {
                    Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX, this.cfgListener);
                    Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX, this.cfgListener);
                    Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + REAP_INTERVAL_PROP_SUFFIX, this.cfgListener);
                }
                Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + POLL_TIMEOUT_PROP_SUFFIX, this.cfgListener);
                Globals.getConfig().addListener(this.dbmgr.getJDBCPropPrefix() + INVALIDATE_ALL_PROP_SUFFIX, this.cfgListener);
                if (this.connectionReaper != null) {
                    this.connectionReaper.cancel();
                }
                this.connectionReaper = new ConnectionReaperTask();
                Globals.getTimer().schedule((TimerTask)this.connectionReaper, this.reapInterval, this.reapInterval);
                this.initialized = true;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("initialized", String.valueOf(this.initialized));
        ht.put("minConnections", String.valueOf(this.minConnections));
        ht.put("maxConnections", String.valueOf(this.maxConnections));
        ht.put("reapInterval", String.valueOf(this.reapInterval));
        ht.put("timeoutIdle", this.timeoutIdle);
        ht.put("validateQuery", Boolean.valueOf(this.validationQuery));
        ht.put("validateOnGet", this.validateOnGet);
        ht.put("invalidateAll", this.invalidateAll);
        ht.put("isPoolDataSource", this.isPoolDataSource);
        ht.put("activeConnections.size", String.valueOf(this.activeConnections.size()));
        ht.put("idleConnections.size", String.valueOf(this.idleConnections.size()));
        return ht;
    }

    public void close() {
        if (!this.initialized) {
            return;
        }
        this.lock.lock();
        try {
            if (this.connectionReaper != null) {
                this.connectionReaper.cancel();
                this.connectionReaper = null;
            }
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + MIN_CONN_PROP_SUFFIX, this.cfgListener);
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + MAX_CONN_PROP_SUFFIX, this.cfgListener);
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + POLL_TIMEOUT_PROP_SUFFIX, this.cfgListener);
            Globals.getConfig().removeListener(this.dbmgr.getJDBCPropPrefix() + REAP_INTERVAL_PROP_SUFFIX, this.cfgListener);
            for (ConnectionInfo cinfo : this.idleConnections) {
                this.destroyConnection(cinfo);
            }
            this.idleConnections.clear();
            this.initialized = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "(" + this.name + ")[" + this.activeConnections.size() + "," + this.idleConnections.size() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, this.toString() + ".reset");
        }
        if (!this.initialized) {
            return;
        }
        ArrayList oldConnections = new ArrayList(this.maxConnections);
        this.lock.lock();
        try {
            this.activeConnections.clear();
            this.idleConnections.drainTo(oldConnections);
            for (int i = 0; i < this.minConnections; ++i) {
                ConnectionInfo cinfo = this.createConnection();
                this.idleConnections.offer(cinfo);
            }
            for (ConnectionInfo cinfo : oldConnections) {
                this.destroyConnection(cinfo);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private ConnectionInfo createConnection() throws BrokerException {
        Object conn = this.dbmgr.getNewConnection();
        ConnectionInfo cinfo = new ConnectionInfo(conn, this.connectionListener);
        this.connMap.put(conn, cinfo);
        return cinfo;
    }

    private void destroyConnection(ConnectionInfo cinfo) {
        if (DEBUG) {
            this.logger.log(8, "DBConnectionPool.destroyConnection " + cinfo);
        }
        cinfo.destroy();
        this.connMap.remove(cinfo.getKey());
    }

    public Connection getConnection() throws BrokerException {
        if (DEBUG) {
            this.logger.log(8, "[" + Thread.currentThread() + "]" + this.toString() + ".getConnection");
        }
        if (DEBUG) {
            FaultInjection fi = FaultInjection.getInjection();
            if (fi.FAULT_INJECTION) {
                fi.checkFaultAndSleep("jdbc.getconn.1", null);
            }
        }
        Connection conn = null;
        boolean createdNew = false;
        boolean pollWait = false;
        ConnectionInfo cinfo = this.idleConnections.poll();
        if (cinfo == null && this.activeConnections.size() < this.maxConnections) {
            cinfo = this.createConnection();
            try {
                conn = cinfo.getConnection();
            }
            catch (Exception e) {
                this.destroyConnection(cinfo);
                throw new BrokerException(cinfo + e.getMessage(), e);
            }
            if (DEBUG) {
                createdNew = true;
            }
        } else {
            while (cinfo == null) {
                try {
                    if (DEBUG && !pollWait) {
                        pollWait = true;
                    }
                    int pollto = this.pollTimeout;
                    if (BrokerStateHandler.isStoreShutdownStage1()) {
                        throw new BrokerException(this.br.getKString("B2246", this.name));
                    }
                    if (BrokerStateHandler.getShutdownThread() == Thread.currentThread()) {
                        pollto = 60;
                    }
                    int slept = 0;
                    while (!(BrokerStateHandler.isStoreShutdownStage1() || pollto > 0 && slept >= pollto)) {
                        if (slept != 0 && slept % 15 == 0) {
                            this.logger.log(8, this.br.getKString("B1393", Thread.currentThread()) + this.toString());
                        }
                        if ((cinfo = this.idleConnections.poll(1L, TimeUnit.SECONDS)) != null) break;
                        if (BrokerStateHandler.isStoreShutdownStage1()) {
                            throw new BrokerException(this.br.getKString("B2246", this.name));
                        }
                        cinfo = this.idleConnections.poll();
                        if (cinfo != null) break;
                        if (this.activeConnections.size() < this.maxConnections) {
                            cinfo = this.createConnection();
                            if (!DEBUG) break;
                            createdNew = true;
                            break;
                        }
                        if (++slept % 60 != 0 && (pollto <= 0 || slept != pollto)) continue;
                        StringBuffer buff = new StringBuffer(1024);
                        for (Map.Entry<ConnectionInfo, Thread> e : this.activeConnections.entrySet()) {
                            Thread t = e.getValue();
                            buff.append("\n").append(t.getName()).append(": using connection: ").append(e.getKey());
                            StackTraceElement[] trace = t.getStackTrace();
                            for (int i = 0; i < trace.length; ++i) {
                                buff.append("\n\tat " + trace[i]);
                            }
                        }
                        String emsg = this.br.getKTString("B1340", "(" + this.activeConnections.size() + "," + this.idleConnections.size() + ")[" + this.minConnections + "," + this.maxConnections + "]", String.valueOf(slept)) + "\n" + buff.toString();
                        this.logger.log(16, emsg + this.toString());
                    }
                    if (cinfo != null) continue;
                    throw new BrokerException(this.br.getKTString("B2247"));
                }
                catch (Exception e) {
                    if (e instanceof BrokerException) {
                        throw (BrokerException)e;
                    }
                    if (!DEBUG) continue;
                    this.logger.logStack(8, this.toString() + ".getConnection: " + e.getMessage(), e);
                }
            }
            boolean valid = true;
            if (this.getInvalidateAllTimestamp(cinfo.getCreationTime()) != null) {
                valid = false;
            }
            if (!valid || !this.validateConnection(cinfo, this.validateOnGet, true)) {
                this.destroyConnection(cinfo);
                try {
                    cinfo = this.createConnection();
                    conn = cinfo.getConnection();
                    this.logger.log(8, this.br.getKString("B1149", "" + cinfo, this.dbmgr.getOpenDBURL()) + this.toString());
                }
                catch (Exception e) {
                    this.destroyConnection(cinfo);
                    String emsg = this.br.getString("B4206", this.dbmgr.getOpenDBURL());
                    this.logger.logStack(32, emsg + this.toString(), e);
                    throw new BrokerException(emsg, e);
                }
            }
            try {
                conn = cinfo.getConnection();
            }
            catch (Exception e) {
                this.destroyConnection(cinfo);
                throw new BrokerException(cinfo + e.getMessage(), e);
            }
        }
        Thread borrower = Thread.currentThread();
        this.activeConnections.put(cinfo, borrower);
        if (DEBUG) {
            this.logger.log(8, this.toString() + ".getConnection[" + createdNew + "," + pollWait + "]: " + borrower.getName() + " [" + new Date() + "]: check out connection: 0x" + conn.hashCode() + cinfo);
        }
        return conn;
    }

    public void freeConnection(Connection conn, Throwable ex) {
        ConnectionInfo cinfo;
        if (DEBUG) {
            this.logger.log(8, this.toString() + ".freeConnection: connection: 0x" + conn.hashCode() + (ex == null ? "" : ", ex=" + ex));
        }
        boolean destroy = false;
        Throwable cause = ex;
        if (ex instanceof BrokerException) {
            cause = ex.getCause();
        }
        if (cause instanceof SQLException || cause instanceof IOException) {
            if (DEBUG) {
                this.logger.logStack(8, this.br.getKString("B1431", "0x" + conn.hashCode(), cause.toString()) + this.toString(), cause);
            } else {
                this.logger.log(8, this.br.getKString("B1431", "0x" + conn.hashCode(), cause.toString()) + this.toString());
            }
            destroy = true;
        }
        if (!destroy && this.isPoolDataSource) {
            try {
                conn.close();
                return;
            }
            catch (Throwable e) {
                this.logger.log(16, this.br.getKString("B2229", "0x" + conn.hashCode(), e.toString()) + this.toString());
                ex = e;
                destroy = true;
            }
        }
        if ((cinfo = this.connMap.get(conn)) == null) {
            this.logger.log(16, this.br.getKString("B2230", "0x" + conn.hashCode()) + this.toString());
            try {
                conn.close();
            }
            catch (Exception e) {
                this.logger.log(16, this.br.getKString("B2229", "0x" + conn.hashCode(), e.toString()) + this.toString());
            }
            return;
        }
        cinfo.setException(ex);
        this.returnConnection(cinfo, ex, destroy);
    }

    private void returnConnection(ConnectionInfo cinfo, Throwable ex, boolean destroy) {
        Thread thread;
        if (DEBUG) {
            this.logger.log(8, this.toString() + ".returnConnection: connection: " + cinfo + (ex == null ? "" : ", ex=" + ex) + (!destroy ? "" : ", destroy=" + destroy));
        }
        if (destroy && Util.isConnectionError(ex, this.dbmgr, false)) {
            this.setInvalidateAllTimestamp();
        }
        if ((thread = this.activeConnections.remove(cinfo)) == null) {
            if (destroy) {
                this.logger.log(8, this.br.getKString("B1344", cinfo.toString(), ex.toString()) + this.toString());
                if (!this.idleConnections.remove(cinfo) && DEBUG) {
                    this.logger.log(8, this.toString() + ".returnConnection: " + "Destroy an inactive/non-idle database connection " + cinfo.toString());
                }
            } else if (DEBUG) {
                this.logger.log(16, this.toString() + ".returnConnection(" + cinfo + (ex == null ? "" : ", ex=" + ex) + "): not found in connection pool\n" + SupportUtil.getStackTrace(""));
            } else {
                this.logger.log(16, this.br.getKString("B2228", "" + cinfo + "[" + (ex == null ? "" : ", ex=" + ex) + "]") + this.toString());
            }
            this.destroyConnection(cinfo);
        } else {
            if (destroy) {
                this.logger.log(8, this.br.getKString("B1345", cinfo.toString(), ex.toString()) + this.toString());
                this.destroyConnection(cinfo);
                return;
            }
            if (ex != null && !this.validateConnection(cinfo, ex instanceof SQLException || ex.getCause() instanceof SQLException, false)) {
                this.destroyConnection(cinfo);
                return;
            }
            if (this.invalidateAll && this.getInvalidateAllTimestamp(cinfo.getCreationTime()) != null) {
                this.destroyConnection(cinfo);
                return;
            }
            cinfo.idleStart();
            this.idleConnections.offer(cinfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInvalidateAllTimestamp() {
        Long ts = System.currentTimeMillis();
        Object object = this.invalidateAllTimestampLock;
        synchronized (object) {
            this.invalidateAllTimestamp = ts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getInvalidateAllTimestamp(long creationTime) {
        Object object = this.invalidateAllTimestampLock;
        synchronized (object) {
            if (this.invalidateAllTimestamp == null) {
                return null;
            }
            if (creationTime > this.invalidateAllTimestamp) {
                this.invalidateAllTimestamp = null;
                return null;
            }
            return this.invalidateAllTimestamp;
        }
    }

    private void initValidationQuery() throws BrokerException {
        if (this.dbmgr.isMysql()) {
            this.validationQuery = "/* ping */";
        } else if (this.dbmgr.isOracle()) {
            this.validationQuery = "SELECT 1 FROM DUAL";
        } else if (this.validationQuery == null && this.dbmgr.isStoreInited()) {
            try {
                this.validationQuery = "SELECT 1 FROM " + this.dbmgr.getFirstDAO().getTableName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateConnection(ConnectionInfo cinfo, boolean ping, boolean get) {
        boolean doping = ping;
        Connection conn = null;
        boolean destroyIdles = false;
        cinfo.setValidating(true);
        try {
            Boolean valid;
            block60: {
                Object o = cinfo.getKey();
                if (o instanceof Connection) {
                    if (((Connection)o).isClosed()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (Util.isConnectionError(cinfo.getException(), this.dbmgr)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (cinfo.getException() != null) {
                    boolean bl = false;
                    return bl;
                }
                if (get && System.currentTimeMillis() - cinfo.getIdleStartTime() >= this.reapInterval) {
                    if (this.timeoutIdle) {
                        boolean bl = false;
                        return bl;
                    }
                    doping = true;
                }
                if (!doping) {
                    boolean bl = true;
                    return bl;
                }
                conn = cinfo.getConnection();
                if (conn == null) {
                    boolean bl = false;
                    return bl;
                }
                Statement stmt = null;
                ResultSet rs = null;
                valid = null;
                try {
                    block59: {
                        stmt = conn.createStatement();
                        int queryTimeout = stmt.getQueryTimeout();
                        if (this.dbmgr.isJDBC4()) {
                            try {
                                Class<Connection> cc = Connection.class;
                                Method m = cc.getMethod("isValid", Integer.TYPE);
                                long startime = System.currentTimeMillis();
                                boolean b = (Boolean)m.invoke((Object)conn, queryTimeout);
                                if (!b) {
                                    if (queryTimeout > 0 && System.currentTimeMillis() < startime + (long)queryTimeout * 1000L) {
                                        valid = false;
                                        destroyIdles = true;
                                        this.setInvalidateAllTimestamp();
                                    } else if (queryTimeout == 0) {
                                        valid = false;
                                        destroyIdles = true;
                                        this.setInvalidateAllTimestamp();
                                    }
                                } else {
                                    valid = b;
                                    if (DEBUG) {
                                        FaultInjection fi = FaultInjection.getInjection();
                                        if (fi.FAULT_INJECTION && fi.checkFault("jdbc.validateconn.1", null)) {
                                            fi.unsetFault("jdbc.validateconn.1");
                                            valid = false;
                                            destroyIdles = true;
                                            this.setInvalidateAllTimestamp();
                                        }
                                    }
                                }
                            }
                            catch (NoSuchMethodException e) {
                                this.dbmgr.setJDBC4(false);
                            }
                            catch (Throwable t) {
                                if (t instanceof InvocationTargetException) {
                                    Throwable cause = ((InvocationTargetException)t).getTargetException();
                                    if (cause == null) {
                                        cause = t.getCause();
                                    }
                                    if (cause != null && cause instanceof AbstractMethodError) {
                                        this.dbmgr.setJDBC4(false);
                                    }
                                }
                                if (!this.dbmgr.isJDBC4() || !DEBUG) break block59;
                                this.logger.logStack(8, this.toString() + ".validateConnection: " + "Exception in invoking Connection.isValid(" + queryTimeout + ")", t);
                            }
                        }
                    }
                    String sql = null;
                    if (valid == null && (sql = this.validationQuery) == null) {
                        valid = true;
                    }
                    if (valid != null) break block60;
                    try {
                        try {
                            rs = CommDBManager.executeQueryStatement(stmt, sql);
                            if (DEBUG) {
                                FaultInjection fi = FaultInjection.getInjection();
                                if (fi.FAULT_INJECTION && fi.checkFault("jdbc.validateconn.1", null)) {
                                    fi.unsetFault("jdbc.validateconn.1");
                                    throw new SQLException("jdbc.validateconn.1");
                                }
                            }
                        }
                        catch (SQLException e) {
                            destroyIdles = true;
                            this.setInvalidateAllTimestamp();
                            throw e;
                        }
                        valid = rs.next() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    finally {
                        try {
                            if (!conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(16, this.br.getKString("B2226", "[" + sql + "]" + cinfo, e.toString()) + this.toString());
                            valid = false;
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (o instanceof PooledConnection) {
                        try {
                            conn.close();
                        }
                        catch (Exception e) {
                            this.logger.log(16, this.br.getKString("B2226", "" + cinfo + "[0x" + conn.hashCode() + "]", e.toString()) + this.toString());
                            valid = false;
                        }
                    }
                }
            }
            if (valid == null) {
                valid = false;
            }
            boolean bl = valid;
            return bl;
        }
        catch (Exception e) {
            this.logger.logStack(16, this.br.getKString("B2226", cinfo.toString(), e.getMessage()) + this.toString(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            cinfo.setValidating(false);
            cinfo.setException(null);
            if (destroyIdles && this.invalidateAll) {
                this.destroyIdleConnections();
            }
        }
    }

    private void destroyIdleConnections() {
        int cnt;
        int idleCnt = this.idleConnections.size();
        ConnectionInfo cinfo = this.idleConnections.poll();
        for (cnt = 0; cinfo != null && cnt < idleCnt; ++cnt) {
            this.destroyConnection(cinfo);
            cinfo = this.idleConnections.poll();
        }
        Object[] args = new Object[]{cnt};
        this.logger.log(8, this.br.getKTString("B1519", args) + this.toString());
    }

    private void reapExcessConnection() {
        int activeCnt = this.activeConnections.size();
        int idleCnt = this.idleConnections.size();
        if (DEBUG) {
            this.logger.log(8, this.toString() + ".reapExcessConnection: " + "pool size: min=" + this.minConnections + ", max=" + this.maxConnections + ", active=" + activeCnt + ", idle=" + idleCnt);
        }
        int reapCnt = 0;
        ConnectionInfo cinfo = null;
        while (idleCnt > 0 && activeCnt + idleCnt > this.minConnections && (cinfo = this.idleConnections.poll()) != null) {
            this.destroyConnection(cinfo);
            ++reapCnt;
            activeCnt = this.activeConnections.size();
            idleCnt = this.idleConnections.size();
        }
        if (!this.dedicated || reapCnt != 0) {
            boolean log = true;
            if (reapCnt == 0 && !DEBUG) {
                log = false;
            }
            if (log) {
                this.logger.log(8, this.br.getKString("B1342", reapCnt) + this.toString());
            }
        }
        if (this.timeoutIdle) {
            this.timeoutIdleConnections();
        }
        int createCnt = 0;
        activeCnt = this.activeConnections.size();
        idleCnt = this.idleConnections.size();
        while (activeCnt + idleCnt < this.minConnections) {
            try {
                cinfo = this.createConnection();
                if (this.activeConnections.size() + this.idleConnections.size() < this.minConnections) {
                    this.idleConnections.offer(cinfo);
                    ++createCnt;
                } else {
                    this.destroyConnection(cinfo);
                    break;
                }
                activeCnt = this.activeConnections.size();
                idleCnt = this.idleConnections.size();
            }
            catch (BrokerException e) {
                if (DEBUG) {
                    this.logger.logStack(16, "JDBC connection pool reaper thread failed to create new connection", e);
                    break;
                }
                this.logger.log(16, this.br.getKString("B2235", e.getMessage()));
                break;
            }
        }
        if (createCnt > 0) {
            this.logger.log(8, this.br.getKString("B1520", createCnt) + this.toString());
        }
    }

    private void timeoutIdleConnections() {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] o = this.idleConnections.toArray();
        int cnt = o.length;
        long currtime = System.currentTimeMillis();
        boolean found = false;
        for (int i = 0; i < cnt; ++i) {
            list.add(o[i]);
            if (currtime - ((ConnectionInfo)o[i]).getIdleStartTime() >= this.reapInterval) {
                found = true;
            }
            if (this.getInvalidateAllTimestamp(((ConnectionInfo)o[i]).getCreationTime()) == null) continue;
            found = true;
        }
        if (!found || list.size() == 0) {
            return;
        }
        ConnectionInfo cinfo = this.idleConnections.peek();
        if (cinfo == null) {
            return;
        }
        ArrayList<ConnectionInfo> seen = new ArrayList<ConnectionInfo>();
        Thread borrower = Thread.currentThread();
        int idleTimeoutCnt = 0;
        for (int i = 0; i < cnt; ++i) {
            if (DEBUG) {
                this.logger.log(8, "DBConnectionPool.reapExcessConnection idleTimeoutCnt=" + idleTimeoutCnt + ", cnt=" + cnt + ", i=" + i);
            }
            if ((cinfo = this.idleConnections.peek()) == null || !list.contains(cinfo) || seen.contains(cinfo) || (cinfo = this.idleConnections.poll()) == null) break;
            seen.add(cinfo);
            this.activeConnections.put(cinfo, borrower);
            if (list.contains(cinfo) && (currtime - cinfo.getIdleStartTime() >= this.reapInterval || this.getInvalidateAllTimestamp(cinfo.getCreationTime()) != null)) {
                this.activeConnections.remove(cinfo);
                this.destroyConnection(cinfo);
                ++idleTimeoutCnt;
                continue;
            }
            this.activeConnections.remove(cinfo);
            this.idleConnections.offer(cinfo);
        }
        if (idleTimeoutCnt > 0) {
            this.logger.log(8, this.br.getKString("B1343", idleTimeoutCnt) + this.toString());
        }
    }

    private class DBConnectionListener
    implements ConnectionEventListener {
        @Override
        public void connectionClosed(ConnectionEvent event) {
            PooledConnection pconn = (PooledConnection)event.getSource();
            ConnectionInfo cinfo = (ConnectionInfo)DBConnectionPool.this.connMap.get(pconn);
            if (cinfo == null) {
                throw new IllegalStateException("No mapping for PooledConnection 0x" + pconn.hashCode() + "[" + pconn.getClass().getName() + "]");
            }
            if (DEBUG) {
                Logger logger = DBConnectionPool.this.logger;
                DBConnectionPool.this.logger;
                logger.log(8, this.toString() + ".connectionClosed event on " + cinfo);
            }
            if (!cinfo.inValidating()) {
                boolean destroy = false;
                Throwable e = cinfo.getException();
                if (e != null) {
                    Throwable cause = e;
                    if (e instanceof BrokerException) {
                        cause = e.getCause();
                    }
                    if (cause instanceof SQLException || cause instanceof IOException) {
                        if (DEBUG) {
                            Logger logger = DBConnectionPool.this.logger;
                            StringBuilder stringBuilder = new StringBuilder();
                            BrokerResources brokerResources = DBConnectionPool.this.br;
                            DBConnectionPool.this.br;
                            logger.logStack(8, stringBuilder.append(brokerResources.getKString("B1431", cinfo.toString(), cause.toString())).append(this.toString()).toString(), cause);
                        } else {
                            Logger logger = DBConnectionPool.this.logger;
                            StringBuilder stringBuilder = new StringBuilder();
                            BrokerResources brokerResources = DBConnectionPool.this.br;
                            DBConnectionPool.this.br;
                            logger.log(8, stringBuilder.append(brokerResources.getKString("B1431", cinfo.toString(), cause.toString())).append(this.toString()).toString());
                        }
                        destroy = true;
                    }
                }
                DBConnectionPool.this.returnConnection(cinfo, cinfo.getException(), destroy);
            }
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            PooledConnection pconn = (PooledConnection)event.getSource();
            pconn.removeConnectionEventListener(this);
            ConnectionInfo cinfo = (ConnectionInfo)DBConnectionPool.this.connMap.get(pconn);
            if (cinfo == null) {
                throw new IllegalStateException("connectionErrorOccurred: No mapping for PooledConnection 0x" + pconn.hashCode() + "[" + pconn.getClass().getName() + "]");
            }
            SQLException ex = event.getSQLException();
            Logger logger = DBConnectionPool.this.logger;
            DBConnectionPool.this.logger;
            StringBuilder stringBuilder = new StringBuilder();
            BrokerResources brokerResources = DBConnectionPool.this.br;
            DBConnectionPool.this.br;
            logger.log(16, stringBuilder.append(brokerResources.getKString("B2231", "" + cinfo, "" + ex)).append(this.toString()).toString());
            if (ex == null) {
                ex = new SQLException();
            }
            cinfo.setException(ex);
            if (!cinfo.inValidating()) {
                DBConnectionPool.this.returnConnection(cinfo, cinfo.getException(), true);
            }
        }
    }

    private class ConnectionReaperTask
    extends TimerTask {
        private volatile boolean canceled = false;

        private ConnectionReaperTask() {
        }

        @Override
        public boolean cancel() {
            this.canceled = true;
            return super.cancel();
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            try {
                DBConnectionPool.this.reapExcessConnection();
            }
            catch (Exception e) {
                Globals.getLogger().logStack(32, "B3245" + this.toString(), e);
            }
        }
    }
}

