/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.glite.security.SecurityInfo;
import org.glite.security.util.CertUtil;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;
import org.glite.security.util.X500Principal;
import org.glite.security.voms.VOMSValidator;

public class SecurityContext
extends Properties
implements SecurityInfo {
    private static Logger logger = Logger.getLogger(SecurityContext.class);
    private static ThreadLocal theSecurityContexts = new ThreadLocal();
    public static final String AUTHZ_REQUESTED_ATTRIBUTES = "org.glite.security.authorization.requested_attrs";
    public static final String AUTHZ_APPROVED_ATTRIBUTES = "org.glite.security.authorization.approved_attrs";
    public static final String AUTHZ_POLICY = "org.glite.security.authorization.policy";
    public static final String CERT_CHAIN = "org.glite.security.certchain";
    public static final String CLIENT_CERT = "org.glite.security.clientcert";
    public static final String CLIENT_NAME = "org.glite.security.clientname";
    public static final String CLIENT_X500_NAME = "org.glite.security.clientX500name";
    public static final String CLIENT_X500_PRINCIPAL = "org.glite.security.clientX500Principal";
    public static final String ISSUER_NAME = "org.glite.security.issuername";
    public static final String VOMS_VALIDATOR = "org.glite.security.voms.validator";
    public static final String UNVERIFIED_CERT_CHAIN = "org.glite.security.trustmanager.unverifiedchain";
    public static final String PEER_CAS = "org.glite.security.trustmanager.peercas";
    public static final String REMOTE_ADDR = "org.glite.security.trustmanager.remoteaddr";
    public static final String SESSION_ID = "org.glite.security.trustmanager.sessionid";
    private boolean isChainParsed = false;

    public static SecurityContext getCurrentContext() {
        return (SecurityContext)theSecurityContexts.get();
    }

    public static void setCurrentContext(SecurityContext sc) {
        theSecurityContexts.set(sc);
    }

    public static void clearCurrentContext() {
        theSecurityContexts.set(null);
    }

    public void setAuthorizedAttributes(List authzdAttrs) {
        this.put(AUTHZ_APPROVED_ATTRIBUTES, authzdAttrs);
    }

    public List getAuthorizedAttributes() {
        return (List)this.get(AUTHZ_APPROVED_ATTRIBUTES);
    }

    public void setRequestedAttributes(List requestedAttrs) {
        this.put(AUTHZ_REQUESTED_ATTRIBUTES, requestedAttrs);
    }

    public List getRequestedAttributes() {
        return (List)this.get(AUTHZ_REQUESTED_ATTRIBUTES);
    }

    public void setAuthorizationPolicy(String policy) {
        this.put(AUTHZ_POLICY, policy);
    }

    public String getAuthorizationPolicy() {
        return this.getProperty(AUTHZ_POLICY);
    }

    public void setClientCert(X509Certificate clientCert) {
        this.put(CLIENT_CERT, clientCert);
        this.setIssuerName(DNHandler.getIssuer(clientCert).getRFC2253());
        DN clientDN = DNHandler.getSubject(clientCert);
        this.setClientName(clientDN.getRFC2253());
        this.setClientX500Name(clientDN.getX500());
        X500Principal principal = new X500Principal();
        principal.setName(clientDN);
        this.setClientX500Principal(principal);
    }

    public X509Certificate getClientCert() {
        return (X509Certificate)this.get(CLIENT_CERT);
    }

    public void setClientName(String clientName) {
        this.put(CLIENT_NAME, clientName);
    }

    public String getClientName() {
        return this.getProperty(CLIENT_NAME);
    }

    public void setClientX500Name(String clientName) {
        this.put(CLIENT_X500_NAME, clientName);
    }

    public String getClientX500Name() {
        return this.getProperty(CLIENT_X500_NAME);
    }

    public void setClientX500Principal(X500Principal clientPrincipal) {
        this.put(CLIENT_X500_PRINCIPAL, clientPrincipal);
    }

    public X500Principal getClientX500Principal() {
        return (X500Principal)this.get(CLIENT_X500_PRINCIPAL);
    }

    public void setIssuerName(String issuerName) {
        this.put(ISSUER_NAME, issuerName);
    }

    public String getIssuerName() {
        return this.getProperty(ISSUER_NAME);
    }

    public void setClientCertChain(X509Certificate[] certChain) {
        VOMSValidator v;
        this.put(CERT_CHAIN, certChain);
        int i = CertUtil.findClientCert(certChain);
        if (i < 0) {
            logger.warn((Object)"SecurityContext: No client certificate found in the supplied certificate chain");
            return;
        }
        this.setClientCert(certChain[i]);
        String disableVoms = System.getProperty("disableUtilJavaVoms");
        if (disableVoms == null && (v = (VOMSValidator)this.get(VOMS_VALIDATOR)) != null) {
            v.setClientChain(certChain);
        }
    }

    public X509Certificate[] getClientCertChain() {
        return (X509Certificate[])this.get(CERT_CHAIN);
    }

    public void setUnverifiedCertChain(X509Certificate[] certChain) {
        this.put(UNVERIFIED_CERT_CHAIN, certChain);
    }

    public X509Certificate[] getUnverifiedCertChain() {
        return (X509Certificate[])this.get(UNVERIFIED_CERT_CHAIN);
    }

    public void setPeerCas(Principal[] principals) {
        this.put(PEER_CAS, principals);
    }

    public Principal[] getPeerCas() {
        return (Principal[])this.get(PEER_CAS);
    }

    public void setRemoteAddr(String remoteAddr) {
        this.put(REMOTE_ADDR, remoteAddr);
    }

    public String getRemoteAddr() {
        return this.getProperty(REMOTE_ADDR);
    }

    public void setSessionId(String sessionId) {
        this.put(SESSION_ID, sessionId);
    }

    public String getSessionId() {
        return this.getProperty(SESSION_ID);
    }

    public void setVOMSValidator(VOMSValidator vomsValidator) {
        if (vomsValidator != null) {
            this.put(VOMS_VALIDATOR, vomsValidator);
        }
    }

    public VOMSValidator getVOMSValidator() {
        X509Certificate[] chain;
        VOMSValidator v = (VOMSValidator)this.get(VOMS_VALIDATOR);
        if (v == null && (chain = this.getClientCertChain()) != null) {
            v = new VOMSValidator(chain);
        }
        return v;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SecurityContext:\n");
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            sb.append("  " + entry.getKey() + " : " + entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

