/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import org.apache.log4j.Logger;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;

public class NamespaceRule {
    private static final Logger LOGGER = Logger.getLogger((String)NamespaceRule.class.getName());
    private static final int FIELD_NUM = 6;
    private DN m_issuer = null;
    private boolean m_permit = false;
    private String m_match;

    NamespaceRule(String input) {
        String matchString;
        String[] parts = input.split("\\s+");
        if (parts.length < 6) {
            LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (too few fields)"));
            throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (too few fields)");
        }
        if (!parts[0].toLowerCase().trim().equals("to")) {
            LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (does not start with \"TO\")"));
            throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (does not start with \"TO\")");
        }
        if (!parts[1].toLowerCase().trim().equals("issuer")) {
            LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (second field is not \"Issuer\")"));
            throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (second field is not \"Issuer\")");
        }
        int n = 2;
        String issuerString = parts[n++];
        if (parts[2].startsWith("\"")) {
            while (!issuerString.endsWith("\"") && n < parts.length) {
                issuerString = issuerString + " " + parts[n++];
            }
            if (n == parts.length) {
                LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (no closing \" found for issuer)"));
                throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (no closing \" found for issuer)");
            }
            issuerString = issuerString.substring(1, issuerString.length() - 1);
            this.m_issuer = DNHandler.getDN(issuerString);
        }
        if (parts.length < n + 2) {
            LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (too few fields)"));
            throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (too few fields)");
        }
        if (parts[n].toLowerCase().trim().equals("permit")) {
            this.m_permit = true;
        } else {
            this.m_permit = false;
            if (!parts[n].toLowerCase().trim().equals("deny")) {
                LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (4th field is not PERMIT or DENY)"));
                throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (4th field is not PERMIT or DENY)");
            }
        }
        int n2 = ++n;
        ++n;
        if (!parts[n2].toLowerCase().trim().equals("subject")) {
            LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (4th field is not \"Subject\")"));
            throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (4th field is not \"Subject\")");
        }
        if ((matchString = parts[n++]).startsWith("\"")) {
            while (!matchString.endsWith("\"") && n < parts.length) {
                matchString = matchString + " " + parts[n++];
            }
            if (!matchString.endsWith("\"")) {
                LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (no closing \" found for subject)"));
                throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (no closing \" found for subject)");
            }
        }
        this.m_match = matchString.substring(1, matchString.length() - 1);
        if (parts.length > n + 1) {
            LOGGER.error((Object)("Invalid namespace rule : \"" + input + "\" (too many fields)"));
            throw new IllegalArgumentException("Invalid namespace rule : \"" + input + "\" (too many fields)");
        }
    }

    public DN getIssuer() {
        return this.m_issuer;
    }

    public String getMatch() {
        return this.m_match;
    }

    public boolean isPermit() {
        return this.m_permit;
    }

    public String toString() {
        String permitString = this.m_permit ? "allowed" : "denied";
        return "Namespace rule: \"" + this.m_issuer + "\" is " + permitString + " namespace \"" + this.m_match + "\"";
    }
}

