/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.File;
import org.apache.log4j.Logger;

class FileEndingIterator {
    static Logger logger = Logger.getLogger((String)FileEndingIterator.class.getName());
    protected String ending;
    protected boolean nextFound = false;
    protected File[] fileList;
    protected int index = 0;

    public FileEndingIterator(String string, String string2) {
        this.ending = string2;
        try {
            File file = string.length() != 0 ? new File(string) : new File(".").getAbsoluteFile();
            this.fileList = file.listFiles();
            this.nextFound = this.findNext();
        }
        catch (Exception exception) {
            logger.error((Object)("no files found from \"" + string + "\" error: " + exception.getMessage()));
            return;
        }
    }

    public File next() {
        if (!this.nextFound) {
            return null;
        }
        File file = this.fileList[this.index++];
        this.nextFound = this.findNext();
        return file;
    }

    public boolean hasNext() {
        return this.nextFound;
    }

    protected boolean findNext() {
        try {
            while (this.index < this.fileList.length && (this.fileList[this.index].isDirectory() || !this.fileList[this.index].getName().endsWith(this.ending))) {
                ++this.index;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error while reading directory " + exception.getMessage()));
            return false;
        }
        return this.index < this.fileList.length;
    }
}

