/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.LSCFile;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIUtils;
import org.glite.voms.SigningPolicy;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.AttributeCertificateInfo;
import org.glite.voms.ac.VOMSTrustStore;
import org.glite.voms.contact.MyProxyCertInfo;

public class PKIVerifier {
    private static Logger logger = Logger.getLogger((String)PKIVerifier.class.getName());
    public static final String SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    public static final String AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    public static final String PROXYCERTINFO = "1.3.6.1.5.5.7.1.14";
    public static final String PROXYCERTINFO_OLD = "1.3.6.1.4.1.3536.1.222";
    public static final String BASIC_CONSTRAINTS_IDENTIFIER = "2.5.29.19";
    public static final String KEY_USAGE_IDENTIFIER = "2.5.29.15";
    public static final String TARGET = "2.5.29.55";
    private static final String[] OIDs = new String[]{"2.5.29.14", "2.5.29.35", "1.3.6.1.5.5.7.1.14", "1.3.6.1.4.1.3536.1.222", "2.5.29.19", "2.5.29.15"};
    private static final String[] AC_OIDs = new String[]{"2.5.29.55"};
    private static final Set handledOIDs = new TreeSet<String>(Arrays.asList(OIDs));
    private static final Set handledACOIDs = new TreeSet<String>(Arrays.asList(AC_OIDs));
    private PKIStore caStore = null;
    private VOMSTrustStore vomsStore = null;

    public PKIVerifier(VOMSTrustStore vOMSTrustStore, PKIStore pKIStore) {
        this.vomsStore = vOMSTrustStore;
        this.caStore = pKIStore;
    }

    public PKIVerifier(VOMSTrustStore vOMSTrustStore) throws IOException, CertificateException, CRLException {
        this.vomsStore = vOMSTrustStore;
        String string = System.getProperty("CADIR");
        this.caStore = string == null ? new PKIStore(PKIStore.DEFAULT_CADIR, 2, true) : new PKIStore(string, 2, true);
    }

    public PKIVerifier() throws IOException, CertificateException, CRLException {
        String string = System.getProperty("VOMSDIR");
        String string2 = System.getProperty("CADIR");
        if (string != null) {
            logger.debug((Object)("Initializing VOMSDIR PKIStore from non-standard location: " + string));
            this.vomsStore = new PKIStore(string, 1, true);
        } else {
            this.vomsStore = new PKIStore(PKIStore.DEFAULT_VOMSDIR, 1, true);
        }
        if (string2 != null) {
            logger.debug((Object)("Initializing CADIR PKIStore from non-standard location: " + string2));
            this.caStore = new PKIStore(string2, 2, true);
        } else {
            this.caStore = new PKIStore(PKIStore.DEFAULT_CADIR, 2, true);
        }
    }

    public void cleanup() {
        if (this.vomsStore != null) {
            this.vomsStore.stopRefresh();
        }
        if (this.caStore != null) {
            this.caStore.stopRefresh();
        }
        this.vomsStore = null;
        this.caStore = null;
    }

    public void setCAStore(PKIStore pKIStore) {
        if (this.caStore != null) {
            this.caStore.stopRefresh();
            this.caStore = null;
        }
        this.caStore = pKIStore;
    }

    public void setVOMSStore(VOMSTrustStore vOMSTrustStore) {
        if (this.vomsStore != null) {
            this.vomsStore.stopRefresh();
            this.vomsStore = null;
        }
        this.vomsStore = vOMSTrustStore;
    }

    private static String getHostName() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error((Object)"Cannot discover hostName.");
            return "";
        }
    }

    public boolean verify(AttributeCertificate attributeCertificate) {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        int n;
        if (attributeCertificate == null || this.vomsStore == null) {
            return false;
        }
        AttributeCertificateInfo attributeCertificateInfo = attributeCertificate.getAcinfo();
        X509Certificate[] x509CertificateArray = null;
        ACCerts aCCerts = attributeCertificateInfo.getCertList();
        LSCFile lSCFile = null;
        String string = attributeCertificate.getVO();
        if (aCCerts != null) {
            lSCFile = this.vomsStore.getLSC(string, attributeCertificate.getHost());
        }
        logger.debug((Object)("LSC is: " + lSCFile));
        if (lSCFile != null) {
            n = 0;
            object4 = lSCFile.getDNLists();
            object3 = ((Vector)object4).iterator();
            while (n == 0 && object3.hasNext()) {
                boolean bl = false;
                while (object3.hasNext() && !bl) {
                    object22 = aCCerts.getCerts().iterator();
                    object = (Vector)object3.next();
                    Iterator iterator = ((Vector)object).iterator();
                    while (iterator.hasNext() && object22.hasNext() && !bl) {
                        String string2 = null;
                        String string3 = null;
                        try {
                            string2 = (String)iterator.next();
                            string3 = (String)iterator.next();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            bl = true;
                        }
                        X509Certificate x509Certificate = (X509Certificate)object22.next();
                        String string4 = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN());
                        String string5 = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getIssuerDN());
                        logger.debug((Object)("dn is : " + string2));
                        logger.debug((Object)("is is : " + string3));
                        logger.debug((Object)("canddn is : " + string4));
                        logger.debug((Object)("candis is : " + string5));
                        logger.debug((Object)("dn == canddn is " + string2.equals(string4)));
                        logger.debug((Object)("is == candis is " + string3.equals(string5)));
                        if (string2.equals(string4) && string3.equals(string5)) continue;
                        bl = true;
                    }
                    if (bl || iterator.hasNext() || object22.hasNext()) continue;
                    n = 1;
                }
            }
            if (n == 1) {
                logger.debug((Object)"LSC Verification step.");
                x509CertificateArray = aCCerts.getCerts().toArray(new X509Certificate[0]);
                if (!attributeCertificate.verifyCert(x509CertificateArray[0])) {
                    x509CertificateArray = null;
                    logger.debug((Object)"Signature Verification false (from LSC).");
                } else {
                    logger.debug((Object)"Signature Verification OK (from LSC).");
                }
            }
        }
        if (x509CertificateArray == null) {
            X509Certificate[] x509CertificateArray2;
            logger.debug((Object)"lsc check failed.");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for hash: " + PKIUtils.getHash(attributeCertificate.getIssuer()) + " for certificate: " + attributeCertificate.getIssuer().getName()));
            }
            if ((x509CertificateArray2 = this.vomsStore.getAACandidate(attributeCertificate.getIssuer(), string)) == null) {
                logger.debug((Object)"No candidates found!");
            } else if (x509CertificateArray2.length != 0) {
                for (int i = 0; i < x509CertificateArray2.length; ++i) {
                    object3 = x509CertificateArray2[i];
                    PublicKey publicKey = ((Certificate)object3).getPublicKey();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Candidate: " + ((X509Certificate)object3).getSubjectDN().getName()));
                        logger.debug((Object)("Key class: " + publicKey.getClass()));
                        logger.debug((Object)("Key: " + publicKey));
                        object22 = publicKey.getEncoded();
                        object = "Key: ";
                        for (int j = 0; j < ((Object)object22).length; ++j) {
                            object = (String)object + Integer.toHexString((int)object22[j]) + " ";
                        }
                        logger.debug(object);
                    }
                    if (attributeCertificate.verifyCert((X509Certificate)object3)) {
                        logger.debug((Object)"Signature Verification OK");
                        x509CertificateArray = new X509Certificate[]{object3};
                        break;
                    }
                    logger.debug((Object)"Signature Verification false");
                }
            }
        }
        if (x509CertificateArray == null) {
            logger.error((Object)"Cannot find usable certificates to validate the AC. Check that the voms server host certificate is in your vomsdir directory.");
            return false;
        }
        if (logger.isDebugEnabled()) {
            for (n = 0; n < x509CertificateArray.length; ++n) {
                logger.debug((Object)("Position: " + n + " value: " + x509CertificateArray[n].getSubjectDN().getName()));
            }
        }
        if (!this.verify(x509CertificateArray)) {
            logger.error((Object)"Cannot verify issuer certificate chain for AC");
            return false;
        }
        if (!attributeCertificate.isValid()) {
            logger.error((Object)"Attribute Certificate not valid at current time.");
            return false;
        }
        ACTargets aCTargets = attributeCertificateInfo.getTargets();
        if (aCTargets != null) {
            object4 = PKIVerifier.getHostName();
            boolean bl = false;
            for (Object object22 : aCTargets.getTargets()) {
                if (!((String)object22).equals(object4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                logger.error((Object)"Targeting check failed!");
                return false;
            }
        }
        if ((object4 = attributeCertificateInfo.getExtensions()) != null) {
            Enumeration enumeration = object4.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                object22 = object4.getExtension(dERObjectIdentifier);
                if (!object22.isCritical() || handledACOIDs.contains(dERObjectIdentifier)) continue;
                logger.error((Object)("Unknown critical extension discovered: " + dERObjectIdentifier.getId()));
                return false;
            }
        }
        return true;
    }

    private boolean checkProxyCertInfo(X509Certificate x509Certificate, int n, int n2) {
        byte[] byArray = x509Certificate.getExtensionValue(PROXYCERTINFO);
        if (byArray == null && (byArray = x509Certificate.getExtensionValue(PROXYCERTINFO_OLD)) == null) {
            logger.debug((Object)"No ProxyCertInfo extension found.");
            return true;
        }
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = ASN1Object.fromByteArray((byte[])byArray);
        }
        catch (IOException iOException) {
            return false;
        }
        if (aSN1Object instanceof ASN1Sequence) {
            MyProxyCertInfo myProxyCertInfo = new MyProxyCertInfo((ASN1Sequence)aSN1Object);
            logger.info((Object)("Constraint: " + myProxyCertInfo.getPathLenConstraint() + "   Size: " + n2 + "   Current: " + n));
            return myProxyCertInfo.getPathLenConstraint() >= n2 - n;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(X509Certificate[] x509CertificateArray) {
        X509Certificate x509Certificate3;
        X509Certificate x509Certificate2;
        Stack<X509Certificate> stack;
        block37: {
            Vector vector;
            Object object;
            Hashtable hashtable;
            block36: {
                if (this.caStore == null) {
                    logger.error((Object)"No Trust Anchor are known.");
                    return false;
                }
                if (x509CertificateArray.length <= 0) {
                    logger.error((Object)"Certificate verification: passed empty certificate array.");
                    return false;
                }
                hashtable = this.caStore.getCAs();
                stack = new Stack<X509Certificate>();
                stack.push(x509CertificateArray[0]);
                logger.info((Object)("Certificate verification: Verifying certificate '" + x509CertificateArray[0].getSubjectDN().getName() + "'"));
                x509Certificate2 = x509CertificateArray[0];
                logger.debug((Object)("path length = " + x509CertificateArray.length));
                for (int i = 1; i < x509CertificateArray.length; ++i) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Checking: " + x509CertificateArray[i].getSubjectDN().getName()));
                    }
                    if (PKIUtils.checkIssued(x509CertificateArray[i], x509CertificateArray[i - 1])) {
                        logger.debug((Object)"Is issuer");
                        stack.push(x509CertificateArray[i]);
                        x509Certificate2 = x509CertificateArray[i];
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("ELEMENT: " + x509Certificate2.getSubjectDN().getName()));
                        }
                    }
                    logger.debug((Object)"Is not issuer");
                }
                logger.debug((Object)"Before anchor searching.");
                x509Certificate3 = null;
                if (logger.isDebugEnabled()) {
                    object = stack.iterator();
                    while (object.hasNext()) {
                        logger.debug((Object)("Content: " + ((X509Certificate)object.next()).getSubjectDN().getName()));
                    }
                }
                if (!PKIUtils.selfIssued(x509Certificate2)) break block36;
                object = PKIUtils.getHash(x509Certificate2);
                vector = (Vector)hashtable.get(object);
                int n = -1;
                if (vector != null && (n = vector.indexOf(x509Certificate2)) != -1) {
                    stack.pop();
                    x509Certificate3 = (X509Certificate)vector.elementAt(n);
                    stack.push(x509Certificate3);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ELEMENT: " + x509Certificate3.getSubjectDN().getName()));
                    }
                    break block37;
                } else {
                    logger.error((Object)("Certificate verification: self-signed certificate '" + x509Certificate3.getSubjectDN().getName() + "' not found among trusted certificates."));
                    return false;
                }
            }
            x509Certificate3 = null;
            logger.debug((Object)"Looking for anchor");
            block7: do {
                object = PKIUtils.getHash(x509Certificate2.getIssuerX500Principal());
                logger.debug((Object)("hash = " + (String)object));
                vector = (Vector)hashtable.get(object);
                if (vector == null) continue;
                logger.debug((Object)("CANDIDATES: " + vector));
                for (X509Certificate x509Certificate3 : vector) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Candidate = " + x509Certificate3.getSubjectDN().getName()));
                    }
                    if (PKIUtils.checkIssued(x509Certificate3, x509Certificate2)) {
                        stack.push(x509Certificate3);
                        x509Certificate2 = x509Certificate3;
                        if (!logger.isDebugEnabled()) continue block7;
                        logger.debug((Object)("ELEMENT: " + x509Certificate3.getSubjectDN().getName()));
                        continue block7;
                    }
                    x509Certificate3 = null;
                }
            } while (x509Certificate3 != null && !PKIUtils.selfIssued(x509Certificate2));
        }
        if (x509Certificate3 == null) {
            logger.error((Object)"Certificate verification: no trust anchor found.");
            return false;
        }
        int n = 0;
        boolean bl = true;
        PublicKey publicKey = null;
        X509Certificate x509Certificate4 = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Constructed chain:");
            Iterator iterator = stack.iterator();
            while (iterator.hasNext()) {
                logger.debug((Object)("Content: " + ((X509Certificate)iterator.next()).getSubjectDN().getName()));
            }
        }
        int n2 = stack.size();
        int n3 = n2 + 1;
        while (!stack.isEmpty()) {
            Set<String> set;
            x509Certificate2 = (X509Certificate)stack.pop();
            --n3;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VERIFYING : " + x509Certificate2.getSubjectDN().getName()));
            }
            if (!this.checkProxyCertInfo(x509Certificate2, n3, n2)) {
                logger.error((Object)"ProxyCertInfo extension violated.");
                return false;
            }
            if (PKIUtils.selfIssued(x509Certificate2)) {
                if (n != 0) {
                    logger.error((Object)"Certificate verification: Self signed certificate not trust anchor");
                    logger.error((Object)("subject: " + x509Certificate2.getSubjectDN().getName()));
                    return false;
                }
                publicKey = x509Certificate2.getPublicKey();
                x509Certificate4 = x509Certificate2;
            }
            logger.debug((Object)"Checking chain");
            if (!x509Certificate2.getIssuerX500Principal().equals(x509Certificate4.getSubjectX500Principal())) {
                logger.error((Object)"Certificate verification: issuing chain broken.");
                return false;
            }
            logger.debug((Object)"Checking validity");
            try {
                x509Certificate2.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                logger.error((Object)("Certificate verification: certificate in chain expired. " + certificateExpiredException.getMessage()), (Throwable)certificateExpiredException);
                logger.error((Object)("Faulty certificate: " + x509Certificate2.getSubjectDN().getName()));
                logger.error((Object)("End validity      : " + x509Certificate2.getNotAfter().toString()));
                return false;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                logger.error((Object)("Certificate verification: certificate in chain not yet valid. " + certificateNotYetValidException.getMessage()), (Throwable)certificateNotYetValidException);
                logger.error((Object)("Faulty certificate: " + x509Certificate2.getSubjectDN().getName()));
                logger.error((Object)("Start validity      : " + x509Certificate2.getNotBefore().toString()));
                return false;
            }
            logger.debug((Object)"Checking key");
            try {
                x509Certificate2.verify(publicKey);
            }
            catch (Exception exception) {
                logger.error((Object)("Certificate verification: cannot verify signature. " + exception.getMessage()), (Throwable)exception);
                logger.error((Object)("Faulty certificate: " + x509Certificate2.getSubjectDN().getName()));
                return false;
            }
            logger.debug((Object)"Checking revoked");
            if (this.isRevoked(x509Certificate2, x509Certificate4)) {
                logger.error((Object)"Certificate verification: certificate in chain has been revoked.");
                logger.error((Object)("Faulty certificate: " + x509Certificate2.getSubjectDN().getName()));
                return false;
            }
            boolean bl2 = PKIUtils.isCA(x509Certificate4);
            logger.debug((Object)("Checking CA " + bl2));
            if (bl2) {
                if (!this.allowsPath(x509Certificate2, x509Certificate4)) {
                    logger.error((Object)("Certificate verification: subject '" + x509Certificate2.getSubjectDN().getName() + "' not allowed by CA '" + x509Certificate4.getSubjectDN().getName() + "'"));
                    return false;
                }
                int n4 = x509Certificate2.getBasicConstraints();
                logger.debug((Object)("stack.size = " + stack.size() + " maxPath = " + n4));
                if (n4 != -1 && n4 < stack.size()) {
                    logger.error((Object)"Certificate verification: Maximum certification path length exceeded.");
                    return false;
                }
            } else {
                logger.debug((Object)"Checking for Proxy");
                if (!PKIUtils.isProxy(x509Certificate2)) {
                    logger.error((Object)"Certificate verification: Non-proxy, non-CA certificate issued a certificate.");
                    return false;
                }
            }
            if ((set = x509Certificate2.getCriticalExtensionOIDs()) != null && !handledOIDs.containsAll(set)) {
                logger.error((Object)"Certificate verification: Certificate contain unhandled critical extensions.");
                return false;
            }
            x509Certificate4 = x509Certificate2;
            publicKey = x509Certificate2.getPublicKey();
            ++n;
        }
        if (bl) return true;
        return false;
    }

    private boolean allowsPath(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (PKIUtils.selfIssued(x509Certificate)) {
            return true;
        }
        Hashtable hashtable = this.caStore.getSignings();
        SigningPolicy signingPolicy = (SigningPolicy)hashtable.get(PKIUtils.getHash(x509Certificate2));
        logger.debug((Object)("signCandidate is: " + signingPolicy));
        boolean bl = false;
        if (signingPolicy != null) {
            logger.debug((Object)("Class of issuer is : " + x509Certificate2.getClass()));
            logger.debug((Object)("Class of Subject is: " + x509Certificate2.getSubjectDN().getClass()));
            String string = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate2.getSubjectDN());
            logger.debug((Object)("Subject is : " + string));
            Vector vector = this.getAllNames(x509Certificate);
            if (vector == null) {
                return false;
            }
            logger.debug((Object)("Content of Vector is:" + vector));
            for (String string2 : vector) {
                logger.debug((Object)("Examining: " + string2));
                logger.debug((Object)("Looking for " + string));
                int n = signingPolicy.findIssuer(string);
                if (n == -1) {
                    string = PKIUtils.getOpenSSLFormatPrincipal(x509Certificate2.getSubjectDN(), true);
                    n = signingPolicy.findIssuer(string);
                }
                while (n != -1) {
                    logger.debug((Object)"Inside index");
                    signingPolicy.setCurrent(n);
                    if (signingPolicy.getAccessIDCA().equals(string)) {
                        Vector vector2 = signingPolicy.getCondSubjects();
                        for (String string3 : vector2) {
                            logger.debug((Object)("Comparing certSubj: '" + string2 + "' to '" + string3 + "'"));
                            string3 = string3.replaceFirst("\\*", "\\.\\*");
                            if (string2.toUpperCase().matches(string3.toUpperCase())) {
                                bl = true;
                                logger.debug((Object)("Subject: '" + string2 + "' matches with subject: '" + string3 + "' from signing policy."));
                                break;
                            }
                            logger.debug((Object)("Subject: '" + string2 + "' does not match subject: '" + string3 + "' from signing policy."));
                        }
                    }
                    n = signingPolicy.findIssuer(string, n);
                }
                if (!bl) continue;
                logger.debug((Object)"MATCHED AT LEAST ONCE");
                break;
            }
            vector.clear();
        }
        logger.debug((Object)("Value of Matched is: " + bl));
        return bl;
    }

    private Vector getAllNames(X509Certificate x509Certificate) {
        if (x509Certificate != null) {
            Vector<String> vector = new Vector<String>();
            vector.add(PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN()));
            vector.add(PKIUtils.getOpenSSLFormatPrincipal(x509Certificate.getSubjectDN(), true));
            return vector;
        }
        return null;
    }

    private boolean isRevoked(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Hashtable hashtable = this.caStore.getCRLs();
        Vector vector = (Vector)hashtable.get(PKIUtils.getHash(x509Certificate2));
        boolean bl = false;
        if (vector != null) {
            for (X509CRL x509CRL : vector) {
                Object object;
                if (x509CRL == null) continue;
                try {
                    x509CRL.verify(x509Certificate2.getPublicKey());
                }
                catch (Exception exception) {
                    continue;
                }
                Set<String> set = x509CRL.getCriticalExtensionOIDs();
                if (set == null || set.isEmpty()) {
                    if (x509CRL.getIssuerX500Principal().equals(x509Certificate2.getSubjectX500Principal())) {
                        if (x509CRL.getNextUpdate().compareTo(new Date()) >= 0 && x509CRL.getThisUpdate().compareTo(new Date()) <= 0) {
                            object = x509CRL.getRevokedCertificate(x509Certificate.getSerialNumber());
                            if (object == null) {
                                return false;
                            }
                        } else {
                            logger.error((Object)("CRL for CA '" + ((Object)x509Certificate2.getSubjectDN()).toString() + "' has expired!"));
                        }
                    }
                } else {
                    logger.error((Object)"Critical extension found in crl!");
                    object = set.iterator();
                    while (object.hasNext()) {
                        logger.debug((Object)("Critical CRL Extension: " + object.next()));
                    }
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

