/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.jce.X509Principal;
import org.glite.voms.PKIUtils;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.FullAttributes;

public class VOMSAttribute {
    private static Logger logger = Logger.getLogger(VOMSAttribute.class);
    private static final String VOMS_ATTR_OID = "1.3.6.1.4.1.8005.100.100.4";
    private AttributeCertificate myAC;
    private Vector myStringList = new Vector();
    private Vector myFQANs = new Vector();

    public byte[] getSignature() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getSignature();
    }

    public String getSerial() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getSerialNumber().getValue().toString();
    }

    private static Date convert(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat;
        if (string.indexOf("GMT") > 0) {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        } else {
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        return simpleDateFormat.parse(string);
    }

    public Date getNotAfter() throws ParseException {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        try {
            return this.myAC.getNotAfter();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate: " + parseException.getMessage());
        }
    }

    public Date getNotBefore() throws ParseException {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        try {
            return this.myAC.getNotBefore();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate: " + parseException.getMessage());
        }
    }

    public boolean validAt(Date date) {
        if (date == null) {
            date = new Date();
        }
        try {
            return this.getNotAfter().after(date) && this.getNotBefore().before(date);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate");
        }
    }

    public String getIssuer() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        X500Principal x500Principal = this.myAC.getIssuer();
        return x500Principal.getName();
    }

    public String getIssuerX509() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        X509Principal x509Principal = this.myAC.getIssuerX509();
        if (x509Principal != null) {
            return PKIUtils.getOpenSSLFormatPrincipal((Principal)x509Principal);
        }
        return null;
    }

    public String getHolder() {
        GeneralName generalName;
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        GeneralNames generalNames = this.myAC.getHolder().getIssuer();
        Enumeration enumeration = ((ASN1Sequence)generalNames.getDERObject()).getObjects();
        if (enumeration.hasMoreElements() && (generalName = GeneralName.getInstance((Object)((ASN1TaggedObject)enumeration.nextElement()))).getTagNo() == 4) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                new DEROutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)generalName.getName());
                X500Principal x500Principal = new X500Principal(byteArrayOutputStream.toByteArray());
                return x500Principal.getName();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public String getHolderX509() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHolderX509();
    }

    public boolean isValid() {
        return this.validAt(new Date());
    }

    public boolean isHolder(X509Certificate x509Certificate) {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHolder().isHolder(x509Certificate);
    }

    public boolean isIssuer(X509Certificate x509Certificate) {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getIssuer().equals(x509Certificate.getSubjectX500Principal());
    }

    public VOMSAttribute(AttributeCertificate attributeCertificate) {
        if (attributeCertificate == null) {
            throw new IllegalArgumentException("VOMSAttribute: AttributeCertificate is NULL");
        }
        this.myAC = attributeCertificate;
        List list = attributeCertificate.getAttributes(VOMS_ATTR_OID);
        if (list == null || list.size() == 0) {
            return;
        }
    }

    public AttributeCertificate getAC() {
        return this.privateGetAC();
    }

    AttributeCertificate privateGetAC() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC;
    }

    public List getFullyQualifiedAttributes() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getFullyQualifiedAttributes();
    }

    public List getListOfFQAN() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getListOfFQAN();
    }

    public String getHostPort() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHostPort();
    }

    public String getHost() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getHost();
    }

    public int getPort() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getPort();
    }

    public String getVO() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getVO();
    }

    public String toString() {
        return "VO      :" + this.getVO() + "\n" + "HostPort:" + this.getHostPort() + "\n" + "FQANs   :" + this.getListOfFQAN();
    }

    public FullAttributes getFullAttributes() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getFullAttributes();
    }

    public ACCerts getCertList() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getCertList();
    }

    public ACTargets getTargets() {
        if (this.myAC == null) {
            throw new IllegalArgumentException("No Attribute Certificate loaded.");
        }
        return this.myAC.getTargets();
    }
}

