/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.FileCertReader;
import org.glite.voms.PKIUtils;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSException;

public class VOMSKeyManager
implements X509KeyManager {
    private KeyManagerFactory keyManagerFactory = null;
    private X509KeyManager manager = null;
    private char[] passwd = null;
    private KeyStore keyStore = null;
    public static final int TYPE_PKCS12 = 1;
    public static final int TYPE_PEM = 2;
    private static final Logger logger = Logger.getLogger(PKIUtils.class);

    public VOMSKeyManager(String string, String string2, String string3) {
        this(string, string2, string3, 2);
    }

    public VOMSKeyManager(UserCredentials userCredentials) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, IOException, CertificateException {
        this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.keyStore = KeyStore.getInstance("JKS");
        this.keyStore.load(null, "".toCharArray());
        logger.debug((Object)"ABOUT to set key entry");
        this.keyStore.setKeyEntry("alias", userCredentials.getUserKey(), "".toCharArray(), userCredentials.getUserChain());
        logger.debug((Object)("STORETYPE: " + this.keyStore.getType()));
        this.keyManagerFactory.init(this.keyStore, "".toCharArray());
        this.manager = (X509KeyManager)this.keyManagerFactory.getKeyManagers()[0];
    }

    public VOMSKeyManager(String string, String string2, String string3, int n) {
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            this.passwd = string3.toCharArray();
            if (n == 2) {
                this.keyStore = KeyStore.getInstance("JKS");
                this.keyStore = this.load(string, string2, this.passwd);
            } else if (n == 1) {
                this.keyStore = KeyStore.getInstance("PKCS12", "SunJSSE");
                this.keyStore.load(new FileInputStream(string), this.passwd);
            }
            this.keyManagerFactory.init(this.keyStore, this.passwd);
            this.manager = (X509KeyManager)this.keyManagerFactory.getKeyManagers()[0];
        }
        catch (Exception exception) {
            throw new VOMSException("Cannot initialize VOMSKeyManager: ", exception);
        }
    }

    private KeyStore createKeyStore(String string, String string2, char[] cArray) throws CertificateException, IOException {
        FileCertReader fileCertReader = new FileCertReader();
        Certificate[] certificateArray = (X509Certificate[])fileCertReader.readCerts(string).toArray();
        PrivateKey privateKey = null;
        KeyStore keyStore = null;
        try {
            privateKey = string2 != null ? fileCertReader.readPrivateKey(string) : fileCertReader.readPrivateKey(string2);
        }
        catch (IOException iOException) {
            throw new VOMSException("Cannot load the private key.", iOException);
        }
        try {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.setKeyEntry("alias", privateKey, cArray, certificateArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw new VOMSException("Cannot load the key pair.", keyStoreException);
        }
        return keyStore;
    }

    private KeyStore load(String string, String string2, char[] cArray) throws CertificateException, IOException {
        KeyStore keyStore = null;
        keyStore = string != string2 ? this.createKeyStore(string, string2, cArray) : this.createKeyStore(string, string, cArray);
        return keyStore;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.manager.chooseClientAlias(stringArray, principalArray, socket);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.manager.chooseServerAlias(string, principalArray, socket);
    }

    public X509Certificate[] getCertificateChain(String string) {
        return this.manager.getCertificateChain(string);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.manager.getClientAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.manager.getServerAliases(string, principalArray);
    }

    public PrivateKey getPrivateKey(String string) {
        return this.manager.getPrivateKey(string);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

