/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIVerifier;

public class VOMSTrustManager
implements X509TrustManager {
    private PKIStore store = null;
    private PKIVerifier verifier = null;
    private static Logger logger = Logger.getLogger((String)VOMSTrustManager.class.getName());

    public VOMSTrustManager(String string) throws IOException, CertificateException, CRLException {
        this.verifier = new PKIVerifier();
        this.store = new PKIStore(string, 2);
        this.verifier.setCAStore(this.store);
    }

    public VOMSTrustManager(PKIStore pKIStore) throws IOException, CertificateException, CRLException {
        this.verifier = new PKIVerifier(null, pKIStore);
        this.store = pKIStore;
    }

    public void stop() {
        this.verifier.cleanup();
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (x509CertificateArray == null || string == null || x509CertificateArray.length == 0 || string.length() == 0) {
            throw new IllegalArgumentException("One of the parameters is null or empty.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Callying verify:");
            logger.debug((Object)"chain is:");
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                logger.debug((Object)("HAVE TO VERIFY: " + x509CertificateArray[i].getSubjectDN()));
            }
        }
        if (this.verifier.verify(x509CertificateArray)) {
            return;
        }
        throw new CertificateException("Cannot verify certificate.  See log for details.");
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkClientTrusted(x509CertificateArray, string);
    }

    public X509Certificate[] getAcceptedIssuers() {
        Hashtable hashtable = this.store.getCAs();
        return (X509Certificate[])hashtable.values().toArray();
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

