/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class ProxyPolicy
implements DEREncodable {
    private DERObjectIdentifier oid;
    private DEROctetString policy;
    public static final DERObjectIdentifier IMPERSONATION = new DERObjectIdentifier("1.3.6.1.5.5.7.21.1");
    public static final DERObjectIdentifier INDEPENDENT = new DERObjectIdentifier("1.3.6.1.5.5.7.21.2");
    public static final DERObjectIdentifier LIMITED = new DERObjectIdentifier("1.3.6.1.4.1.3536.1.1.1.9");

    public ProxyPolicy(DERObjectIdentifier dERObjectIdentifier) {
        this.oid = dERObjectIdentifier;
        this.policy = null;
    }

    public ProxyPolicy(DERObjectIdentifier dERObjectIdentifier, String string) {
        this.oid = dERObjectIdentifier;
        this.policy = new DEROctetString(string.getBytes());
    }

    public ProxyPolicy(String string, String string2) {
        this.oid = new DERObjectIdentifier(string);
        this.policy = new DEROctetString(string2.getBytes());
    }

    public ProxyPolicy(String string) {
        this.oid = new DERObjectIdentifier(string);
        this.policy = null;
    }

    public DERObject getDERObject() {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        dEREncodableVector.add((DEREncodable)this.oid);
        if (this.policy != null) {
            dEREncodableVector.add((DEREncodable)this.policy);
        }
        return new DERSequence(dEREncodableVector);
    }

    public ProxyPolicy(ASN1Sequence aSN1Sequence) {
        this.oid = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            DEREncodable dEREncodable = aSN1Sequence.getObjectAt(1);
            if (dEREncodable instanceof DERTaggedObject) {
                dEREncodable = ((DERTaggedObject)dEREncodable).getObject();
            }
            this.policy = (DEROctetString)dEREncodable;
        }
    }
}

