/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact.cli;

import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSProxyInit;
import org.glite.voms.contact.VOMSRequestOptions;

public class VomsProxyInitClient {
    private static final Logger log = Logger.getLogger(VomsProxyInitClient.class);
    protected VOMSProxyInit proxyInit;
    protected CommandLineParser parser = new GnuParser();
    protected HelpFormatter helpFormatter = new HelpFormatter();
    protected Options options;
    String[] fqans;
    String targets;
    String ordering;
    int lifetime;
    String proxyOutput;
    String keyPassword;
    String proxyType;
    String delegationType;
    String policyType;

    protected void setupUserCredentials(String string, String string2) {
        System.setProperty("X509_USER_CERT", string);
        System.setProperty("X509_USER_KEY", string2);
    }

    protected void setupVomsesPath(String string) {
        System.setProperty("VOMSES_LOCATION", string);
    }

    protected void setupVomsdir(String string) {
        System.setProperty("VOMSDIR", string);
    }

    protected void setupCaDir(String string) {
        System.setProperty("CADIR", string);
    }

    protected void setupCLParser() {
        this.options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Displays helps and exits.");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"vomsdir");
        OptionBuilder.withDescription((String)"Specifies non-standard vomsdir directory.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"vomsdir"));
        OptionBuilder.withLongOpt((String)"cadir");
        OptionBuilder.withDescription((String)"Specifies non-standard ca certificate directory.");
        OptionBuilder.hasArg((boolean)true);
        this.options.addOption(OptionBuilder.create((String)"cadir"));
        OptionBuilder.withLongOpt((String)"vomsesPath");
        OptionBuilder.withDescription((String)"Specifies non-standard locations where the voms-proxy-init looks for vomses files. The path is a colon (:) separated list of paths.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"vomsesPath"));
        OptionBuilder.withLongOpt((String)"usercert");
        OptionBuilder.withDescription((String)"Specifies non-standard user certificate.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"usercert"));
        OptionBuilder.withLongOpt((String)"userkey");
        OptionBuilder.withDescription((String)"Specifies non-standard user private key.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"userkey"));
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.withDescription((String)"Specifies a password that is used to decrypt the user's private key.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"password"));
        OptionBuilder.withLongOpt((String)"lifetime");
        OptionBuilder.withDescription((String)"Specifies the lifetime for the generated proxy.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"lifetime"));
        OptionBuilder.withLongOpt((String)"out");
        OptionBuilder.withDescription((String)"Specifies a non-standard location for the generated proxy. The standard location is /tmp/X509_up_<username>.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"out"));
        OptionBuilder.withLongOpt((String)"order");
        OptionBuilder.withDescription((String)"Specifies the ordering of received attributes. The options is a comma (,) separated list of FQANs.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"order"));
        OptionBuilder.withLongOpt((String)"voms");
        OptionBuilder.withDescription((String)"Specifies a request FQAN in the form: <voName>:<FQAN>.");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"voms"));
        OptionBuilder.withLongOpt((String)"targets");
        OptionBuilder.withDescription((String)"Targets the AC against a specific comma separated list of hostnames.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"targets"));
        OptionBuilder.withLongOpt((String)"proxyType");
        OptionBuilder.withDescription((String)"Specifies the type of proxy that will be generated. Possible values are: GT2_PROXY, GT3_PROXY, GT4_PROXY. The default value is GT2_PROXY.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"proxyType"));
        OptionBuilder.withLongOpt((String)"policyType");
        OptionBuilder.withDescription((String)"Specifies the policy type of the proxy.  Only significant with proxyType >= GT3_PROXY.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"policyType"));
        OptionBuilder.withLongOpt((String)"delegationType");
        OptionBuilder.withDescription((String)"Specifies the type of delegation requested for the generated proxy. Possible values are: NONE, LIMITED, FULL. The default value is FULL.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"delegationType"));
    }

    protected void printHelpMessageAndExit(int n) {
        this.helpFormatter.printHelp("VomsProxyInit", this.options);
        System.exit(n);
    }

    protected void getArguments(String[] stringArray) {
        try {
            CommandLine commandLine = this.parser.parse(this.options, stringArray);
            if (commandLine.hasOption("h")) {
                this.printHelpMessageAndExit(0);
            }
            if (commandLine.hasOption("vomsdir")) {
                this.setupVomsdir(commandLine.getOptionValue("vomsdir"));
            }
            if (commandLine.hasOption("cadir")) {
                this.setupCaDir(commandLine.getOptionValue("cadir"));
            }
            if (commandLine.hasOption("vomsesPath")) {
                this.setupVomsesPath(commandLine.getOptionValue("vomsesPath"));
            }
            if (commandLine.hasOption("usercert") && commandLine.hasOption("userkey")) {
                this.setupUserCredentials(commandLine.getOptionValue("usercert"), commandLine.getOptionValue("userkey"));
            }
            if (commandLine.hasOption("out")) {
                this.proxyOutput = commandLine.getOptionValue("out");
            }
            if (commandLine.hasOption("order")) {
                this.ordering = commandLine.getOptionValue("order");
            }
            if (commandLine.hasOption("targets")) {
                this.targets = commandLine.getOptionValue("targets");
            }
            if (commandLine.hasOption("lifetime")) {
                this.lifetime = Integer.parseInt(commandLine.getOptionValue("lifetime"));
            }
            if (commandLine.hasOption("voms")) {
                this.fqans = commandLine.getOptionValues("voms");
            }
            if (commandLine.hasOption("password")) {
                this.keyPassword = commandLine.getOptionValue("password");
            }
            if (commandLine.hasOption("proxyType")) {
                this.proxyType = commandLine.getOptionValue("proxyType");
            }
            if (commandLine.hasOption("policyType")) {
                this.policyType = commandLine.getOptionValue("policyType");
            }
            if (commandLine.hasOption("delegationType")) {
                this.delegationType = commandLine.getOptionValue("delegationType");
            }
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            this.helpFormatter.printHelp("VomsProxyInit", this.options);
            System.exit(-1);
        }
    }

    protected void buildProxy() {
        int n;
        if (this.keyPassword != null) {
            this.proxyInit = VOMSProxyInit.instance(this.keyPassword);
        } else {
            log.warn((Object)"No password given to decrypt the openssl private key...");
            this.proxyInit = VOMSProxyInit.instance();
        }
        if (this.proxyOutput != null) {
            this.proxyInit.setProxyOutputFile(this.proxyOutput);
        }
        if (this.proxyType != null) {
            n = 2;
            if (this.proxyType.equals("GT2_PROXY")) {
                n = 2;
            } else if (this.proxyType.equals("GT3_PROXY")) {
                n = 3;
            } else if (this.proxyType.equals("GT4_PROXY")) {
                n = 4;
            } else {
                log.warn((Object)"Unsupported proxy type specified! The default value will be used.");
            }
            this.proxyInit.setProxyType(n);
        }
        if (this.policyType != null) {
            this.proxyInit.setPolicyType(this.policyType);
        }
        if (this.delegationType != null) {
            n = 0;
            if (this.delegationType.equals("NONE")) {
                n = 8;
            } else if (this.delegationType.equals("LIMITED")) {
                n = 1;
            } else if (this.delegationType.equals("FULL")) {
                n = 0;
            } else {
                log.warn((Object)"Unsupported delegation type specified! The default value will be used.");
            }
            this.proxyInit.setDelegationType(n);
        }
        log.debug((Object)("fqans:" + ToStringBuilder.reflectionToString((Object)this.fqans)));
        if (this.fqans == null) {
            this.proxyInit.getVomsProxy();
        } else {
            HashMap<String, VOMSRequestOptions> hashMap = new HashMap<String, VOMSRequestOptions>();
            for (int i = 0; i < this.fqans.length; ++i) {
                VOMSRequestOptions vOMSRequestOptions;
                String[] stringArray = this.fqans[i].split(":");
                if (stringArray.length != 2) {
                    throw new VOMSException("Voms FQANs must be specified according to the <voName>:<fqan> syntax (e.g., cms:/cms/Role=lcgadmin).");
                }
                String string = stringArray[0];
                if (hashMap.containsKey(string)) {
                    vOMSRequestOptions = (VOMSRequestOptions)hashMap.get(string);
                } else {
                    vOMSRequestOptions = new VOMSRequestOptions();
                    vOMSRequestOptions.setVoName(string);
                    hashMap.put(string, vOMSRequestOptions);
                }
                vOMSRequestOptions.addFQAN(stringArray[1]);
                if (this.ordering == null) continue;
                vOMSRequestOptions.setOrdering(this.ordering);
            }
            this.proxyInit.getVomsProxy(hashMap.values());
        }
    }

    public VomsProxyInitClient(String[] stringArray) {
        this.setupCLParser();
        this.getArguments(stringArray);
        this.buildProxy();
    }

    public static void main(String[] stringArray) {
        new VomsProxyInitClient(stringArray);
    }
}

