/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

public final class Engine
implements AutoCloseable {
    final AbstractPolyglotImpl.AbstractEngineImpl impl;
    private static final Engine EMPTY = new Engine(null);
    private static final boolean JDK8_OR_EARLIER = System.getProperty("java.specification.version").compareTo("1.9") < 0;

    Engine(AbstractPolyglotImpl.AbstractEngineImpl impl) {
        this.impl = impl;
    }

    public Map<String, Language> getLanguages() {
        return this.impl.getLanguages();
    }

    public Map<String, Instrument> getInstruments() {
        return this.impl.getInstruments();
    }

    public OptionDescriptors getOptions() {
        return this.impl.getOptions();
    }

    public String getVersion() {
        return this.impl.getVersion();
    }

    public void close(boolean cancelIfExecuting) {
        this.impl.ensureClosed(cancelIfExecuting, false);
    }

    @Override
    public void close() {
        this.close(false);
    }

    public String getImplementationName() {
        return this.impl.getImplementationName();
    }

    public static Engine create() {
        return Engine.newBuilder().build();
    }

    public static Builder newBuilder() {
        return EMPTY.new Builder();
    }

    static AbstractPolyglotImpl getImpl() {
        return ImplHolder.IMPL;
    }

    static Class<?> loadLanguageClass(String className) {
        return Engine.getImpl().loadLanguageClass(className);
    }

    private static AbstractPolyglotImpl initEngineImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<AbstractPolyglotImpl>(){

            @Override
            public AbstractPolyglotImpl run() {
                AbstractPolyglotImpl engine = null;
                Class<?> servicesClass = null;
                if (JDK8_OR_EARLIER) {
                    try {
                        servicesClass = Class.forName("jdk.vm.ci.services.Services");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (servicesClass != null) {
                        try {
                            Method m = servicesClass.getDeclaredMethod("loadSingle", Class.class, Boolean.TYPE);
                            engine = (AbstractPolyglotImpl)m.invoke(null, AbstractPolyglotImpl.class, false);
                        }
                        catch (Throwable e) {
                            throw new InternalError(e);
                        }
                    }
                } else {
                    Iterator<AbstractPolyglotImpl> providers = ServiceLoader.load(AbstractPolyglotImpl.class).iterator();
                    if (providers.hasNext()) {
                        engine = providers.next();
                        if (providers.hasNext()) {
                            throw new InternalError(String.format("Multiple %s providers found", AbstractPolyglotImpl.class.getName()));
                        }
                    }
                }
                if (engine == null) {
                    try {
                        Class<AbstractPolyglotImpl> polyglotClass = Class.forName("com.oracle.truffle.api.vm.PolyglotImpl").asSubclass(AbstractPolyglotImpl.class);
                        Constructor<AbstractPolyglotImpl> constructor = polyglotClass.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        engine = constructor.newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException polyglotClass) {
                    }
                    catch (Exception e1) {
                        throw new InternalError(e1);
                    }
                }
                if (engine == null) {
                    engine = Engine.createInvalidPolyglotImpl();
                }
                if (engine != null) {
                    engine.setConstructors(new APIAccessImpl());
                }
                return engine;
            }
        });
    }

    static AbstractPolyglotImpl createInvalidPolyglotImpl() {
        return new PolyglotInvalid();
    }

    static /* synthetic */ AbstractPolyglotImpl access$000() {
        return Engine.initEngineImpl();
    }

    private static class PolyglotInvalid
    extends AbstractPolyglotImpl {
        private final EmptySource source = new EmptySource(this);
        static boolean AOT;

        private PolyglotInvalid() {
        }

        @Override
        public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> arguments, long timeout, TimeUnit timeoutUnit, boolean sandbox, long maximumAllowedAllocationBytes, boolean useSystemProperties, boolean boundEngine) {
            throw PolyglotInvalid.noPolyglotImplementationFound();
        }

        private static RuntimeException noPolyglotImplementationFound() {
            String suggestion = AOT ? "Make sure a language is added to the classpath (e.g., native-image --js)." : "Make sure the truffle-api.jar is on the classpath.";
            return new IllegalStateException("No language and polyglot implementation was found on the classpath. " + suggestion);
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceImpl getSourceImpl() {
            return this.source;
        }

        @Override
        public AbstractPolyglotImpl.AbstractSourceSectionImpl getSourceSectionImpl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> loadLanguageClass(String className) {
            return null;
        }

        @Override
        public void preInitializeEngine() {
        }

        @Override
        public void resetPreInitializedEngine() {
        }

        static {
            Boolean aot = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("com.oracle.graalvm.isaot");
                }
            });
            AOT = aot;
        }

        static class EmptySource
        extends AbstractPolyglotImpl.AbstractSourceImpl {
            protected EmptySource(AbstractPolyglotImpl engineImpl) {
                super(engineImpl);
            }

            @Override
            public Source build(String language, Object origin, URI uri, String name, CharSequence content, boolean interactive, boolean internal) throws IOException {
                throw PolyglotInvalid.noPolyglotImplementationFound();
            }

            @Override
            public String findLanguage(File file) throws IOException {
                return null;
            }

            @Override
            public String findLanguage(String mimeType) {
                return null;
            }

            @Override
            public String getName(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getPath(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInteractive(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public URL getURL(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public URI getURI(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Reader getReader(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLength(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getCode(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getCode(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineCount(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineNumber(Object impl, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getColumnNumber(Object impl, int offset) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineStartOffset(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getLineLength(Object impl, int lineNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toString(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode(Object impl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object impl, Object otherImpl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isInternal(Object impl) {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class APIAccessImpl
    extends AbstractPolyglotImpl.APIAccess {
        APIAccessImpl() {
        }

        @Override
        public Engine newEngine(AbstractPolyglotImpl.AbstractEngineImpl impl) {
            return new Engine(impl);
        }

        @Override
        public AbstractPolyglotImpl.AbstractExceptionImpl getImpl(PolyglotException value) {
            return value.impl;
        }

        @Override
        public Context newContext(AbstractPolyglotImpl.AbstractContextImpl impl) {
            return new Context(impl);
        }

        @Override
        public PolyglotException newLanguageException(String message, AbstractPolyglotImpl.AbstractExceptionImpl impl) {
            return new PolyglotException(message, impl);
        }

        @Override
        public Language newLanguage(AbstractPolyglotImpl.AbstractLanguageImpl impl) {
            return new Language(impl);
        }

        @Override
        public Instrument newInstrument(AbstractPolyglotImpl.AbstractInstrumentImpl impl) {
            return new Instrument(impl);
        }

        @Override
        public Value newValue(Object value, AbstractPolyglotImpl.AbstractValueImpl impl) {
            return new Value(impl, value);
        }

        @Override
        public Source newSource(String language, Object impl) {
            return new Source(language, impl);
        }

        @Override
        public SourceSection newSourceSection(Source source, Object impl) {
            return new SourceSection(source, impl);
        }

        @Override
        public AbstractPolyglotImpl.AbstractValueImpl getImpl(Value value) {
            return value.impl;
        }

        @Override
        public AbstractPolyglotImpl.AbstractInstrumentImpl getImpl(Instrument value) {
            return value.impl;
        }

        @Override
        public AbstractPolyglotImpl.AbstractLanguageImpl getImpl(Language value) {
            return value.impl;
        }

        @Override
        public AbstractPolyglotImpl.AbstractStackFrameImpl getImpl(PolyglotException.StackFrame value) {
            return value.impl;
        }

        @Override
        public Object getReceiver(Value value) {
            return value.receiver;
        }

        @Override
        public PolyglotException.StackFrame newPolyglotStackTraceElement(PolyglotException e, AbstractPolyglotImpl.AbstractStackFrameImpl impl) {
            PolyglotException polyglotException = e;
            polyglotException.getClass();
            return new PolyglotException.StackFrame(polyglotException, impl);
        }
    }

    public final class Builder {
        private OutputStream out = System.out;
        private OutputStream err = System.err;
        private InputStream in = System.in;
        private Map<String, String> options = new HashMap<String, String>();
        private boolean useSystemProperties = true;
        private boolean boundEngine;

        Builder() {
        }

        Builder setBoundEngine(boolean boundEngine) {
            this.boundEngine = boundEngine;
            return this;
        }

        public Builder out(OutputStream out) {
            Objects.requireNonNull(out);
            this.out = out;
            return this;
        }

        public Builder err(OutputStream err) {
            Objects.requireNonNull(err);
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            Objects.requireNonNull(in);
            this.in = in;
            return this;
        }

        public Builder useSystemProperties(boolean enabled) {
            this.useSystemProperties = enabled;
            return this;
        }

        public Builder option(String key, String value) {
            Objects.requireNonNull(key, "Key must not be null.");
            Objects.requireNonNull(value, "Value must not be null.");
            this.options.put(key, value);
            return this;
        }

        public Builder options(Map<String, String> options) {
            for (String key : options.keySet()) {
                Objects.requireNonNull(options.get(key), "All option values must be non-null.");
            }
            this.options.putAll(options);
            return this;
        }

        public Engine build() {
            AbstractPolyglotImpl loadedImpl = Engine.getImpl();
            if (loadedImpl == null) {
                throw new IllegalStateException("The Polyglot API implementation failed to load.");
            }
            return loadedImpl.buildEngine(this.out, this.err, this.in, this.options, 0L, null, false, 0L, this.useSystemProperties, this.boundEngine);
        }
    }

    private static final class ImplHolder {
        private static final AbstractPolyglotImpl IMPL = Engine.access$000();

        private ImplHolder() {
        }

        private static void preInitializeEngine() {
            IMPL.preInitializeEngine();
        }

        private static void resetPreInitializedEngine() {
            IMPL.resetPreInitializedEngine();
        }
    }
}

