// CheckStyle: start generated
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.IntField;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import java.lang.invoke.MethodHandles;

/**
 * Debug Info: <pre>
 *   Specialization {@link IfNode#doBoolean}
 *     Activation probability: 0.65000
 *     With/without class size: 14/0 bytes
 *   Specialization {@link IfNode#doObject}
 *     Activation probability: 0.35000
 *     With/without class size: 12/6 bytes
 * </pre>
 */
@GeneratedBy(IfNode.class)
@SuppressWarnings("javadoc")
public final class IfNodeGen extends IfNode {

    private static final StateField STATE_0_IfNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    /**
     * Source Info: <pre>
     *   Specialization: {@link IfNode#doBoolean}
     *   Parameter: {@link InlinedCountingConditionProfile} conditionProfile
     *   Inline method: {@link InlinedCountingConditionProfile#inline}</pre>
     */
    private static final InlinedCountingConditionProfile INLINED_CONDITION_PROFILE = InlinedCountingConditionProfile.inline(InlineTarget.create(InlinedCountingConditionProfile.class, IntField.create(MethodHandles.lookup(), "conditionProfile_field0_"), IntField.create(MethodHandles.lookup(), "conditionProfile_field1_")));
    /**
     * Source Info: <pre>
     *   Specialization: {@link IfNode#doObject}
     *   Parameter: {@link JSToBooleanNode} toBooleanNode
     *   Inline method: {@link JSToBooleanNodeGen#inline}</pre>
     */
    private static final JSToBooleanNode INLINED_OBJECT_TO_BOOLEAN_NODE_ = JSToBooleanNodeGen.inline(InlineTarget.create(JSToBooleanNode.class, STATE_0_IfNode_UPDATER.subUpdater(2, 15), ReferenceField.create(MethodHandles.lookup(), "object_toBooleanNode__field1_", Node.class)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link IfNode#doBoolean}
     *   1: SpecializationActive {@link IfNode#doObject}
     *   2-16: InlinedCache
     *        Specialization: {@link IfNode#doObject}
     *        Parameter: {@link JSToBooleanNode} toBooleanNode
     *        Inline method: {@link JSToBooleanNodeGen#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link IfNode#doBoolean}
     *   Parameter: {@link InlinedCountingConditionProfile} conditionProfile
     *   Inline method: {@link InlinedCountingConditionProfile#inline}
     *   Inline field: int field0</pre>
     */
    @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int conditionProfile_field0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link IfNode#doBoolean}
     *   Parameter: {@link InlinedCountingConditionProfile} conditionProfile
     *   Inline method: {@link InlinedCountingConditionProfile#inline}
     *   Inline field: int field1</pre>
     */
    @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private int conditionProfile_field1_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link IfNode#doObject}
     *   Parameter: {@link JSToBooleanNode} toBooleanNode
     *   Inline method: {@link JSToBooleanNodeGen#inline}
     *   Inline field: {@link Node} field1</pre>
     */
    @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node object_toBooleanNode__field1_;

    private IfNodeGen(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        super(condition, thenPart, elsePart);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] */ && ((state_0 & 0b11) != 0  /* is-not SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] && SpecializationActive[IfNode.doObject(VirtualFrame, Object, JSToBooleanNode, InlinedCountingConditionProfile)] */)) {
            return execute_boolean0(state_0, frameValue);
        } else {
            return execute_generic1(state_0, frameValue);
        }
    }

    private Object execute_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean conditionValue_;
        try {
            conditionValue_ = super.condition.executeBoolean(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, ex.getResult());
        }
        assert (state_0 & 0b1) != 0 /* is SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] */;
        return doBoolean(frameValue, conditionValue_, INLINED_CONDITION_PROFILE);
    }

    private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object conditionValue_ = super.condition.execute(frameValue);
        if ((state_0 & 0b11) != 0 /* is SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] || SpecializationActive[IfNode.doObject(VirtualFrame, Object, JSToBooleanNode, InlinedCountingConditionProfile)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] */ && conditionValue_ instanceof Boolean) {
                boolean conditionValue__ = (boolean) conditionValue_;
                return doBoolean(frameValue, conditionValue__, INLINED_CONDITION_PROFILE);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[IfNode.doObject(VirtualFrame, Object, JSToBooleanNode, InlinedCountingConditionProfile)] */) {
                return doObject(frameValue, conditionValue_, INLINED_OBJECT_TO_BOOLEAN_NODE_, INLINED_CONDITION_PROFILE);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, conditionValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object conditionValue) {
        int state_0 = this.state_0_;
        if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[IfNode.doObject(VirtualFrame, Object, JSToBooleanNode, InlinedCountingConditionProfile)] */ && conditionValue instanceof Boolean) {
            boolean conditionValue_ = (boolean) conditionValue;
            state_0 = state_0 | 0b1 /* add SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] */;
            this.state_0_ = state_0;
            return doBoolean(frameValue, conditionValue_, INLINED_CONDITION_PROFILE);
        }
        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[IfNode.doBoolean(VirtualFrame, boolean, InlinedCountingConditionProfile)] */;
        state_0 = state_0 | 0b10 /* add SpecializationActive[IfNode.doObject(VirtualFrame, Object, JSToBooleanNode, InlinedCountingConditionProfile)] */;
        this.state_0_ = state_0;
        return doObject(frameValue, conditionValue, INLINED_OBJECT_TO_BOOLEAN_NODE_, INLINED_CONDITION_PROFILE);
    }

    @NeverDefault
    public static IfNode create(JavaScriptNode condition, JavaScriptNode thenPart, JavaScriptNode elsePart) {
        return new IfNodeGen(condition, thenPart, elsePart);
    }

}
