/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.temporal.ObjectImplementsTemporalTimeZoneProtocolNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalTimeZoneSlotValueNode
extends JavaScriptBaseNode {
    protected ToTemporalTimeZoneSlotValueNode() {
    }

    public abstract Object execute(Object var1);

    @Specialization
    protected Object toTemporalTimeZoneSlotValue(Object temporalTimeZoneLike, @Cached IsObjectNode isObjectNode, @Cached ObjectImplementsTemporalTimeZoneProtocolNode objectImplementsTimeZoneProtocol, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isTimeZoneProfile) {
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(temporalTimeZoneLike))) {
            if (isTimeZoneProfile.profile((Node)this, TemporalUtil.isTemporalZonedDateTime(temporalTimeZoneLike))) {
                return ((JSTemporalZonedDateTimeObject)((Object)temporalTimeZoneLike)).getTimeZone();
            }
            if (objectImplementsTimeZoneProtocol.execute(temporalTimeZoneLike)) {
                return temporalTimeZoneLike;
            }
            errorBranch.enter((Node)this);
            throw TemporalErrors.createTypeErrorTemporalTimeZoneExpected();
        }
        if (temporalTimeZoneLike instanceof TruffleString) {
            TruffleString identifier = (TruffleString)temporalTimeZoneLike;
            JSTemporalTimeZoneRecord parseResult = TemporalUtil.parseTemporalTimeZoneString(identifier);
            TruffleString offsetMinutes = parseResult.getOffsetString();
            TruffleString name = parseResult.getName();
            if (offsetMinutes != null && name == null) {
                return TemporalUtil.formatTimeZoneOffsetString(TemporalUtil.parseTimeZoneOffsetString(offsetMinutes));
            }
            TruffleString timeZoneName = TemporalUtil.canonicalizeTimeZoneName(name);
            if (timeZoneName == null) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
            }
            return timeZoneName;
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(temporalTimeZoneLike);
    }
}

