/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;

public abstract class InvokeTypeFlow
extends TypeFlow<BytecodePosition>
implements InvokeInfo {
    protected final TypeFlow<?>[] actualParameters;
    protected volatile ActualReturnTypeFlow actualReturn;
    protected final InvokeTypeFlow originalInvoke;
    protected final AnalysisType receiverType;
    protected final PointsToAnalysisMethod targetMethod;
    protected boolean isContextInsensitive;
    protected final MultiMethod.MultiMethodKey callerMultiMethodKey;
    protected volatile boolean allOriginalCallees = true;

    protected InvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        super(invokeLocation, null);
        this.originalInvoke = null;
        this.receiverType = receiverType;
        this.targetMethod = targetMethod;
        this.actualParameters = actualParameters;
        this.actualReturn = actualReturn;
        this.callerMultiMethodKey = callerMultiMethodKey;
        this.getTargetMethod().registerAsInvoked(this);
    }

    protected InvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, InvokeTypeFlow original) {
        super(original, methodFlows);
        this.originalInvoke = original;
        this.receiverType = original.receiverType;
        this.targetMethod = original.targetMethod;
        this.callerMultiMethodKey = original.callerMultiMethodKey;
        this.actualReturn = original.getActualReturn() != null ? (ActualReturnTypeFlow)methodFlows.lookupCloneOf(bb, original.getActualReturn()) : null;
        this.actualParameters = new TypeFlow[original.actualParameters.length];
        for (int i = 0; i < original.actualParameters.length; ++i) {
            if (original.getActualParameter(i) == null) continue;
            this.actualParameters[i] = methodFlows.lookupCloneOf(bb, original.getActualParameter(i));
        }
    }

    public void markAsContextInsensitive() {
        this.isContextInsensitive = true;
    }

    @Override
    public boolean isContextInsensitive() {
        return this.isContextInsensitive;
    }

    public AnalysisType getReceiverType() {
        return this.receiverType;
    }

    @Override
    public PointsToAnalysisMethod getTargetMethod() {
        return this.targetMethod;
    }

    public int actualParametersCount() {
        return this.actualParameters.length;
    }

    public TypeFlow<?>[] getActualParameters() {
        return this.actualParameters;
    }

    public TypeFlow<?> getReceiver() {
        return this.actualParameters[0];
    }

    public InvokeTypeFlow getOriginalInvoke() {
        return this.originalInvoke;
    }

    @Override
    public void setObserved(TypeFlow<?> newReceiver) {
        this.actualParameters[0] = newReceiver;
    }

    public TypeFlow<?> getActualParameter(int index) {
        return this.actualParameters[index];
    }

    public TypeFlow<?> getActualReturn() {
        return this.actualReturn;
    }

    public void setActualReturn(PointsToAnalysis bb, boolean isStatic, ActualReturnTypeFlow actualReturn) {
        assert (this.actualReturn == null);
        this.actualReturn = actualReturn;
        bb.analysisPolicy().linkActualReturn(bb, isStatic, this);
    }

    public TypeFlow<?> getResult() {
        return this.actualReturn;
    }

    protected TypeState filterReceiverState(PointsToAnalysis bb, TypeState receiverState) {
        if (bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return TypeState.forIntersection(bb, receiverState, this.receiverType.getAssignableTypes(true));
        }
        assert (this.verifyAllAssignable(bb, receiverState));
        return receiverState;
    }

    private boolean verifyAllAssignable(BigBang bb, TypeState receiverState) {
        for (AnalysisType type : receiverState.types(bb)) {
            if (this.receiverType.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    protected void updateReceiver(PointsToAnalysis bb, MethodFlowsGraphInfo calleeFlows, AnalysisObject receiverObject) {
        SingleTypeState receiverTypeState = TypeState.forExactType(bb, receiverObject, false);
        this.updateReceiver(bb, calleeFlows, receiverTypeState);
    }

    protected void updateReceiver(PointsToAnalysis bb, MethodFlowsGraphInfo calleeFlows, TypeState receiverTypeState) {
        FormalReceiverTypeFlow formalReceiverFlow;
        if (bb.getHostVM().getMultiMethodAnalysisPolicy().performParameterLinking(this.callerMultiMethodKey, calleeFlows.getMethod().getMultiMethodKey()) && (formalReceiverFlow = calleeFlows.getFormalReceiver()) != null) {
            formalReceiverFlow.addReceiverState(bb, receiverTypeState);
        }
        if (bb.getHostVM().getMultiMethodAnalysisPolicy().performReturnLinking(this.callerMultiMethodKey, calleeFlows.getMethod().getMultiMethodKey()) && bb.optimizeReturnedParameter()) {
            int paramIndex = calleeFlows.getMethod().getTypeFlow().getReturnedParameterIndex();
            if (this.actualReturn != null && paramIndex == 0) {
                this.actualReturn.addState(bb, receiverTypeState);
            }
        }
    }

    protected void linkCallee(PointsToAnalysis bb, boolean isStatic, MethodFlowsGraphInfo calleeFlows) {
        if (bb.getHostVM().getMultiMethodAnalysisPolicy().performParameterLinking(this.callerMultiMethodKey, calleeFlows.getMethod().getMultiMethodKey())) {
            for (int i = 0; i < this.actualParameters.length; ++i) {
                TypeFlow<BytecodePosition> actualParam = this.actualParameters[i];
                FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
                if (actualParam == null || formalParam == null) continue;
                actualParam.addUse(bb, formalParam);
            }
        }
        this.linkReturn(bb, isStatic, calleeFlows);
        if (!calleeFlows.isStub()) {
            bb.analysisPolicy().registerAsImplementationInvoked(this, calleeFlows.getMethod());
        }
    }

    public void linkReturn(PointsToAnalysis bb, boolean isStatic, MethodFlowsGraphInfo calleeFlows) {
        if (this.actualReturn != null && bb.getHostVM().getMultiMethodAnalysisPolicy().performReturnLinking(this.callerMultiMethodKey, calleeFlows.getMethod().getMultiMethodKey())) {
            if (bb.optimizeReturnedParameter()) {
                int paramNodeIndex = calleeFlows.getMethod().getTypeFlow().getReturnedParameterIndex();
                if (paramNodeIndex != -1) {
                    if (isStatic || paramNodeIndex != 0) {
                        TypeFlow<BytecodePosition> actualParam = this.actualParameters[paramNodeIndex];
                        actualParam.addUse(bb, this.actualReturn);
                    }
                } else if (calleeFlows.getReturnFlow() != null) {
                    calleeFlows.getReturnFlow().addUse(bb, this.actualReturn);
                }
            } else if (calleeFlows.getReturnFlow() != null) {
                calleeFlows.getReturnFlow().addUse(bb, this.actualReturn);
            }
        }
    }

    public static boolean isContextInsensitiveVirtualInvoke(InvokeTypeFlow invoke) {
        return invoke instanceof AbstractVirtualInvokeTypeFlow && invoke.isContextInsensitive();
    }

    @Override
    public Collection<AnalysisMethod> getOriginalCallees() {
        if (this.allOriginalCallees) {
            return this.getAllCallees();
        }
        return this.getAllCallees().stream().filter(callee -> {
            boolean originalMethod = callee.isOriginalMethod();
            assert (!originalMethod || callee.isImplementationInvoked());
            return originalMethod;
        }).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public abstract Collection<AnalysisMethod> getAllCallees();

    public abstract Collection<AnalysisMethod> getCalleesForReturnLinking();

    @Override
    public BytecodePosition getPosition() {
        return (BytecodePosition)this.getSource();
    }

    @Override
    public boolean canBeStaticallyBound() {
        boolean triviallyStaticallyBound = this.targetMethod.canBeStaticallyBound();
        if (triviallyStaticallyBound) {
            assert (this.getOriginalCallees().size() <= 1) : "Statically bound result mismatch between analysis and host VM.";
            return true;
        }
        return this.getOriginalCallees().size() == 1;
    }

    protected abstract Collection<MethodFlowsGraph> getAllCalleesFlows(PointsToAnalysis var1);

    public final Collection<MethodFlowsGraph> getOriginalCalleesFlows(PointsToAnalysis bb) {
        Collection<MethodFlowsGraph> allCalleesFlows = this.getAllCalleesFlows(bb);
        assert (allCalleesFlows != null);
        if (this.allOriginalCallees) {
            return allCalleesFlows;
        }
        return allCalleesFlows.stream().filter(flow -> {
            boolean originalMethod = flow.getMethod().isOriginalMethod();
            assert (!originalMethod || !flow.isStub());
            return originalMethod;
        }).collect(Collectors.toUnmodifiableList());
    }

    public MultiMethod.MultiMethodKey getCallerMultiMethodKey() {
        return this.callerMultiMethodKey;
    }
}

