/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.EncodedGraph;

public class MethodFlowsGraph
implements MethodFlowsGraphInfo {
    protected final int id = TypeFlow.nextId.incrementAndGet();
    protected final PointsToAnalysisMethod method;
    protected TypeFlow<?>[] linearizedGraph;
    protected FormalParamTypeFlow[] parameters;
    protected List<TypeFlow<?>> miscEntryFlows;
    protected EconomicMap<EncodedGraph.EncodedNodeReference, TypeFlow<?>> nodeFlows;
    protected EconomicSet<Object> nonUniqueBcis;
    protected EconomicMap<Object, InstanceOfTypeFlow> instanceOfFlows;
    protected EconomicMap<Object, InvokeTypeFlow> invokeFlows;
    protected FormalReturnTypeFlow returnFlow;
    protected volatile boolean isLinearized;
    private GraphKind graphKind;

    public MethodFlowsGraph(PointsToAnalysisMethod method, GraphKind graphKind) {
        this.method = method;
        this.graphKind = graphKind;
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        int parameterCount = method.getSignature().getParameterCount(!isStatic);
        this.parameters = new FormalParamTypeFlow[parameterCount];
    }

    public <T extends TypeFlow<?>> T lookupCloneOf(PointsToAnalysis bb, T original) {
        return original;
    }

    public static boolean nonCloneableFlow(TypeFlow<?> flow) {
        return flow instanceof FieldTypeFlow || flow instanceof ArrayElementsTypeFlow;
    }

    public static boolean crossMethodUse(TypeFlow<?> flow, TypeFlow<?> use) {
        return flow instanceof FormalReturnTypeFlow || use instanceof FormalParamTypeFlow;
    }

    public static boolean nonMethodFlow(TypeFlow<?> flow) {
        return flow instanceof AllInstantiatedTypeFlow || flow instanceof AllSynchronizedTypeFlow;
    }

    public TypeFlow<?>[] getLinearizedGraph() {
        this.ensureLinearized();
        return this.linearizedGraph;
    }

    protected void ensureLinearized() {
        if (!this.isLinearized) {
            this.linearizeGraph(false);
        }
    }

    private synchronized void linearizeGraph(boolean isRedo) {
        if (isRedo || !this.isLinearized) {
            ArrayList resultFlows = new ArrayList();
            for (TypeFlow<?> flow : this.flows()) {
                int slotNum = flow.getSlot();
                if (slotNum != -1) {
                    assert (flow.isClone() || flow instanceof FormalParamTypeFlow || flow instanceof FormalReturnTypeFlow) : "Unexpected flow " + flow;
                    AnalysisError.guarantee((isRedo || flow.isClone()) && flow.getSlot() == resultFlows.size(), "Flow already discovered: %s", flow);
                } else {
                    flow.setSlot(resultFlows.size());
                }
                resultFlows.add(flow);
            }
            this.linearizedGraph = resultFlows.toArray(new TypeFlow[0]);
            this.isLinearized = true;
        }
    }

    public final Iterable<TypeFlow<?>> flows() {
        return this::flowsIterator;
    }

    private Iterator<TypeFlow<?>> flowsIterator() {
        return new Iterator<TypeFlow<?>>(){
            final Deque<TypeFlow<?>> worklist = new ArrayDeque();
            final Set<TypeFlow<?>> seen = new HashSet();
            TypeFlow<?> next;
            {
                for (FormalParamTypeFlow param : MethodFlowsGraph.this.parameters) {
                    if (param == null) continue;
                    this.worklist.add(param);
                }
                if (MethodFlowsGraph.this.returnFlow != null) {
                    this.worklist.add(MethodFlowsGraph.this.returnFlow);
                }
                if (MethodFlowsGraph.this.nodeFlows != null) {
                    for (TypeFlow typeFlow : MethodFlowsGraph.this.nodeFlows.getValues()) {
                        this.worklist.add(typeFlow);
                    }
                }
                if (MethodFlowsGraph.this.miscEntryFlows != null) {
                    for (TypeFlow typeFlow : MethodFlowsGraph.this.miscEntryFlows) {
                        if (MethodFlowsGraph.nonMethodFlow(typeFlow)) continue;
                        this.worklist.add(typeFlow);
                    }
                }
                if (MethodFlowsGraph.this.instanceOfFlows != null) {
                    for (InstanceOfTypeFlow instanceOfTypeFlow : MethodFlowsGraph.this.instanceOfFlows.getValues()) {
                        this.worklist.add(instanceOfTypeFlow);
                    }
                }
                if (MethodFlowsGraph.this.invokeFlows != null) {
                    for (InvokeTypeFlow invokeTypeFlow : MethodFlowsGraph.this.invokeFlows.getValues()) {
                        this.worklist.add(invokeTypeFlow);
                    }
                }
                this.next = this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public TypeFlow<?> next() {
                TypeFlow<?> current = this.next;
                this.next = this.findNext();
                return current;
            }

            private TypeFlow<?> findNext() {
                TypeFlow<?> nextFlow = this.worklist.pollFirst();
                while (this.seen.contains(nextFlow)) {
                    nextFlow = this.worklist.pollFirst();
                }
                if (nextFlow != null) {
                    this.seen.add(nextFlow);
                    this.expand(nextFlow);
                }
                return nextFlow;
            }

            private void expand(TypeFlow<?> flow) {
                for (TypeFlow<?> use : flow.getUses()) {
                    if (use.isClone() || MethodFlowsGraph.crossMethodUse(flow, use) || MethodFlowsGraph.nonCloneableFlow(use) || MethodFlowsGraph.nonMethodFlow(use)) continue;
                    this.worklist.add(use);
                }
            }
        };
    }

    public int id() {
        return this.id;
    }

    @Override
    public PointsToAnalysisMethod getMethod() {
        return this.method;
    }

    @Override
    public boolean isStub() {
        return this.graphKind == GraphKind.STUB;
    }

    public GraphKind getGraphKind() {
        return this.graphKind;
    }

    @Override
    public FormalReceiverTypeFlow getFormalReceiver() {
        return (FormalReceiverTypeFlow)this.getParameter(0);
    }

    public void setParameter(int index, FormalParamTypeFlow parameter) {
        assert (index >= 0 && index < this.parameters.length);
        this.parameters[index] = parameter;
    }

    @Override
    public FormalParamTypeFlow getParameter(int idx) {
        assert (idx >= 0 && idx < this.parameters.length);
        return this.parameters[idx];
    }

    public TypeFlow<?>[] getParameters() {
        return this.parameters;
    }

    public void addNodeFlow(PointsToAnalysis bb, Node node, TypeFlow<?> input) {
        if (bb.strengthenGraalGraphs()) {
            this.addNodeFlow(new EncodedGraph.EncodedNodeReference(node), input);
        } else {
            this.addMiscEntryFlow(input);
        }
    }

    public void addNodeFlow(EncodedGraph.EncodedNodeReference key, TypeFlow<?> flow) {
        assert (flow != null && !(flow instanceof AllInstantiatedTypeFlow));
        if (this.nodeFlows == null) {
            this.nodeFlows = EconomicMap.create();
        }
        this.nodeFlows.put((Object)key, flow);
    }

    public Collection<TypeFlow<?>> getMiscFlows() {
        return this.miscEntryFlows == null ? Collections.emptyList() : this.miscEntryFlows;
    }

    public EconomicMap<EncodedGraph.EncodedNodeReference, TypeFlow<?>> getNodeFlows() {
        return this.nodeFlows == null ? EconomicMap.emptyMap() : this.nodeFlows;
    }

    public void addMiscEntryFlow(TypeFlow<?> entryFlow) {
        if (this.miscEntryFlows == null) {
            this.miscEntryFlows = new ArrayList();
        }
        this.miscEntryFlows.add(entryFlow);
    }

    public void setReturnFlow(FormalReturnTypeFlow returnFlow) {
        this.returnFlow = returnFlow;
    }

    @Override
    public FormalReturnTypeFlow getReturnFlow() {
        return this.returnFlow;
    }

    public EconomicMap<Object, InvokeTypeFlow> getInvokes() {
        return this.invokeFlows == null ? EconomicMap.emptyMap() : this.invokeFlows;
    }

    public EconomicMap<Object, InstanceOfTypeFlow> getInstanceOfFlows() {
        return this.instanceOfFlows == null ? EconomicMap.emptyMap() : this.instanceOfFlows;
    }

    void addInstanceOf(Object key, InstanceOfTypeFlow instanceOf) {
        if (this.instanceOfFlows == null) {
            this.instanceOfFlows = EconomicMap.create();
        }
        this.doAddFlow(key, instanceOf, this.instanceOfFlows);
    }

    void addInvoke(Object key, InvokeTypeFlow invokeTypeFlow) {
        if (this.invokeFlows == null) {
            this.invokeFlows = EconomicMap.create();
        }
        this.doAddFlow(key, invokeTypeFlow, this.invokeFlows);
    }

    private <T extends TypeFlow<BytecodePosition>> void doAddFlow(Object key, T flow, EconomicMap<Object, T> map) {
        assert (map == this.instanceOfFlows || map == this.invokeFlows) : "Keys of these maps must not be overlapping";
        Object uniqueKey = key;
        if (this.nonUniqueBcis != null && this.nonUniqueBcis.contains(key) || this.removeNonUnique(key, this.instanceOfFlows) || this.removeNonUnique(key, this.invokeFlows)) {
            uniqueKey = new Object();
        }
        map.put(uniqueKey, flow);
    }

    private <T extends TypeFlow<BytecodePosition>> boolean removeNonUnique(Object key, EconomicMap<Object, T> map) {
        if (map == null) {
            return false;
        }
        TypeFlow oldFlow = (TypeFlow)map.removeKey(key);
        if (oldFlow != null) {
            map.put(new Object(), (Object)oldFlow);
            if (this.nonUniqueBcis == null) {
                this.nonUniqueBcis = EconomicSet.create();
            }
            this.nonUniqueBcis.add(key);
            return true;
        }
        return false;
    }

    public boolean isLinearized() {
        return this.isLinearized;
    }

    public List<MethodFlowsGraph> callers(PointsToAnalysis bb) {
        ArrayList<MethodFlowsGraph> callers = new ArrayList<MethodFlowsGraph>();
        for (AnalysisMethod caller : this.method.getCallers()) {
            for (MethodFlowsGraph callerFlowGraph : PointsToAnalysis.assertPointsToAnalysisMethod(caller).getTypeFlow().getFlows()) {
                Iterator iterator = callerFlowGraph.getInvokes().getValues().iterator();
                while (iterator.hasNext()) {
                    InvokeTypeFlow callerInvoke;
                    InvokeTypeFlow invoke = callerInvoke = (InvokeTypeFlow)iterator.next();
                    if (InvokeTypeFlow.isContextInsensitiveVirtualInvoke(callerInvoke)) {
                        invoke = callerInvoke.getTargetMethod().getContextInsensitiveVirtualInvoke(this.method.getMultiMethodKey());
                    }
                    for (MethodFlowsGraph calleeFlowGraph : invoke.getOriginalCalleesFlows(bb)) {
                        if (!calleeFlowGraph.equals(this)) continue;
                        callers.add(callerFlowGraph);
                    }
                }
            }
        }
        return callers;
    }

    public InvokeTypeFlow invokeFlow(MethodFlowsGraph callerFlowGraph, PointsToAnalysis bb) {
        for (InvokeTypeFlow callerInvoke : callerFlowGraph.getInvokes().getValues()) {
            for (MethodFlowsGraph calleeFlowGraph : callerInvoke.getOriginalCalleesFlows(bb)) {
                if (!calleeFlowGraph.equals(this)) continue;
                return callerInvoke;
            }
        }
        return null;
    }

    public String toString() {
        return "MethodFlowsGraph<" + this.method.format("%h.%n(%p)") + ">";
    }

    final void removeInternalFlows(PointsToAnalysis bb) {
        this.flowsIterator().forEachRemaining(typeFlow -> {
            boolean skipInvalidate;
            boolean bl = skipInvalidate = typeFlow instanceof FormalParamTypeFlow || typeFlow instanceof FormalReturnTypeFlow;
            if (!skipInvalidate) {
                typeFlow.invalidate();
            }
        });
        for (TypeFlow<?> param : this.getParameters()) {
            if (param == null) continue;
            param.clearUses();
            param.clearObservers();
        }
        if (this.returnFlow != null && bb.trackTypeFlowInputs()) {
            this.returnFlow.clearInputs();
            this.returnFlow.clearObservees();
        }
        this.miscEntryFlows = null;
        this.nodeFlows = null;
        this.nonUniqueBcis = null;
        this.instanceOfFlows = null;
        this.invokeFlows = null;
    }

    void updateInternalState(GraphKind newGraphKind) {
        this.graphKind = newGraphKind;
        if (this.isLinearized) {
            this.linearizeGraph(true);
        }
    }

    public static enum GraphKind {
        STUB,
        FULL;

    }
}

