/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.object.AllocationContextSensitiveObject;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

public class BytecodeAnalysisContextPolicy
extends AnalysisContextPolicy<BytecodeAnalysisContext> {
    public BytecodeAnalysisContextPolicy() {
        super(BytecodeAnalysisContextPolicy.getEmptyContext());
    }

    private static BytecodeAnalysisContext getEmptyContext() {
        return new BytecodeAnalysisContext(BytecodeAnalysisContext.emptyLabelList);
    }

    @Override
    public BytecodeAnalysisContext peel(BytecodeAnalysisContext context, int maxDepth) {
        assert (maxDepth >= 0);
        if (context.labels().length <= maxDepth) {
            return context;
        }
        assert (context.labels().length > maxDepth);
        BytecodePosition[] resultingLabelList = BytecodeAnalysisContextPolicy.peel(context.labels(), maxDepth);
        return this.lookupContext(resultingLabelList);
    }

    @Override
    public BytecodeAnalysisContext calleeContext(PointsToAnalysis bb, AnalysisObject receiverObject, BytecodeAnalysisContext callerContext, MethodTypeFlow callee) {
        BytecodePosition[] labelList;
        int maxCalleeContextDepth = ((CallSiteSensitiveMethodTypeFlow)callee).getLocalCallingContextDepth();
        if (maxCalleeContextDepth == 0 || !receiverObject.isAllocationContextSensitiveObject()) {
            return (BytecodeAnalysisContext)this.emptyContext();
        }
        AllocationContextSensitiveObject receiverHeapObject = (AllocationContextSensitiveObject)receiverObject;
        if (receiverHeapObject.allocationContext() != null) {
            labelList = BytecodeAnalysisContextPolicy.extend(((BytecodeAnalysisContext)receiverHeapObject.allocationContext()).labels(), receiverHeapObject.allocationLabel(), maxCalleeContextDepth);
        } else {
            JVMCIError.shouldNotReachHere((String)"CoreAnalysisContextPolicy.merge: receiverHeapObject.heapContext() is null");
            labelList = new BytecodePosition[]{receiverHeapObject.allocationLabel()};
        }
        return this.lookupContext(labelList);
    }

    @Override
    public BytecodeAnalysisContext staticCalleeContext(PointsToAnalysis bb, BytecodePosition invokeLocation, BytecodeAnalysisContext callerContext, MethodTypeFlow callee) {
        assert (callerContext != null);
        if (!bb.analysisPolicy().useHybridStaticContext()) {
            return callerContext;
        }
        int maxCallingContextDepth = ((CallSiteSensitiveMethodTypeFlow)callee).getLocalCallingContextDepth();
        if (maxCallingContextDepth == 0) {
            return (BytecodeAnalysisContext)this.emptyContext();
        }
        BytecodePosition[] labelList = BytecodeAnalysisContextPolicy.extend(callerContext.labels(), invokeLocation, maxCallingContextDepth);
        return this.lookupContext(labelList);
    }

    @Override
    public BytecodeAnalysisContext allocationContext(BytecodeAnalysisContext context, int maxHeapContextDepth) {
        return this.peel(context, maxHeapContextDepth);
    }

    private BytecodeAnalysisContext lookupContext(BytecodePosition[] positions) {
        return (BytecodeAnalysisContext)this.lookupContext(new BytecodeAnalysisContext(positions));
    }
}

