/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ImageHeapInstance
extends ImageHeapConstant {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(Object[].class);
    private final Object[] fieldValues;

    public ImageHeapInstance(ResolvedJavaType type) {
        this(type, null, type.getInstanceFields(true).length);
    }

    ImageHeapInstance(ResolvedJavaType type, JavaConstant object, int length) {
        this(type, object, new Object[length], ImageHeapInstance.createIdentityHashCode(object), false);
    }

    private ImageHeapInstance(ResolvedJavaType type, JavaConstant object, Object[] fieldValues, int identityHashCode, boolean compressed) {
        super(type, object, identityHashCode, compressed);
        this.fieldValues = fieldValues;
    }

    public void setFieldTask(AnalysisField field, AnalysisFuture<JavaConstant> task) {
        arrayHandle.setVolatile(this.fieldValues, field.getPosition(), task);
    }

    public void setFieldValue(AnalysisField field, JavaConstant value) {
        arrayHandle.setVolatile(this.fieldValues, field.getPosition(), value);
    }

    public Object getFieldValue(AnalysisField field) {
        return arrayHandle.getVolatile(this.fieldValues, field.getPosition());
    }

    public JavaConstant readFieldValue(AnalysisField field) {
        Object value = this.getFieldValue(field);
        return value instanceof JavaConstant ? (JavaConstant)value : (JavaConstant)((AnalysisFuture)value).ensureDone();
    }

    public JavaConstant compress() {
        assert (!this.compressed);
        return new ImageHeapInstance(this.type, this.hostedObject, this.fieldValues, this.identityHashCode, true);
    }

    public JavaConstant uncompress() {
        assert (this.compressed);
        return new ImageHeapInstance(this.type, this.hostedObject, this.fieldValues, this.identityHashCode, false);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        if (!this.type.isCloneableWithAllocation()) {
            return null;
        }
        Object[] newFieldValues = Arrays.copyOf(this.fieldValues, this.fieldValues.length);
        JavaConstant newObject = null;
        return new ImageHeapInstance(this.type, newObject, newFieldValues, ImageHeapInstance.createIdentityHashCode(newObject), this.compressed);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ImageHeapInstance) {
            return super.equals(o) && this.fieldValues == ((ImageHeapInstance)o).fieldValues;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + System.identityHashCode(this.fieldValues);
        return result;
    }
}

