/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap;

import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Array;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class ImageHeapPrimitiveArray
extends ImageHeapArray {
    private final Object array;
    private final int length;

    ImageHeapPrimitiveArray(AnalysisType type, int length) {
        this(type, null, Array.newInstance(type.getComponentType().getStorageKind().toJavaClass(), length), ImageHeapPrimitiveArray.createIdentityHashCode(null), false, length);
    }

    ImageHeapPrimitiveArray(AnalysisType type, JavaConstant hostedObject, Object array, int length) {
        this(type, hostedObject, ImageHeapPrimitiveArray.getClone(type.getComponentType().getJavaKind(), array), ImageHeapPrimitiveArray.createIdentityHashCode(hostedObject), false, length);
    }

    private ImageHeapPrimitiveArray(ResolvedJavaType type, JavaConstant hostedObject, Object array, int identityHashCode, boolean compressed, int length) {
        super(type, hostedObject, identityHashCode, compressed);
        assert (type.isArray() && type.getComponentType().isPrimitive());
        this.array = array;
        this.length = length;
    }

    private static Object getClone(JavaKind kind, Object arrayObject) {
        return switch (kind) {
            case JavaKind.Boolean -> (boolean[])((boolean[])arrayObject).clone();
            case JavaKind.Byte -> (Object[])((byte[])((byte[])arrayObject).clone());
            case JavaKind.Short -> (Object[])((short[])((short[])arrayObject).clone());
            case JavaKind.Char -> (Object[])((char[])((char[])arrayObject).clone());
            case JavaKind.Int -> (Object[])((int[])((int[])arrayObject).clone());
            case JavaKind.Long -> (Object[])((long[])((long[])arrayObject).clone());
            case JavaKind.Float -> (Object[])((float[])((float[])arrayObject).clone());
            case JavaKind.Double -> (Object[])((double[])((double[])arrayObject).clone());
            default -> throw new IllegalArgumentException("Unsupported kind: " + kind);
        };
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public Object getElement(int idx) {
        return this.readElementValue(idx);
    }

    @Override
    public JavaConstant readElementValue(int idx) {
        return JavaConstant.forBoxedPrimitive((Object)Array.get(this.array, idx));
    }

    @Override
    public void setElement(int idx, JavaConstant value) {
        if (value.getJavaKind() != this.type.getComponentType().getJavaKind()) {
            throw AnalysisError.shouldNotReachHere("Cannot store value of kind " + value.getJavaKind() + " into primitive array of type " + this.type);
        }
        Array.set(this.array, idx, value.asBoxedPrimitive());
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public JavaConstant compress() {
        assert (!this.compressed);
        return new ImageHeapPrimitiveArray(this.type, this.hostedObject, this.array, this.identityHashCode, true, this.length);
    }

    public JavaConstant uncompress() {
        assert (this.compressed);
        return new ImageHeapPrimitiveArray(this.type, this.hostedObject, this.array, this.identityHashCode, false, this.length);
    }

    @Override
    public ImageHeapConstant forObjectClone() {
        assert (this.type.isCloneableWithAllocation()) : "all arrays implement Cloneable";
        Object newArray = ImageHeapPrimitiveArray.getClone(this.type.getComponentType().getJavaKind(), this.array);
        JavaConstant newHostedObject = null;
        return new ImageHeapPrimitiveArray(this.type, newHostedObject, newArray, ImageHeapPrimitiveArray.createIdentityHashCode(newHostedObject), this.compressed, this.length);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ImageHeapPrimitiveArray) {
            return super.equals(o) && this.array == ((ImageHeapPrimitiveArray)o).array;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + System.identityHashCode(this.array);
        return result;
    }
}

