/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ContextvarsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_contextvars")
public final class ContextvarsModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ContextvarsModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="Token", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.ContextVarsToken)
    @GenerateNodeFactory
    public static abstract class TokenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object construct(Object cls, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.TOKEN_ONLY_BY_CONTEXTVAR);
        }
    }

    @Builtin(name="Context", minNumOfPositionalArgs=1, constructsClass=PythonBuiltinClassType.ContextVarsContext)
    @GenerateNodeFactory
    public static abstract class ContextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object construct(Object cls) {
            return this.factory().createContextVarsContext();
        }
    }

    @Builtin(name="ContextVar", minNumOfPositionalArgs=2, parameterNames={"cls", "name", "default"}, constructsClass=PythonBuiltinClassType.ContextVar)
    @GenerateNodeFactory
    public static abstract class ContextVarNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"isNoValue(def)"})
        protected Object construct(Object cls, TruffleString name, PNone def) {
            return this.constructDef(cls, name, PContextVar.NO_DEFAULT);
        }

        @Specialization(guards={"!isNoValue(def)"})
        protected Object constructDef(Object cls, TruffleString name, Object def) {
            return this.factory().createContextVar(name, def);
        }
    }

    @Builtin(name="copy_context", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class GetDefaultEncodingNode
    extends PythonBuiltinNode {
        @Specialization
        protected Object copyCtx() {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            return this.factory().copyContextVarsContext(threadState.getContextVarsContext());
        }
    }
}

