/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.CodecsCNModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.cjkcodecs.DBCSMap;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodec;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibytecodecModuleBuiltins;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsuleNameMatchesNode;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_codecs_cn")
public final class CodecsCNModuleBuiltins
extends PythonBuiltins {
    private static final DBCSMap[] MAPPING_LIST = new DBCSMap[4];
    private static final MultibyteCodec[] CODEC_LIST = new MultibyteCodec[4];

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CodecsCNModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonObjectSlowPathFactory factory = core.factory();
        PythonModule codec = core.lookupBuiltinModule(BuiltinNames.T__CODECS_CN);
        MultibytecodecModuleBuiltins.registerCodec("gb2312", 0, MultibyteCodec.CodecType.STATELESS, 0, DBCSMap.MappingType.DECONLY, MAPPING_LIST, CODEC_LIST, codec, factory);
        MultibytecodecModuleBuiltins.registerCodec("gbk", 1, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, factory);
        MultibytecodecModuleBuiltins.registerCodec("gb18030", 2, MultibyteCodec.CodecType.STATELESS, -1, null, null, CODEC_LIST, codec, factory);
        MultibytecodecModuleBuiltins.registerCodec("hz", 3, MultibyteCodec.CodecType.STATEFUL, -1, null, null, CODEC_LIST, codec, factory);
        MultibytecodecModuleBuiltins.registerCodec("gbkext", -1, null, 1, DBCSMap.MappingType.DECONLY, MAPPING_LIST, null, codec, factory);
        MultibytecodecModuleBuiltins.registerCodec("gbcommon", -1, null, 2, DBCSMap.MappingType.ENCONLY, MAPPING_LIST, null, codec, factory);
        MultibytecodecModuleBuiltins.registerCodec("gb18030ext", -1, null, 3, DBCSMap.MappingType.ENCDEC, MAPPING_LIST, null, codec, factory);
    }

    @Builtin(name="getcodec", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetCodecNode
    extends PythonUnaryBuiltinNode {
        GetCodecNode() {
        }

        @Specialization
        Object getcodec(Object encoding, @Bind(value="this") Node inliningTarget, @Cached TruffleString.EqualNode isEqual, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached CastToTruffleStringNode asUTF8Node, @Cached PyCapsuleNameMatchesNode nameMatchesNode) {
            if (!unicodeCheckNode.execute(inliningTarget, encoding)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.ENCODING_NAME_MUST_BE_A_STRING);
            }
            MultibyteCodec codec = MultibyteCodecUtil.findCodec(CODEC_LIST, asUTF8Node.execute(inliningTarget, encoding), isEqual);
            if (codec == null) {
                throw this.raise(PythonErrorType.LookupError, ErrorMessages.NO_SUCH_CODEC_IS_SUPPORTED);
            }
            PyCapsule codecobj = this.factory().createCapsule(codec, MultibytecodecModuleBuiltins.PyMultibyteCodec_CAPSULE_NAME, null);
            return MultibytecodecModuleBuiltins.CreateCodecNode.createCodec(this, codecobj, nameMatchesNode, this.factory(), this.getRaiseNode());
        }
    }
}

