/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.functools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.functools.KeyWrapperBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.functools.PKeyWrapper;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PKeyWrapper})
public final class KeyWrapperBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return KeyWrapperBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        core.lookupType(PythonBuiltinClassType.PKeyWrapper).setAttribute(SpecialMethodNames.T___HASH__, PNone.NONE);
    }

    @Builtin(name="obj", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="Value wrapped by a key function.")
    @GenerateNodeFactory
    public static abstract class KeyWrapperObjNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(value)"})
        static Object doGet(PKeyWrapper self, PNone value) {
            return self.getObject();
        }

        @Specialization
        static Object doSet(PKeyWrapper self, Object value) {
            self.setObject(value);
            return PNone.NONE;
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "obj"})
    @GenerateNodeFactory
    public static abstract class KWCallNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object call(PKeyWrapper self, Object obj) {
            PKeyWrapper keyWrapper = this.factory().createKeyWrapper(self.getCmp());
            keyWrapper.setObject(obj);
            return keyWrapper;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class KWEqNode
    extends WrapperKeyCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.EqNode.create();
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class KWGtNode
    extends WrapperKeyCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.GtNode.create();
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class KWGeNode
    extends WrapperKeyCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.GeNode.create();
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class KWLtNode
    extends WrapperKeyCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.LtNode.create();
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class KWLeNode
    extends WrapperKeyCompareNode {
        @Override
        BinaryComparisonNode createCmp() {
            return BinaryComparisonNode.LeNode.create();
        }
    }

    static abstract class WrapperKeyCompareNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private BinaryComparisonNode comparisonNode;
        @Node.Child
        private CallNode callNode;

        WrapperKeyCompareNode() {
        }

        protected BinaryComparisonNode ensureComparisonNode() {
            if (this.comparisonNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.comparisonNode = (BinaryComparisonNode)this.insert(this.createCmp());
            }
            return this.comparisonNode;
        }

        protected CallNode ensureCallNode() {
            if (this.callNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callNode = (CallNode)this.insert(CallNode.create());
            }
            return this.callNode;
        }

        BinaryComparisonNode createCmp() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        public boolean doCompare(VirtualFrame frame, PKeyWrapper self, PKeyWrapper other, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            Object cmpResult = this.ensureCallNode().execute((Frame)frame, self.getCmp(), self.getObject(), other.getObject());
            return isTrueNode.execute((Frame)frame, inliningTarget, this.ensureComparisonNode().executeObject(frame, cmpResult, 0));
        }

        @Fallback
        public boolean fallback(Object self, Object other) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OTHER_ARG_MUST_BE_KEY);
        }
    }
}

