/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Blake2ModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.hashlib.Blake2ModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="_blake2")
public final class Blake2ModuleBuiltins
extends PythonBuiltins {
    static final int BLAKE2B_SALTBYTES = 16;
    static final int BLAKE2B_PERSONALBYTES = 16;
    static final int BLAKE2B_KEYBYTES = 64;
    static final int BLAKE2B_OUTBYTES = 64;
    static final int BLAKE2S_SALTBYTES = 8;
    static final int BLAKE2S_PERSONALBYTES = 8;
    static final int BLAKE2S_KEYBYTES = 32;
    static final int BLAKE2S_OUTBYTES = 32;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Blake2ModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("BLAKE2B_SALT_SIZE", (Object)16);
        this.addBuiltinConstant("BLAKE2B_PERSON_SIZE", (Object)16);
        this.addBuiltinConstant("BLAKE2B_MAX_KEY_SIZE", (Object)64);
        this.addBuiltinConstant("BLAKE2B_MAX_DIGEST_SIZE", (Object)64);
        this.addBuiltinConstant("BLAKE2S_SALT_SIZE", (Object)8);
        this.addBuiltinConstant("BLAKE2S_PERSON_SIZE", (Object)8);
        this.addBuiltinConstant("BLAKE2S_MAX_KEY_SIZE", (Object)32);
        this.addBuiltinConstant("BLAKE2S_MAX_DIGEST_SIZE", (Object)32);
        super.initialize(core);
    }

    @Builtins(value={@Builtin(name="blake2b", declaresExplicitSelf=true, minNumOfPositionalArgs=1, parameterNames={"$cls", "data"}, keywordOnlyNames={"digest_size", "key", "salt", "person", "fanout", "depth", "leaf_size", "node_offset", "node_depth", "inner_size", "last_node", "usedforsecurity"}, constructsClass=PythonBuiltinClassType.Blake2bType), @Builtin(name="blake2s", declaresExplicitSelf=true, minNumOfPositionalArgs=1, parameterNames={"$cls", "data"}, keywordOnlyNames={"digest_size", "key", "salt", "person", "fanout", "depth", "leaf_size", "node_offset", "node_depth", "inner_size", "last_node", "usedforsecurity"}, constructsClass=PythonBuiltinClassType.Blake2sType)})
    @ArgumentsClinic(value={@ArgumentClinic(name="digest_size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="key", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE"), @ArgumentClinic(name="salt", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE"), @ArgumentClinic(name="person", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE"), @ArgumentClinic(name="fanout", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1"), @ArgumentClinic(name="depth", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="1"), @ArgumentClinic(name="leaf_size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="node_offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="node_depth", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="inner_size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0"), @ArgumentClinic(name="last_node", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false"), @ArgumentClinic(name="usedforsecurity", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    @GenerateNodeFactory
    static abstract class BlakeNode
    extends PythonClinicBuiltinNode {
        BlakeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return Blake2ModuleBuiltinsClinicProviders.BlakeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object newDigest(VirtualFrame frame, Object type, Object data, int digestSize, PNone key, PNone salt, PNone person, int fanout, int depth, int leafSize, int nodeOffset, int nodeDepth, int innerSize, boolean lastNode, boolean usedforsecurity, @Bind(value="this") Node inliningTarget, @Cached HashlibModuleBuiltins.CreateDigestNode createNode) {
            int javaDigestSize;
            String pythonName;
            String javaName;
            if (fanout != 1 || depth != 1 || leafSize != 0 || nodeOffset != 0 || nodeDepth != 0 || innerSize != 0 || lastNode) {
                throw this.fail(frame, type, data, digestSize, key, salt, person, fanout, depth, leafSize, nodeOffset, nodeDepth, innerSize, lastNode, usedforsecurity);
            }
            PythonBuiltinClassType resultType = null;
            if (type instanceof PythonBuiltinClass) {
                PythonBuiltinClass builtinType = (PythonBuiltinClass)type;
                resultType = builtinType.getType();
            } else if (type instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType enumType;
                resultType = enumType = (PythonBuiltinClassType)((Object)type);
            } else {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.WRONG_TYPE);
            }
            if (resultType == PythonBuiltinClassType.Blake2bType) {
                javaName = "BLAKE2B-%d";
                pythonName = "blake2b";
                javaDigestSize = digestSize == 0 ? 512 : digestSize;
            } else if (resultType == PythonBuiltinClassType.Blake2sType) {
                javaName = "BLAKE2S-%d";
                pythonName = "blake2s";
                javaDigestSize = digestSize == 0 ? 256 : digestSize;
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            javaName = PythonUtils.formatJString(javaName, javaDigestSize);
            return createNode.execute(frame, inliningTarget, resultType, pythonName, javaName, data, this);
        }

        @Fallback
        PException fail(VirtualFrame frame, Object type, Object data, Object digestSize, Object key, Object salt, Object person, Object fanout, Object depth, Object leafSize, Object nodeOffset, Object nodeDepth, Object innerSize, Object lastNode, Object usedforsecurity) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.ONLY_DIGEST_SIZE_BLAKE_ARGUMENT);
        }
    }
}

