/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObject;
import com.oracle.graal.python.builtins.modules.hashlib.DigestObjectBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.ssl.CertUtils;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

@CoreFunctions(defineModule="_hashlib")
public final class HashlibModuleBuiltins
extends PythonBuiltins {
    static final String J_HASHLIB = "_hashlib";
    private static final TruffleString T_HASHLIB = PythonUtils.tsLiteral("_hashlib");
    private static final String OPENSSL_PREFIX = "openssl_";
    private static final Map<String, String> NAME_MAPPINGS = Map.of("sha3_224", "sha3-sha224", "sha3_256", "sha3-sha256", "sha3_384", "sha3-sha384", "sha3_512", "sha3-sha512", "shake_128", "SHAKE128", "shake_256", "SHAKE256");
    private static final String CONSTRUCTORS = "_constructors";
    private static final HiddenKey ORIGINAL_CONSTRUCTORS = new HiddenKey("_constructors");
    private static final String[] DIGEST_ALIASES = new String[]{"md5", "_md5", "sha1", "_sha1", "sha224", "_sha256", "sha256", "_sha256", "sha384", "_sha512", "sha512", "_sha512", "sha3_224", "_sha3", "sha3_256", "_sha3", "sha3_384", "_sha3", "sha3_512", "_sha3", "shake_128", "_sha3", "shake_256", "_sha3"};
    private static final String[] DIGEST_ALGORITHMS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return HashlibModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        LinkedHashMap<String, Object> algos = new LinkedHashMap<String, Object>();
        for (String digest : DIGEST_ALGORITHMS) {
            algos.put(digest, PNone.NONE);
        }
        this.addBuiltinConstant("openssl_md_meth_names", (Object)core.factory().createFrozenSet(EconomicMapStorage.create(algos)));
        EconomicMapStorage storage = EconomicMapStorage.create();
        this.addBuiltinConstant(CONSTRUCTORS, (Object)core.factory().createMappingproxy(core.factory().createDict(storage)));
        this.addBuiltinConstant(ORIGINAL_CONSTRUCTORS, (Object)storage);
        ReadAttributeFromDynamicObjectNode readNode = ReadAttributeFromDynamicObjectNode.getUncached();
        for (int i = 0; i < DIGEST_ALIASES.length; i += 2) {
            this.addDigestAlias(core, readNode, DIGEST_ALIASES[i], DIGEST_ALIASES[i + 1]);
        }
        super.initialize(core);
    }

    private final void addDigestAlias(Python3Core core, ReadAttributeFromDynamicObjectNode readNode, String digest, String module) {
        TruffleString tsDigest = PythonUtils.toTruffleStringUncached(digest);
        Object function = readNode.execute((Object)core.lookupBuiltinModule(PythonUtils.toTruffleStringUncached(module)), tsDigest);
        if (function != PNone.NO_VALUE) {
            this.addBuiltinConstant(OPENSSL_PREFIX + digest, function);
        }
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule self = core.lookupBuiltinModule(T_HASHLIB);
        ReadAttributeFromDynamicObjectNode readNode = ReadAttributeFromDynamicObjectNode.getUncached();
        EconomicMapStorage storage = (EconomicMapStorage)readNode.execute((Object)self, ORIGINAL_CONSTRUCTORS);
        for (int i = 0; i < DIGEST_ALIASES.length; i += 2) {
            HashlibModuleBuiltins.addDigestAlias(self, readNode, storage, DIGEST_ALIASES[i]);
        }
    }

    private static final void addDigestAlias(PythonModule self, ReadAttributeFromDynamicObjectNode readNode, EconomicMapStorage storage, String digest) {
        String digestAttr = OPENSSL_PREFIX + digest;
        TruffleString tsDigest = PythonUtils.toTruffleStringUncached(digest);
        TruffleString tsDigestAttr = PythonUtils.toTruffleStringUncached(digestAttr);
        Object function = readNode.execute((Object)self, tsDigestAttr);
        if (function != PNone.NO_VALUE) {
            HashingStorageNodes.HashingStorageSetItem.executeUncached(storage, function, tsDigest);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Mac createMac(TruffleString digest, byte[] key, int keyLen, byte[] msg, int msgLen) throws NoSuchAlgorithmException, InvalidKeyException {
        String inputName = digest.toJavaStringUncached().toLowerCase();
        String algorithm = "hmac" + NAME_MAPPINGS.getOrDefault(inputName, inputName);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, 0, keyLen, algorithm);
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKeySpec);
        if (msg != null) {
            mac.update(msg, 0, msgLen);
        }
        return mac;
    }

    static {
        Security.addProvider((Provider)CertUtils.BOUNCYCASTLE_PROVIDER);
        ArrayList<String> digests = new ArrayList<String>();
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if (!service.getType().equalsIgnoreCase(MessageDigest.class.getSimpleName())) continue;
                digests.add(service.getAlgorithm());
            }
        }
        DIGEST_ALGORITHMS = digests.toArray(new String[digests.size()]);
    }

    @Builtin(name="HMAC", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.HashlibHmac, isPublic=false)
    @GenerateNodeFactory
    static abstract class HmacNode
    extends PythonBuiltinNode {
        HmacNode() {
        }

        @Specialization
        Object hash(Object args, Object kwargs) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_hashlib.HMAC");
        }
    }

    @Builtin(name="HASHXOF", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.HashlibHashXof, isPublic=false)
    @GenerateNodeFactory
    static abstract class HashXofNode
    extends PythonBuiltinNode {
        HashXofNode() {
        }

        @Specialization
        Object hash(Object args, Object kwargs) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_hashlib.HASHXOF");
        }
    }

    @Builtin(name="HASH", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.HashlibHash, isPublic=false)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonBuiltinNode {
        HashNode() {
        }

        @Specialization
        Object hash(Object args, Object kwargs) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "_hashlib.HASH");
        }
    }

    @Builtin(name="get_fips_mode")
    @GenerateNodeFactory
    static abstract class GetFipsNode
    extends PythonBuiltinNode {
        GetFipsNode() {
        }

        @Specialization
        int getFips() {
            return 0;
        }
    }

    @Builtin(name="new", minNumOfPositionalArgs=1, parameterNames={"name", "string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="usedforsecurity", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")})
    static abstract class NewNode
    extends PythonClinicBuiltinNode {
        NewNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return HashlibModuleBuiltinsClinicProviders.NewNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object newDigest(VirtualFrame frame, TruffleString name, Object buffer, boolean usedForSecurity, @Bind(value="this") Node inliningTarget, @Cached CreateDigestNode createNode, @Cached CastToJavaStringNode castStr) {
            String pythonDigestName = NewNode.getPythonName(castStr.execute(name));
            String javaDigestName = NewNode.getJavaName(pythonDigestName);
            PythonBuiltinClassType digestType = NewNode.getTypeFor(javaDigestName);
            return createNode.execute(frame, inliningTarget, digestType, pythonDigestName, javaDigestName, buffer, this);
        }

        private static PythonBuiltinClassType getTypeFor(String digestName) {
            switch (digestName) {
                case "SHAKE256": 
                case "SHAKE128": {
                    return PythonBuiltinClassType.HashlibHashXof;
                }
            }
            return PythonBuiltinClassType.HashlibHash;
        }

        @CompilerDirectives.TruffleBoundary
        private static String getPythonName(String inputName) {
            return inputName.toLowerCase();
        }

        @CompilerDirectives.TruffleBoundary
        private static String getJavaName(String inputName) {
            return NAME_MAPPINGS.getOrDefault(inputName, inputName);
        }
    }

    @GenerateUncached(value=false)
    @GenerateCached(value=false)
    @GenerateInline
    static abstract class CreateDigestNode
    extends Node {
        CreateDigestNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, PythonBuiltinClassType var3, String var4, String var5, Object var6, PythonBuiltinBaseNode var7);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doIt(VirtualFrame frame, Node inliningTarget, PythonBuiltinClassType type, String pythonName, String javaName, Object value, PythonBuiltinBaseNode indirectCallNode, @Cached(inline=false) PythonObjectFactory factory, @CachedLibrary(limit="2") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode.Lazy raise) {
            Object buffer;
            if (value instanceof PNone) {
                buffer = null;
            } else if (acquireLib.hasBuffer(value)) {
                buffer = acquireLib.acquireReadonly(value, frame, indirectCallNode);
            } else {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.A_BYTES_LIKE_OBJECT_IS_REQUIRED_NOT_P, value);
            }
            try {
                MessageDigest digest;
                byte[] bytes = buffer == null ? null : bufferLib.getInternalOrCopiedByteArray(buffer);
                int bytesLen = buffer == null ? 0 : bufferLib.getBufferLength(buffer);
                try {
                    digest = CreateDigestNode.createDigest(javaName, bytes, bytesLen);
                }
                catch (NoSuchAlgorithmException e) {
                    throw raise.get(inliningTarget).raise(PythonBuiltinClassType.UnsupportedDigestmodError, e);
                }
                DigestObject digestObject = factory.createDigestObject(type, pythonName, digest);
                return digestObject;
            }
            finally {
                if (buffer != null) {
                    bufferLib.release(buffer, frame, indirectCallNode);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static MessageDigest createDigest(String name, byte[] bytes, int bytesLen) throws NoSuchAlgorithmException {
            MessageDigest digest = MessageDigest.getInstance(name);
            if (bytes != null) {
                digest.update(bytes, 0, bytesLen);
            }
            return digest;
        }
    }

    @Builtin(name="hmac_new", declaresExplicitSelf=true, parameterNames={"$mod", "key", "msg", "digestmod"}, minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class HmacNewNode
    extends PythonQuaternaryBuiltinNode {
        private static final TruffleString HMAC_PREFIX = PythonUtils.tsLiteral("hmac-");

        HmacNewNode() {
        }

        @Specialization
        Object hmacNewError(PythonModule self, Object key, Object msg, PNone digest) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MISSING_D_REQUIRED_S_ARGUMENT_S_POS, "hmac_new", "digestmod", 3);
        }

        @Specialization(guards={"!isString(digestmod)"})
        Object hmacNewFromFunction(VirtualFrame frame, PythonModule self, Object key, Object msg, Object digestmod, @Bind(value="this") Node inliningTarget, @Cached ReadAttributeFromDynamicObjectNode readNode, @Cached HashingStorageNodes.HashingStorageGetItem getItemNode, @Cached.Exclusive @Cached CastToTruffleStringNode castStr, @Cached.Exclusive @Cached CastToJavaStringNode castJStr, @Cached.Shared(value="concatStr") @Cached TruffleString.ConcatNode concatStr, @Cached.Shared(value="acquireLib") @CachedLibrary(limit="2") PythonBufferAcquireLibrary acquireLib, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            EconomicMapStorage constructors = (EconomicMapStorage)readNode.execute((Object)self, ORIGINAL_CONSTRUCTORS);
            Object name = getItemNode.execute((Frame)frame, inliningTarget, constructors, digestmod);
            if (name != null) {
                assert (name instanceof TruffleString);
                return this.hmacNew(self, key, msg, name, inliningTarget, castStr, castJStr, concatStr, acquireLib, bufferLib);
            }
            throw this.raise(PythonBuiltinClassType.UnsupportedDigestmodError);
        }

        /*
         * Loose catch block
         */
        @Specialization(guards={"isString(digestmodObj)"})
        Object hmacNew(PythonModule self, Object keyObj, Object msgObj, Object digestmodObj, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CastToTruffleStringNode castStr, @Cached.Exclusive @Cached CastToJavaStringNode castJStr, @Cached.Shared(value="concatStr") @Cached TruffleString.ConcatNode concatStr, @Cached.Shared(value="acquireLib") @CachedLibrary(limit="2") PythonBufferAcquireLibrary acquireLib, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            TruffleString digestmod = castStr.execute(inliningTarget, digestmodObj);
            if (!acquireLib.hasBuffer(keyObj)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.A_BYTES_LIKE_OBJECT_IS_REQUIRED_NOT_P, keyObj);
            }
            Object key = acquireLib.acquireReadonly(keyObj);
            try {
                Object msg;
                if (msgObj instanceof PNone) {
                    msg = null;
                } else if (acquireLib.hasBuffer(msgObj)) {
                    msg = acquireLib.acquireReadonly(msgObj);
                } else {
                    throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.A_BYTES_LIKE_OBJECT_IS_REQUIRED_NOT_P, msgObj);
                }
                try {
                    byte[] msgBytes = msg == null ? null : bufferLib.getInternalOrCopiedByteArray(msg);
                    int msgLen = msg == null ? 0 : bufferLib.getBufferLength(msg);
                    Mac mac = HashlibModuleBuiltins.createMac(digestmod, bufferLib.getInternalOrCopiedByteArray(key), bufferLib.getBufferLength(key), msgBytes, msgLen);
                    DigestObject digestObject = this.factory().createDigestObject(PythonBuiltinClassType.HashlibHmac, castJStr.execute(concatStr.execute((AbstractTruffleString)HMAC_PREFIX, (AbstractTruffleString)digestmod, PythonUtils.TS_ENCODING, true)), mac);
                    return digestObject;
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw this.raise(PythonBuiltinClassType.UnsupportedDigestmodError, e);
                }
                finally {
                    if (msg != null) {
                        bufferLib.release(msg);
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                bufferLib.release(key);
            }
        }
    }

    @Builtin(name="hmac_digest", declaresExplicitSelf=true, parameterNames={"$mod", "key", "msg", "digest"})
    @GenerateNodeFactory
    static abstract class HmacDigestNode
    extends PythonQuaternaryBuiltinNode {
        HmacDigestNode() {
        }

        @Specialization
        Object hmacDigest(VirtualFrame frame, PythonModule self, Object key, Object msg, Object digest, @Cached HmacNewNode newNode2, @Cached DigestObjectBuiltins.DigestNode digestNode) {
            if (msg instanceof PNone) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.A_BYTES_LIKE_OBJECT_IS_REQUIRED_NOT_P, msg);
            }
            Object hmacObject = newNode2.execute(frame, self, key, msg, digest);
            return digestNode.execute(frame, hmacObject);
        }
    }

    @Builtin(name="compare_digest", parameterNames={"a", "b"})
    @GenerateNodeFactory
    static abstract class CompareDigestNode
    extends PythonBinaryBuiltinNode {
        CompareDigestNode() {
        }

        @Specialization(guards={"isString(a)", "isString(b)"})
        Object cmpStrings(Object a, Object b, @Bind(value="this") Node inliningTarget, @Cached TruffleString.CopyToByteArrayNode getByteArrayNode, @Cached TruffleString.GetCodeRangeNode getCodeRangeNode, @Cached CastToTruffleStringNode castA, @Cached CastToTruffleStringNode castB) {
            TruffleString tsA = castA.execute(inliningTarget, a);
            TruffleString tsB = castB.execute(inliningTarget, b);
            TruffleString.CodeRange crA = getCodeRangeNode.execute((AbstractTruffleString)tsA, PythonUtils.TS_ENCODING);
            TruffleString.CodeRange crB = getCodeRangeNode.execute((AbstractTruffleString)tsB, PythonUtils.TS_ENCODING);
            if (!crA.isSubsetOf(TruffleString.CodeRange.ASCII) || !crB.isSubsetOf(TruffleString.CodeRange.ASCII)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.COMPARING_STRINGS_WITH_NON_ASCII);
            }
            byte[] bytesA = getByteArrayNode.execute((AbstractTruffleString)tsA, PythonUtils.TS_ENCODING);
            byte[] bytesB = getByteArrayNode.execute((AbstractTruffleString)castB.execute(inliningTarget, b), PythonUtils.TS_ENCODING);
            return this.cmp(bytesA, bytesB);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isString(a) || !isString(b)"})
        boolean cmpBuffers(VirtualFrame frame, Object a, Object b, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary accessLib) {
            if (acquireLib.hasBuffer(a) && acquireLib.hasBuffer(b)) {
                Object bufferA = acquireLib.acquireReadonly(a, frame, this);
                try {
                    Object bufferB = acquireLib.acquireReadonly(b, frame, this);
                    try {
                        byte[] bytesA = accessLib.getInternalOrCopiedByteArray(bufferA);
                        byte[] bytesB = accessLib.getInternalOrCopiedByteArray(bufferB);
                        boolean bl = this.cmp(bytesA, bytesB);
                        accessLib.release(bufferB);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        accessLib.release(bufferB);
                        throw throwable;
                    }
                }
                finally {
                    accessLib.release(bufferA);
                }
            }
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_OR_COMBINATION_OF_TYPES, a, b);
        }

        @CompilerDirectives.TruffleBoundary
        boolean cmp(byte[] a, byte[] b) {
            return MessageDigest.isEqual(a, b);
        }
    }
}

