/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public final class PByteArray
extends PBytesLike {
    private volatile long exports;

    public PByteArray(Object cls, Shape instanceShape, byte[] bytes) {
        super(cls, instanceShape, bytes);
    }

    public PByteArray(Object cls, Shape instanceShape, SequenceStorage store) {
        super(cls, instanceShape, store);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.formatByteArray("bytearray");
    }

    @CompilerDirectives.TruffleBoundary
    public String formatByteArray(String typeName) {
        if (this.getSequenceStorage() instanceof ByteSequenceStorage) {
            byte[] barr = ((ByteSequenceStorage)this.getSequenceStorage()).getInternalByteArray();
            return String.format("%s(%s)", typeName, BytesUtils.bytesRepr(barr, barr.length));
        }
        return String.format("%s(%s)", typeName, this.getSequenceStorage());
    }

    public final void reverse() {
        this.store.reverse();
    }

    public long getExports() {
        return this.exports;
    }

    public void setExports(long exports) {
        this.exports = exports;
    }

    public void checkCanResize(PythonBuiltinBaseNode node) {
        if (this.exports != 0L) {
            throw node.raise(PythonBuiltinClassType.BufferError, ErrorMessages.EXPORTS_CANNOT_RESIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementModifiable(long index, @Cached.Exclusive @Cached IndexNodes.NormalizeIndexCustomMessageNode normalize, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            try {
                normalize.execute(index, len, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            catch (PException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementInsertable(long index, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            boolean bl = index == (long)len;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementRemovable(long index, @Cached.Exclusive @Cached IndexNodes.NormalizeIndexCustomMessageNode normalize, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int len = this.store.length();
            try {
                normalize.execute(index, len, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            catch (PException e) {
                boolean bl = false;
                gil.release(mustRelease);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void writeArrayElement(long index, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.SetItemScalarNode setItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                setItem.execute(inliningTarget, this.store, PInt.intValueExact(index), value);
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeArrayElement(long index, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.DeleteItemNode delItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                delItem.execute(inliningTarget, this.store, PInt.intValueExact(index));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeByte(this.store, byteOffset, value);
    }

    @ExportMessage
    void writeShort(int byteOffset, short value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeShort(this.store, byteOffset, value);
    }

    @ExportMessage
    void writeInt(int byteOffset, int value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeInt(this.store, byteOffset, value);
    }

    @ExportMessage
    void writeLong(int byteOffset, long value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeLong(this.store, byteOffset, value);
    }

    @ExportMessage
    void writeFloat(int byteOffset, float value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeFloat(this.store, byteOffset, value);
    }

    @ExportMessage
    void writeDouble(int byteOffset, double value, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeDouble(this.store, byteOffset, value);
    }
}

