/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public abstract class PBytesLike
extends PSequence {
    protected SequenceStorage store;

    public PBytesLike(Object cls, Shape instanceShape, byte[] bytes) {
        super(cls, instanceShape);
        this.store = new ByteSequenceStorage(bytes);
    }

    public PBytesLike(Object cls, Shape instanceShape, SequenceStorage store) {
        super(cls, instanceShape);
        this.store = store;
    }

    @Override
    public final SequenceStorage getSequenceStorage() {
        return this.store;
    }

    @Override
    public void setSequenceStorage(SequenceStorage store) {
        assert (store instanceof ByteSequenceStorage || store instanceof NativeByteSequenceStorage);
        this.store = store;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    Object acquire(int flags) {
        return this;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.getBufferLength(this.store);
    }

    @ExportMessage
    boolean hasInternalByteArray(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.hasInternalByteArray(this.store);
    }

    @ExportMessage
    byte[] getInternalByteArray(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.getInternalByteArray(this.store);
    }

    @ExportMessage
    byte readByte(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readByte(this.store, byteOffset);
    }

    @ExportMessage
    short readShort(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readShort(this.store, byteOffset);
    }

    @ExportMessage
    int readInt(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readInt(this.store, byteOffset);
    }

    @ExportMessage
    long readLong(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readLong(this.store, byteOffset);
    }

    @ExportMessage
    float readFloat(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readFloat(this.store, byteOffset);
    }

    @ExportMessage
    double readDouble(int byteOffset, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readDouble(this.store, byteOffset);
    }
}

