/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.capsule;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PyCapsule
extends PythonBuiltinObject {
    private Object pointer;
    private Object name;
    private Object context;
    private Object destructor;

    public PyCapsule(PythonLanguage lang, Object pointer, Object name, Object destructor) {
        super((Object)PythonBuiltinClassType.Capsule, PythonBuiltinClassType.Capsule.getInstanceShape(lang));
        this.pointer = pointer;
        this.name = name;
        this.context = null;
        this.destructor = destructor;
    }

    public Object getPointer() {
        return this.pointer;
    }

    public void setPointer(Object pointer) {
        this.pointer = pointer;
    }

    public Object getName() {
        return this.name;
    }

    public void setName(Object name) {
        this.name = name;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public Object getDestructor() {
        return this.destructor;
    }

    public void setDestructor(Object destructor) {
        this.destructor = destructor;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public String toDisplayString(boolean allowSideEffects) {
        String n;
        String quote;
        if (this.name != null) {
            quote = "\"";
            n = this.name instanceof TruffleString ? ((TruffleString)this.getName()).toJavaStringUncached() : CastToJavaStringNode.getUncached().execute(CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(this.name, false));
        } else {
            quote = "";
            n = "NULL";
        }
        return String.format("<capsule object %s%s%s at %x>", quote, n, quote, this.hashCode());
    }
}

