/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.AccumulateBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PAccumulate;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PAccumulate})
public final class AccumulateBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AccumulateBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PAccumulate self, Object state) {
            self.setTotal(state);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"hasFunc(self)"})
        Object reduce(VirtualFrame frame, PAccumulate self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClassNode, @Cached @Cached.Shared InlinedBranchProfile hasInitialProfile, @Cached @Cached.Shared InlinedBranchProfile totalNoneProfile, @Cached @Cached.Shared InlinedBranchProfile totalMarkerProfile, @Cached @Cached.Shared InlinedBranchProfile elseProfile, @Cached @Cached.Shared PyObjectGetIter getIter) {
            return this.reduce(inliningTarget, self, self.getFunc(), hasInitialProfile, getClassNode, totalNoneProfile, getIter, frame, totalMarkerProfile, elseProfile);
        }

        @Specialization(guards={"!hasFunc(self)"})
        Object reduceNoFunc(VirtualFrame frame, PAccumulate self, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared GetClassNode getClassNode, @Cached @Cached.Shared InlinedBranchProfile hasInitialProfile, @Cached @Cached.Shared InlinedBranchProfile totalNoneProfile, @Cached @Cached.Shared InlinedBranchProfile totalMarkerProfile, @Cached @Cached.Shared InlinedBranchProfile elseProfile, @Cached @Cached.Shared PyObjectGetIter getIter) {
            return this.reduce(inliningTarget, self, PNone.NONE, hasInitialProfile, getClassNode, totalNoneProfile, getIter, frame, totalMarkerProfile, elseProfile);
        }

        private Object reduce(Node inliningTarget, PAccumulate self, Object func, InlinedBranchProfile hasInitialProfile, GetClassNode getClassNode, InlinedBranchProfile totalNoneProfile, PyObjectGetIter getIter, VirtualFrame frame, InlinedBranchProfile totalMarkerProfile, InlinedBranchProfile elseProfile) {
            if (self.getInitial() != null) {
                hasInitialProfile.enter(inliningTarget);
                Object type = getClassNode.execute(inliningTarget, self);
                PChain chain = this.factory().createChain((Object)PythonBuiltinClassType.PChain);
                chain.setSource(getIter.execute((Frame)frame, inliningTarget, this.factory().createList(new Object[]{self.getIterable()})));
                PTuple initialTuple = this.factory().createTuple(new Object[]{self.getInitial()});
                chain.setActive(getIter.execute((Frame)frame, inliningTarget, initialTuple));
                PTuple tuple = this.factory().createTuple(new Object[]{chain, func});
                return this.factory().createTuple(new Object[]{type, tuple, PNone.NONE});
            }
            if (self.getTotal() == PNone.NONE) {
                totalNoneProfile.enter(inliningTarget);
                PChain chain = this.factory().createChain((Object)PythonBuiltinClassType.PChain);
                PList noneList = this.factory().createList(new Object[]{PNone.NONE});
                Object noneIter = getIter.execute((Frame)frame, inliningTarget, noneList);
                chain.setSource(getIter.execute((Frame)frame, inliningTarget, this.factory().createList(new Object[]{noneIter, self.getIterable()})));
                chain.setActive(PNone.NONE);
                PAccumulate accumulate = this.factory().createAccumulate((Object)PythonBuiltinClassType.PAccumulate);
                accumulate.setIterable(chain);
                accumulate.setFunc(func);
                PTuple tuple = this.factory().createTuple(new Object[]{accumulate, 1, PNone.NONE});
                return this.factory().createTuple(new Object[]{PythonBuiltinClassType.PIslice, tuple});
            }
            if (self.getTotal() != null) {
                totalMarkerProfile.enter(inliningTarget);
                Object type = getClassNode.execute(inliningTarget, self);
                PTuple tuple = this.factory().createTuple(new Object[]{self.getIterable(), func});
                return this.factory().createTuple(new Object[]{type, tuple, self.getTotal()});
            }
            elseProfile.enter(inliningTarget);
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = this.factory().createTuple(new Object[]{self.getIterable(), func});
            return this.factory().createTuple(new Object[]{type, tuple});
        }

        protected static boolean hasFunc(PAccumulate self) {
            return self.getFunc() != null;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PAccumulate self, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.NextNode nextNode, @Cached BinaryArithmetic.AddNode addNode, @Cached CallNode callNode, @Cached InlinedBranchProfile hasInitialProfile, @Cached InlinedBranchProfile markerProfile, @Cached InlinedConditionProfile hasFuncProfile) {
            if (self.getInitial() != null) {
                hasInitialProfile.enter(inliningTarget);
                self.setTotal(self.getInitial());
                self.setInitial(null);
                return self.getTotal();
            }
            Object value = nextNode.execute(frame, self.getIterable(), PNone.NO_VALUE);
            if (self.getTotal() == null) {
                markerProfile.enter(inliningTarget);
                self.setTotal(value);
                return value;
            }
            if (hasFuncProfile.profile(inliningTarget, self.getFunc() == null)) {
                self.setTotal(addNode.executeObject(frame, self.getTotal(), value));
            } else {
                self.setTotal(callNode.execute(self.getFunc(), self.getTotal(), value));
            }
            return self.getTotal();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PAccumulate self) {
            return self;
        }
    }
}

