/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.module;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.io.InputStream;

public final class PythonFrozenModule {
    private final TruffleString name;
    private final byte[] code;
    private final boolean isPackage;

    private static byte[] getByteCode(String symbol) {
        try {
            InputStream resourceAsStream = PythonFrozenModule.class.getResourceAsStream("Frozen" + symbol + ".bin");
            if (resourceAsStream != null) {
                return resourceAsStream.readAllBytes();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public PythonFrozenModule(String symbol, String name, boolean isPackage) {
        this(PythonUtils.toTruffleStringUncached(name), PythonFrozenModule.getByteCode(symbol), isPackage);
    }

    private PythonFrozenModule(TruffleString name, byte[] code, boolean isPackage) {
        this.name = name;
        this.code = code;
        this.isPackage = isPackage;
    }

    public PythonFrozenModule asPackage(boolean flag) {
        if (flag == this.isPackage) {
            return this;
        }
        return new PythonFrozenModule(this.name, this.code, flag);
    }

    public TruffleString getName() {
        return this.name;
    }

    public byte[] getCode() {
        return this.code;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public int getSize() {
        return this.code != null ? this.code.length : 0;
    }
}

